/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.domainmodel;

import com.helpshift.account.domainmodel.IUserSyncExecutor;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserSyncStatus;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.One;
import com.helpshift.common.domain.Poller;
import com.helpshift.common.domain.idempotent.AllStatusCodeIdempotentPolicy;
import com.helpshift.common.domain.idempotent.SuccessOrNonRetriableStatusCodeIdempotentPolicy;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.MetaCorrectedNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.PUTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.ConversationInboxPoller;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.CreatePreIssueDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationHistoryDM;
import com.helpshift.conversation.activeconversation.ConversationUpdate;
import com.helpshift.conversation.activeconversation.LiveUpdateDM;
import com.helpshift.conversation.activeconversation.SingleConversationDM;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.PushNotificationData;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.ConversationInbox;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.loaders.ConversationHistoryLoader;
import com.helpshift.conversation.loaders.RemoteConversationLoader;
import com.helpshift.conversation.loaders.SingleConversationLoader;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.conversation.util.predicate.ConversationPredicates;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.faq.domainmodel.FAQSearchDM;
import com.helpshift.providers.ICampaignsModuleAPIs;
import com.helpshift.util.Filters;
import com.helpshift.util.HSLogger;
import com.helpshift.util.ValuePair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ConversationInboxDM
implements AutoRetriableDM,
IUserSyncExecutor {
    public static final long PRE_ISSUE_RESET_TIMEOUT = 86400000L;
    private static final long ACTIVE_ISSUE_NOTIFICATION_COUNT_TIMEOUT = 60000L;
    private static final long INACTIVE_ISSUES_NOTIFICATION_COUNT_TIMEOUT = 300000L;
    private long lastNotifCountFetchTime = 0L;
    public static final long MESSAGES_PAGE_SIZE = 100L;
    static final Object fetchConversationUpdatesLock = new Object();
    private static final String CREATE_ISSUE_ROUTE = "/issues/";
    private static final String CREATE_PRE_ISSUE_ROUTE = "/preissues/";
    private static final String CREATE_ISSUE_UNIQUE_MAPPING_KEY = "issue_default_unique_key";
    private static final String CREATE_PRE_ISSUE_UNIQUE_MAPPING_KEY = "preissue_default_unique_key";
    private static final String TAG = "Helpshift_ConvInboxDM";
    final Platform platform;
    final UserDM userDM;
    final Domain domain;
    final ConversationDAO conversationDAO;
    private final ConversationInboxDAO conversationInboxDAO;
    private final FAQSearchDM faqSearchDM;
    private final SDKConfigurationDM sdkConfigurationDM;
    private final LiveUpdateDM liveUpdateDM;
    private final ConversationInboxPoller conversationInboxPoller;
    public AtomicReference<FetchDataFromThread<Integer, Integer>> fetchConversationUpdatesListenerReference = null;
    HashMap<Long, One> inProgressPreIssueCreators = new HashMap();
    private WeakReference<StartNewConversationListener> startNewConversationListenerRef;
    private boolean shouldDropCustomMetadata;
    private boolean isCreateConversationInProgress;
    private boolean userCanReadMessages;
    private int conversationViewState = -1;
    private Map<ViewableConversation, Long> aliveConversationDMs = Collections.synchronizedMap(new WeakHashMap());
    private long lastAliveConversationLocalId = 0L;
    private RemoteConversationLoader remoteConversationLoader;
    private Map<String, Integer> inAppNotificationMessageCountMap = new ConcurrentHashMap<String, Integer>();

    public ConversationInboxDM(Platform platform, Domain domain, UserDM userDM) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
        this.conversationInboxDAO = platform.getConversationInboxDAO();
        this.conversationDAO = platform.getConversationDAO();
        this.faqSearchDM = platform.getFAQSearchDM();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.conversationInboxPoller = new ConversationInboxPoller(userDM, this.sdkConfigurationDM, this.getPoller(), this.conversationDAO);
        this.liveUpdateDM = new LiveUpdateDM(domain, platform);
        this.remoteConversationLoader = new RemoteConversationLoader(platform, domain, userDM);
    }

    public void initialize() {
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.CONVERSATION, this);
        if (this.userDM.getSyncState() == UserSyncStatus.COMPLETED) {
            this.userDM.addObserver(this.getConversationInboxPoller());
        }
    }

    public ConversationInboxPoller getConversationInboxPoller() {
        return this.conversationInboxPoller;
    }

    void deleteAllConversationsData() {
        this.deleteConversationsAndMessages();
        long userLocalId = this.userDM.getLocalId();
        this.conversationInboxDAO.deleteUserData(userLocalId);
    }

    private void deleteConversationsAndMessages() {
        long userLocalId = this.userDM.getLocalId();
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(userLocalId);
        for (ConversationDM conversationDM : conversations) {
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            conversationDM.deleteCachedScreenshotFiles();
        }
        this.conversationDAO.deleteConversations(userLocalId);
    }

    private Poller getPoller() {
        return new Poller(this.domain, new F(){

            @Override
            public synchronized void f() {
                ConversationInboxDM.this.fetchConversationUpdates();
            }
        });
    }

    @Override
    public void sendFailedApiCalls(AutoRetryFailedEventDM.EventType eventType) {
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        for (ConversationDM conversation : conversations) {
            ViewableConversation viewableConversation = this.getInMemoryConversationDM(conversation.localId);
            if (viewableConversation != null) {
                this.retryCallsForConversation(viewableConversation.getActiveConversation(), true);
                continue;
            }
            this.retryCallsForConversation(conversation, false);
        }
    }

    private void retryCallsForConversation(ConversationDM conversation, boolean isActive) {
        block3: {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
            conversation.retryMessages(isActive);
            if (conversation.csatState == ConversationCSATState.SUBMITTED_NOT_SYNCED) {
                try {
                    conversation.sendCSATSurveyInternal();
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) break block3;
                    throw e;
                }
            }
        }
    }

    public void setUserCanReadMessages(boolean userCanReadMessages) {
        this.userCanReadMessages = userCanReadMessages;
    }

    public ConversationDetailDTO getConversationDetail() {
        return this.conversationInboxDAO.getDescriptionDetail(this.userDM.getLocalId());
    }

    public String getConversationArchivalPrefillText() {
        return this.conversationInboxDAO.getConversationArchivalPrefillText(this.userDM.getLocalId());
    }

    public void saveDescriptionDetail(String value, int type) {
        this.conversationInboxDAO.saveDescriptionDetail(this.userDM.getLocalId(), new ConversationDetailDTO(value, System.nanoTime(), type));
    }

    public void saveName(String name) {
        this.conversationInboxDAO.saveName(this.userDM.getLocalId(), name);
    }

    public void saveEmail(String email) {
        this.conversationInboxDAO.saveEmail(this.userDM.getLocalId(), email);
    }

    public String getName() {
        String name = this.conversationInboxDAO.getName(this.userDM.getLocalId());
        if (StringUtils.isEmpty(name)) {
            name = this.userDM.getName();
        }
        return name;
    }

    public String getEmail() {
        String email = this.conversationInboxDAO.getEmail(this.userDM.getLocalId());
        if (StringUtils.isEmpty(email)) {
            email = this.userDM.getEmail();
        }
        return email;
    }

    public void saveImageAttachmentDraft(ImagePickerFile imageAttachmentDraft) {
        this.conversationInboxDAO.saveImageAttachment(this.userDM.getLocalId(), imageAttachmentDraft);
    }

    public void saveLastConversationsRedactionTime(long lastRedactionAtTime) {
        this.conversationInboxDAO.saveLastConversationsRedactionTime(this.userDM.getLocalId(), lastRedactionAtTime);
    }

    public Long getLastConversationsRedactionTime() {
        return this.conversationInboxDAO.getLastConversationsRedactionTime(this.userDM.getLocalId());
    }

    public ImagePickerFile getImageAttachmentDraft() {
        return this.conversationInboxDAO.getImageAttachment(this.userDM.getLocalId());
    }

    public void saveUserReplyText(String replyText) {
        this.conversationInboxDAO.saveUserReplyDraft(this.userDM.getLocalId(), replyText);
    }

    public String getUserReplyText() {
        return this.conversationInboxDAO.getUserReplyDraft(this.userDM.getLocalId());
    }

    public ArrayList getFAQSearchResults(String text) {
        return this.faqSearchDM.getSearchResults(text);
    }

    public void triggerFAQSearchIndexing() {
        this.faqSearchDM.startFAQSearchIndexing();
    }

    public void setShouldDropCustomMetadata(boolean shouldDropCustomMetadata) {
        this.shouldDropCustomMetadata = shouldDropCustomMetadata;
    }

    public void registerStartNewConversationListener(StartNewConversationListener listener) {
        this.startNewConversationListenerRef = new WeakReference<StartNewConversationListener>(listener);
    }

    public void unregisterStartNewConversationListener(StartNewConversationListener listener) {
        if (this.startNewConversationListenerRef != null && this.startNewConversationListenerRef.get() == listener) {
            this.startNewConversationListenerRef = new WeakReference<Object>(null);
        }
    }

    public void startNewConversation(String description, String userProvidedName, String userProvidedEmail, ImagePickerFile imagePickerFile) {
        CreateConversationStateHolder holder = new CreateConversationStateHolder(description, userProvidedName, userProvidedEmail, imagePickerFile);
        this.domain.runParallel(holder.getStartNewConversationInternalF());
    }

    void startNewConversationInternal(String description, String userProvidedName, String userProvidedEmail, ImagePickerFile imagePickerFile) {
        this.isCreateConversationInProgress = true;
        ConversationDM conversationDM = this.tryToStartNewConversation(description, userProvidedName, userProvidedEmail);
        SingleConversationLoader singleConversationLoader = new SingleConversationLoader(this.platform, this.userDM, conversationDM.localId, this.remoteConversationLoader, 100L);
        SingleConversationDM singleConversationDM = new SingleConversationDM(this.platform, this.domain, this.userDM, singleConversationLoader);
        singleConversationDM.init();
        singleConversationDM.setLiveUpdateDM(this.liveUpdateDM);
        this.setAliveConversation(singleConversationDM);
        this.checkAndTryToUploadImage(conversationDM, imagePickerFile);
        this.isCreateConversationInProgress = false;
        if (this.startNewConversationListenerRef != null && this.startNewConversationListenerRef.get() != null) {
            ((StartNewConversationListener)this.startNewConversationListenerRef.get()).onCreateConversationSuccess(conversationDM.localId);
        }
    }

    private synchronized void setAliveConversation(ViewableConversation viewableConversation) {
        this.lastAliveConversationLocalId = viewableConversation.getIdentifier();
        this.aliveConversationDMs.put(viewableConversation, this.lastAliveConversationLocalId);
    }

    private ConversationDM tryToStartNewConversation(String description, String userProvidedName, String userProvidedEmail) {
        try {
            ConversationDM newConversationDM = this.createConversation(description, userProvidedName, userProvidedEmail);
            this.saveDescriptionDetail("", 0);
            if (!this.sdkConfigurationDM.shouldCreateConversationAnonymously()) {
                this.saveName(userProvidedName);
                this.saveEmail(userProvidedEmail);
            }
            this.conversationInboxDAO.saveConversationArchivalPrefillText(this.userDM.getLocalId(), null);
            this.checkAndDropCustomMeta(newConversationDM);
            this.sendConversationPostedEvent(newConversationDM.serverId);
            this.domain.getDelegate().newConversationStarted(description);
            return newConversationDM;
        }
        catch (Exception e) {
            this.isCreateConversationInProgress = false;
            if (this.startNewConversationListenerRef.get() != null) {
                ((StartNewConversationListener)this.startNewConversationListenerRef.get()).onCreateConversationFailure(e);
            }
            throw e;
        }
    }

    private void checkAndDropCustomMeta(ConversationDM conversationDM) {
        if (this.shouldDropCustomMetadata) {
            conversationDM.dropCustomMetaData();
        }
    }

    private void checkAndTryToUploadImage(ConversationDM conversationDM, ImagePickerFile imagePickerFile) {
        if (imagePickerFile != null && imagePickerFile.filePath != null) {
            try {
                conversationDM.sendScreenshot(imagePickerFile, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveImageAttachmentDraft(null);
        }
    }

    private void sendConversationPostedEvent(String conversationServerId) {
        this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.CONVERSATION_POSTED, conversationServerId);
    }

    public ConversationDM createConversation(String description, String userProvidedName, String userProvidedEmail) {
        this.domain.getUserManagerDM().registerUserWithServer(this.userDM);
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        String userProvidedEmails = this.platform.getJsonifier().jsonify(Collections.singletonList(userProvidedEmail));
        data.put("user_provided_emails", userProvidedEmails.toString());
        data.put("user_provided_name", userProvidedName);
        data.put("body", description);
        data.put("cuid", this.getCampaignUID());
        data.put("cdid", this.getCampaignDID());
        data.put("device_language", this.domain.getLocaleProviderDM().getDefaultLanguage());
        String developerSetLanguage = this.domain.getLocaleProviderDM().getSDKLanguage();
        if (!StringUtils.isEmpty(developerSetLanguage)) {
            data.put("developer_set_language", developerSetLanguage);
        }
        data.put("meta", this.domain.getMetaDataDM().getMetaInfo().toString());
        boolean isFullPrivacyEnabled = this.sdkConfigurationDM.getBoolean("fullPrivacy");
        Object customIssueFields = this.domain.getCustomIssueFieldDM().getCustomIssueFieldData();
        if (customIssueFields != null) {
            data.put("custom_fields", customIssueFields.toString());
        }
        Network startConversationNetwork = new POSTNetwork(CREATE_ISSUE_ROUTE, this.domain, this.platform);
        AllStatusCodeIdempotentPolicy idempotentPolicy = new AllStatusCodeIdempotentPolicy();
        startConversationNetwork = new IdempotentNetwork(startConversationNetwork, this.platform, idempotentPolicy, CREATE_ISSUE_ROUTE, CREATE_ISSUE_UNIQUE_MAPPING_KEY);
        startConversationNetwork = new AuthenticationFailureNetwork(startConversationNetwork);
        startConversationNetwork = new TSCorrectedNetwork(startConversationNetwork, this.platform);
        startConversationNetwork = new MetaCorrectedNetwork(startConversationNetwork, this.platform);
        startConversationNetwork = new GuardOKNetwork(startConversationNetwork);
        try {
            RequestData requestData = new RequestData(data);
            Response response = startConversationNetwork.makeRequest(requestData);
            ConversationDM conversation = this.platform.getResponseParser().parseReadableConversation(response.responseString);
            conversation.wasFullPrivacyEnabledAtCreation = isFullPrivacyEnabled;
            conversation.setDependencies(this.platform, this.domain, this.userDM);
            ConversationDM localConversation = this.conversationDAO.readConversationWithoutMessages(conversation.serverId);
            if (localConversation == null) {
                this.conversationDAO.insertConversation(conversation);
            }
            this.domain.getUserManagerDM().updateIssueExists(this.userDM, true);
            this.domain.getUserManagerDM().sendPushToken();
            this.conversationInboxPoller.startAppPoller(true);
            return conversation;
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
            }
            throw e;
        }
    }

    public void deletePreIssueIfNotCreated(ViewableConversation viewableConversation) {
        ConversationDM activeConversation = viewableConversation.getActiveConversation();
        if (!viewableConversation.isConversationVMAttached() && activeConversation.isInPreIssueMode() && StringUtils.isEmpty(activeConversation.preConversationServerId) && this.inProgressPreIssueCreators.get(activeConversation.localId) == null) {
            this.conversationDAO.deleteConversation(activeConversation.localId);
        }
    }

    public void createPreIssue(final ViewableConversation viewableConversation, StartNewConversationListener listener) {
        final ConversationDM activeConversation = viewableConversation.getActiveConversation();
        One inProgressPreIssueCreation = this.inProgressPreIssueCreators.get(activeConversation.localId);
        if (inProgressPreIssueCreation != null) {
            HSLogger.d(TAG, "Pre issue creation already in progress: " + activeConversation.localId);
            CreatePreIssueDM createPreIssueDM = (CreatePreIssueDM)inProgressPreIssueCreation.getF();
            createPreIssueDM.setListener(listener);
            return;
        }
        CreatePreIssueDM createPreIssueDM = new CreatePreIssueDM(this, activeConversation, this.sdkConfigurationDM, listener);
        final One createPreIssue = new One(createPreIssueDM);
        this.inProgressPreIssueCreators.put(activeConversation.localId, createPreIssue);
        this.domain.runParallel(new F(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f() {
                try {
                    Object object = fetchConversationUpdatesLock;
                    synchronized (object) {
                        createPreIssue.f();
                    }
                }
                finally {
                    ConversationInboxDM.this.inProgressPreIssueCreators.remove(activeConversation.localId);
                    ConversationInboxDM.this.deletePreIssueIfNotCreated(viewableConversation);
                }
            }
        });
    }

    public void createPreIssueNetwork(ConversationDM conversationDM, String greetingMessage) {
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        String developerProvidedName = this.userDM.getName();
        String developerProvidedEmail = this.userDM.getEmail();
        if (!StringUtils.isEmpty(developerProvidedName)) {
            data.put("name", developerProvidedName);
        }
        if (!StringUtils.isEmpty(developerProvidedEmail)) {
            data.put("email", developerProvidedEmail);
        }
        data.put("cuid", this.getCampaignUID());
        data.put("cdid", this.getCampaignDID());
        data.put("device_language", this.domain.getLocaleProviderDM().getDefaultLanguage());
        String developerSetLanguage = this.domain.getLocaleProviderDM().getSDKLanguage();
        if (!StringUtils.isEmpty(developerSetLanguage)) {
            data.put("developer_set_language", developerSetLanguage);
        }
        Object metaInfoJson = this.domain.getMetaDataDM().getMetaInfo();
        data.put("meta", metaInfoJson.toString());
        boolean isFullPrivacyEnabled = this.sdkConfigurationDM.getBoolean("fullPrivacy");
        Object customIssueFields = this.domain.getCustomIssueFieldDM().getCustomIssueFieldData();
        if (customIssueFields != null) {
            data.put("custom_fields", customIssueFields.toString());
        }
        if (!StringUtils.isEmpty(greetingMessage)) {
            data.put("greeting", greetingMessage);
        }
        Network startPreConversationNetwork = new POSTNetwork(CREATE_PRE_ISSUE_ROUTE, this.domain, this.platform);
        SuccessOrNonRetriableStatusCodeIdempotentPolicy idempotentPolicy = new SuccessOrNonRetriableStatusCodeIdempotentPolicy();
        startPreConversationNetwork = new IdempotentNetwork(startPreConversationNetwork, this.platform, idempotentPolicy, CREATE_PRE_ISSUE_ROUTE, CREATE_PRE_ISSUE_UNIQUE_MAPPING_KEY);
        startPreConversationNetwork = new AuthenticationFailureNetwork(startPreConversationNetwork);
        startPreConversationNetwork = new TSCorrectedNetwork(startPreConversationNetwork, this.platform);
        startPreConversationNetwork = new MetaCorrectedNetwork(startPreConversationNetwork, this.platform);
        startPreConversationNetwork = new GuardOKNetwork(startPreConversationNetwork);
        RequestData requestData = new RequestData(data);
        try {
            Response response = startPreConversationNetwork.makeRequest(requestData);
            ConversationDM conversation = this.platform.getResponseParser().parseReadableConversation(response.responseString);
            if (conversationDM.serverId == null) {
                conversationDM.serverId = conversation.serverId;
            }
            conversationDM.title = conversation.title;
            conversationDM.setCreatedAt(conversation.getCreatedAt());
            conversationDM.setEpochCreatedAtTime(conversation.getEpochCreatedAtTime());
            conversationDM.updatedAt = conversation.updatedAt;
            conversationDM.publishId = conversation.publishId;
            conversationDM.showAgentName = conversation.showAgentName;
            conversationDM.state = conversation.state;
            conversationDM.wasFullPrivacyEnabledAtCreation = isFullPrivacyEnabled;
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            if (StringUtils.isEmpty(conversationDM.preConversationServerId)) {
                conversationDM.messageDMs = conversation.messageDMs;
                for (MessageDM message : conversationDM.messageDMs) {
                    message.conversationLocalId = conversationDM.localId;
                    message.deliveryState = 1;
                }
            }
            conversationDM.preConversationServerId = conversation.preConversationServerId;
            this.domain.getUserManagerDM().updateIssueExists(this.userDM, true);
            this.domain.getUserManagerDM().sendPushToken();
            this.conversationDAO.updateConversation(conversationDM);
            this.domain.getDelegate().newConversationStarted("");
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
            }
            throw e;
        }
    }

    private String getCampaignUID() {
        ICampaignsModuleAPIs campaignsDataProvider = this.platform.getCampaignModuleAPIs();
        if (campaignsDataProvider == null) {
            return null;
        }
        return campaignsDataProvider.getUserIdentifier();
    }

    private String getCampaignDID() {
        ICampaignsModuleAPIs campaignsModuleAPIs = this.platform.getCampaignModuleAPIs();
        if (campaignsModuleAPIs == null) {
            return null;
        }
        return campaignsModuleAPIs.getDeviceIdentifier();
    }

    public boolean isCreateConversationInProgress() {
        return this.isCreateConversationInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationInbox fetchConversationUpdates() {
        Object object = fetchConversationUpdatesLock;
        synchronized (object) {
            String lastCursor = this.conversationInboxDAO.getConversationInboxTimestamp(this.userDM.getLocalId());
            return this.fetchConversationUpdatesInternal(lastCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationInbox fetchInitialConversationUpdates() {
        Object object = fetchConversationUpdatesLock;
        synchronized (object) {
            return this.fetchConversationUpdatesInternal(null);
        }
    }

    private Network buildForwardPollerNetwork() {
        Network network = new POSTNetwork("/conversations/updates/", this.domain, this.platform);
        network = new AuthenticationFailureNetwork(network);
        network = new FailedAPICallNetworkDecorator(network);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new GuardOKNetwork(network);
        return network;
    }

    private RequestData buildForwardPollerRequestData(String lastCursor) {
        ConversationDM conversationDM;
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        if (!StringUtils.isEmpty(lastCursor)) {
            data.put("cursor", lastCursor);
        }
        if ((conversationDM = this.getLastViewableSyncedConversation()) != null) {
            if (!StringUtils.isEmpty(conversationDM.serverId)) {
                data.put("issue_id", conversationDM.serverId);
            } else if (!StringUtils.isEmpty(conversationDM.preConversationServerId)) {
                data.put("preissue_id", conversationDM.preConversationServerId);
            }
        }
        data.put("ucrm", String.valueOf(this.userCanReadMessages));
        return new RequestData(data);
    }

    private ConversationInbox fetchConversationUpdatesInternal(String lastCursor) {
        ConversationInbox conversationInbox;
        Network network = this.buildForwardPollerNetwork();
        RequestData requestData = this.buildForwardPollerRequestData(lastCursor);
        try {
            Response response = network.makeRequest(requestData);
            ResponseParser responseParser = this.platform.getResponseParser();
            conversationInbox = responseParser.parseConversationInbox(response.responseString);
        }
        catch (RootAPIException e) {
            ViewableConversation viewableConversation;
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
            } else if (e.exceptionType instanceof NetworkException && (viewableConversation = this.getAliveConversationDM()) != null && viewableConversation.isVisibleOnUI()) {
                viewableConversation.getConversationVMCallback().onConversationInboxPollFailure();
            }
            throw e;
        }
        this.domain.getUserManagerDM().updateIssueExists(this.userDM, conversationInbox.issueExists);
        if (!requestData.body.containsKey("cursor") && conversationInbox.hasOlderMessages != null) {
            this.conversationInboxDAO.saveHasOlderMessages(this.userDM.getLocalId(), conversationInbox.hasOlderMessages);
        }
        this.merge(conversationInbox.conversations);
        this.conversationInboxDAO.saveConversationInboxTimestamp(this.userDM.getLocalId(), conversationInbox.cursor);
        return conversationInbox;
    }

    private void merge(List<ConversationDM> serverConversations) {
        if (ListUtils.isEmpty(serverConversations)) {
            return;
        }
        List<ConversationDM> localConversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        HashSet<ConversationDM> convToUpdate = new HashSet<ConversationDM>();
        HashMap<Long, ConversationUpdate> conversationUpdateMap = new HashMap<Long, ConversationUpdate>();
        HashSet<ConversationDM> newConvToInsert = new HashSet<ConversationDM>();
        if (serverConversations.size() > 1) {
            ConversationUtil.sortConversationsBasedOnCreatedAt(serverConversations);
        }
        this.merge(localConversations, serverConversations, convToUpdate, newConvToInsert, conversationUpdateMap);
        this.clearRequestIdForPendingCreateConversationCall(serverConversations);
        this.putConversations(convToUpdate, newConvToInsert, conversationUpdateMap);
        for (ConversationDM conversationDM : convToUpdate) {
            conversationDM.clearMessageUpdates((ConversationUpdate)conversationUpdateMap.get(conversationDM.localId));
        }
        ArrayList<ConversationDM> mergedConversations = new ArrayList<ConversationDM>();
        mergedConversations.addAll(convToUpdate);
        mergedConversations.addAll(newConvToInsert);
        this.checkForReOpen(mergedConversations);
        this.markStatusAsResolutionAcceptedIfResolved(convToUpdate);
        if (!this.userDM.isPushTokenSynced() && this.sdkConfigurationDM.getBoolean("enableInAppNotification")) {
            this.checkAndGenerateNotification(mergedConversations);
        }
        this.sendUnreadCountUpdate();
    }

    private void sendUnreadCountUpdate() {
        FetchDataFromThread<Integer, Integer> fetchConversationUpdatesListener;
        if (this.fetchConversationUpdatesListenerReference != null && (fetchConversationUpdatesListener = this.fetchConversationUpdatesListenerReference.get()) != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    fetchConversationUpdatesListener.onDataFetched(ConversationInboxDM.this.getNotificationCountSync());
                }
            });
        }
    }

    private void markStatusAsResolutionAcceptedIfResolved(Collection<ConversationDM> conversationDMs) {
        for (ConversationDM conversationDM : conversationDMs) {
            IssueState state = conversationDM.state;
            if (state != IssueState.RESOLUTION_REQUESTED || conversationDM.isInPreIssueMode() || this.sdkConfigurationDM.shouldShowConversationResolutionQuestion()) continue;
            conversationDM.markConversationResolutionStatus(true);
        }
    }

    private void clearRequestIdForPendingCreateConversationCall(List<ConversationDM> serverConversations) {
        String pendingCreateIssueRequestId = this.platform.getNetworkRequestDAO().getPendingRequestId(CREATE_ISSUE_ROUTE, CREATE_ISSUE_UNIQUE_MAPPING_KEY);
        String pendingCreatePreIssueRequestId = this.platform.getNetworkRequestDAO().getPendingRequestId(CREATE_PRE_ISSUE_ROUTE, CREATE_PRE_ISSUE_UNIQUE_MAPPING_KEY);
        if (pendingCreateIssueRequestId != null || pendingCreatePreIssueRequestId != null) {
            for (ConversationDM serverConversation : serverConversations) {
                if (serverConversation.createdRequestId == null) continue;
                if (serverConversation.createdRequestId.equals(pendingCreateIssueRequestId)) {
                    this.platform.getNetworkRequestDAO().deletePendingRequestId(CREATE_ISSUE_ROUTE, CREATE_ISSUE_UNIQUE_MAPPING_KEY);
                    continue;
                }
                if (!serverConversation.createdRequestId.equals(pendingCreatePreIssueRequestId)) continue;
                this.platform.getNetworkRequestDAO().deletePendingRequestId(CREATE_PRE_ISSUE_ROUTE, CREATE_PRE_ISSUE_UNIQUE_MAPPING_KEY);
            }
        }
    }

    private ViewableConversation getAliveConversationDM() {
        return this.getInMemoryConversationDM(this.lastAliveConversationLocalId);
    }

    private void checkAndGenerateNotification(List<ConversationDM> conversationDMs) {
        for (ConversationDM conversationDM : conversationDMs) {
            if (!this.shouldShowInAppNotification(conversationDM)) continue;
            int messageCount = this.getMessageCountForShowingInAppNotification(conversationDM);
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            this.showInAppNotification(conversationDM, messageCount);
        }
    }

    private void showInAppNotification(ConversationDM conversationDM, int messageCount) {
        if (messageCount > 0) {
            this.showNotificationOnUI(conversationDM.localId, conversationDM.localUUID, messageCount, this.platform.getDevice().getAppName());
            this.updateInAppNotificationCountCache(conversationDM.localUUID, messageCount);
        }
    }

    private int getInAppNotificationCountCache(String conversationLocalUUID) {
        Integer count = this.inAppNotificationMessageCountMap.get(conversationLocalUUID);
        if (count == null) {
            return -1;
        }
        return count;
    }

    private void updateInAppNotificationCountCache(String conversationLocalUUID, int messageCount) {
        this.inAppNotificationMessageCountMap.put(conversationLocalUUID, messageCount);
    }

    private void clearInAppNotificationCountCache() {
        this.inAppNotificationMessageCountMap.clear();
    }

    private boolean shouldShowInAppNotification(ConversationDM conversationDM) {
        boolean enableInAppNotificationConfig = this.sdkConfigurationDM.getBoolean("enableInAppNotification");
        if (enableInAppNotificationConfig) {
            return this.canShowNotificationForConversation(conversationDM);
        }
        return false;
    }

    private int getMessageCountForShowingInAppNotification(ConversationDM conversationDM) {
        int currentUnseenMessageCount = this.getInAppNotificationCountCache(conversationDM.localUUID);
        int newUnseenMessageCount = conversationDM.getUnSeenMessageCount();
        boolean isMessageCountDifferent = newUnseenMessageCount > 0 && newUnseenMessageCount != currentUnseenMessageCount;
        return isMessageCountDifferent ? newUnseenMessageCount : 0;
    }

    private boolean canShowNotificationForConversation(ConversationDM conversation) {
        if (conversation == null || this.userDM.getLocalId() != conversation.userLocalId || StringUtils.isEmpty(conversation.localUUID)) {
            return false;
        }
        ViewableConversation viewableConversation = this.getAliveConversationDM();
        if (viewableConversation != null && viewableConversation.isVisibleOnUI()) {
            return false;
        }
        boolean isSameConversation = true;
        ConversationDM activeConversationDM = viewableConversation == null ? this.getActiveConversationFromStorage() : viewableConversation.getActiveConversation();
        if (activeConversationDM != null) {
            isSameConversation = conversation.localUUID.equals(activeConversationDM.localUUID);
        }
        return isSameConversation;
    }

    private void showNotificationOnUI(final Long conversationLocalId, final String conversationLocalUUID, final int messageCount, final String title) {
        if (messageCount > 0) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    ConversationInboxDM.this.platform.showNotification(conversationLocalId, conversationLocalUUID, messageCount, title);
                }
            });
        }
    }

    private void checkForReOpen(List<ConversationDM> conversationDMs) {
        ConversationDM conversation = this.getActiveConversationFromUIOrStorage();
        String activeConversationId = null;
        boolean isActiveConversationInPreIssueMode = false;
        if (conversation != null) {
            if (!conversation.isInPreIssueMode()) {
                activeConversationId = conversation.serverId;
            } else {
                isActiveConversationInPreIssueMode = true;
            }
        }
        ViewableConversation viewableConversation = this.getAliveConversationDM();
        for (ConversationDM conversationDM : conversationDMs) {
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            boolean isIssueStatusChange = viewableConversation != null && viewableConversation.isActiveConversationEqual(conversationDM) ? viewableConversation.checkForReopen(this.conversationViewState, activeConversationId, isActiveConversationInPreIssueMode) : conversationDM.checkForReOpen(this.conversationViewState, activeConversationId, isActiveConversationInPreIssueMode);
            if (!isIssueStatusChange || !this.shouldShowInAppNotification(conversationDM)) continue;
            int messageCount = this.getMessageCountForShowingInAppNotification(conversationDM);
            this.showInAppNotification(conversationDM, messageCount);
        }
    }

    void putConversations(Set<ConversationDM> convToUpdate, Set<ConversationDM> newConvToInsert, Map<Long, ConversationUpdate> conversationUpdateMap) {
        for (ConversationDM conversation : convToUpdate) {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
        }
        for (ConversationDM conversation : newConvToInsert) {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
        }
        this.conversationDAO.updateConversations(new ArrayList<ConversationDM>(convToUpdate), conversationUpdateMap);
        this.conversationDAO.insertConversations(new ArrayList<ConversationDM>(newConvToInsert));
    }

    private void merge(List<ConversationDM> localConversations, List<ConversationDM> sortedServerConversations, Set<ConversationDM> convToUpdate, Set<ConversationDM> newConvToInsert, Map<Long, ConversationUpdate> conversationUpdateMap) {
        ArrayList<ConversationDM> listOfConversationToInsert = new ArrayList<ConversationDM>();
        HashMap<String, ConversationDM> localConversationsLookup = new HashMap<String, ConversationDM>();
        HashMap<String, ConversationDM> localPreConversationsLookupByPreIssueId = new HashMap<String, ConversationDM>();
        HashMap<String, ConversationDM> localPreConversationsLookupByRequestId = new HashMap<String, ConversationDM>();
        for (ConversationDM localConversation : localConversations) {
            String pendingCreatePreIssueRequestId;
            if (!StringUtils.isEmpty(localConversation.serverId)) {
                localConversationsLookup.put(localConversation.serverId, localConversation);
                continue;
            }
            if (!StringUtils.isEmpty(localConversation.preConversationServerId)) {
                localPreConversationsLookupByPreIssueId.put(localConversation.preConversationServerId, localConversation);
                continue;
            }
            if (!localConversation.isInPreIssueMode() || (pendingCreatePreIssueRequestId = this.platform.getNetworkRequestDAO().getPendingRequestId(CREATE_PRE_ISSUE_ROUTE, CREATE_PRE_ISSUE_UNIQUE_MAPPING_KEY)) == null) continue;
            localPreConversationsLookupByRequestId.put(pendingCreatePreIssueRequestId, localConversation);
        }
        for (ConversationDM serverConversation : sortedServerConversations) {
            IssueState state;
            String serverConversationId = serverConversation.serverId;
            String serverPreConversationId = serverConversation.preConversationServerId;
            String serverConversationRequestId = serverConversation.createdRequestId;
            ConversationDM localConversationDM = null;
            if (localConversationsLookup.containsKey(serverConversationId)) {
                localConversationDM = (ConversationDM)localConversationsLookup.get(serverConversationId);
            } else if (localPreConversationsLookupByPreIssueId.containsKey(serverPreConversationId)) {
                localConversationDM = (ConversationDM)localPreConversationsLookupByPreIssueId.get(serverPreConversationId);
            } else if (!StringUtils.isEmpty(serverConversationRequestId) && serverConversation.isInPreIssueMode() && localPreConversationsLookupByRequestId.containsKey(serverConversationRequestId)) {
                localConversationDM = (ConversationDM)localPreConversationsLookupByRequestId.get(serverConversationRequestId);
            }
            if (localConversationDM != null) {
                localConversationDM.setDependencies(this.platform, this.domain, this.userDM);
                ConversationUpdate conversationUpdate = conversationUpdateMap.containsKey(localConversationDM.localId) ? conversationUpdateMap.get(localConversationDM.localId) : new ConversationUpdate();
                if (serverConversation.isInPreIssueMode()) {
                    this.mergePreIssue(localConversationDM, serverConversation, convToUpdate, conversationUpdate);
                } else {
                    this.mergeIssue(localConversationDM, serverConversation, convToUpdate, conversationUpdate);
                }
                conversationUpdateMap.put(localConversationDM.localId, conversationUpdate);
                continue;
            }
            if (serverConversation.isInPreIssueMode()) {
                serverConversation.lastUserActivityTime = System.currentTimeMillis();
                if (serverConversation.state == IssueState.RESOLUTION_REQUESTED) {
                    serverConversation.state = IssueState.RESOLUTION_ACCEPTED;
                }
            }
            if ((state = serverConversation.state) != null && (state == IssueState.RESOLUTION_ACCEPTED || state == IssueState.RESOLUTION_REJECTED || state == IssueState.REJECTED || state == IssueState.ARCHIVED)) {
                serverConversation.isStartNewConversationClicked = true;
            }
            if (state != null && serverConversation.isRedacted && serverConversation.state == IssueState.RESOLUTION_REQUESTED) {
                serverConversation.isStartNewConversationClicked = true;
                serverConversation.state = IssueState.RESOLUTION_ACCEPTED;
            }
            listOfConversationToInsert.add(serverConversation);
        }
        if (listOfConversationToInsert.size() <= 1) {
            newConvToInsert.addAll(listOfConversationToInsert);
            return;
        }
        ArrayList copyOfConvToInsert = new ArrayList(listOfConversationToInsert);
        block2: for (int i = copyOfConvToInsert.size() - 1; i >= 0; --i) {
            ConversationDM newConversation = (ConversationDM)copyOfConvToInsert.get(i);
            if (newConversation.isInPreIssueMode()) continue;
            for (int j = i - 1; j >= 0; --j) {
                ConversationDM associatedPreIssue = (ConversationDM)copyOfConvToInsert.get(j);
                if (StringUtils.isEmpty(newConversation.preConversationServerId) || !newConversation.preConversationServerId.equals(associatedPreIssue.preConversationServerId) || !newConversation.serverId.equals(associatedPreIssue.serverId)) continue;
                newConversation.messageDMs.addAll((Collection<MessageDM>)associatedPreIssue.messageDMs);
                listOfConversationToInsert.remove(j);
                continue block2;
            }
        }
        newConvToInsert.addAll(listOfConversationToInsert);
    }

    private String generateMessageCursors() {
        HashMap<String, Object> messageCursors = new HashMap<String, Object>();
        HashMap<String, Object> issuesCursors = new HashMap<String, Object>();
        HashMap<String, Object> preIssuesCursors = new HashMap<String, Object>();
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        for (ConversationDM conversation : conversations) {
            if (conversation.isInPreIssueMode() && !StringUtils.isEmpty(conversation.preConversationServerId)) {
                preIssuesCursors.put(conversation.preConversationServerId, conversation.messageCursor);
                continue;
            }
            issuesCursors.put(conversation.serverId, conversation.messageCursor);
        }
        messageCursors.put("issues", this.platform.getJsonifier().jsonifyToObject(issuesCursors));
        messageCursors.put("preissues", this.platform.getJsonifier().jsonifyToObject(preIssuesCursors));
        return this.platform.getJsonifier().jsonify(messageCursors);
    }

    public ViewableConversation getConversationDM(boolean showConversationHistory, Long conversationLocalId) {
        ViewableConversation result;
        if (showConversationHistory) {
            result = this.getInMemoryConversationDM(ConversationHistoryDM.CONVERSATION_HISTORY_DM_IDENTIFIER);
            if (result == null) {
                ConversationHistoryLoader loader = new ConversationHistoryLoader(this.platform, this.userDM, this.remoteConversationLoader, 100L);
                result = new ConversationHistoryDM(this.platform, this.domain, this.userDM, loader);
                result.init();
                if (ListUtils.isEmpty(result.getAllConversations())) {
                    ConversationDM conversationDM = this.createLocalPreIssueConversation();
                    result.onNewConversationStarted(conversationDM);
                }
            }
        } else {
            result = this.getInMemoryConversationDM(conversationLocalId);
            if (result == null) {
                SingleConversationLoader loader = new SingleConversationLoader(this.platform, this.userDM, conversationLocalId, this.remoteConversationLoader, 100L);
                result = new SingleConversationDM(this.platform, this.domain, this.userDM, loader);
                result.init();
            }
        }
        result.setLiveUpdateDM(this.liveUpdateDM);
        this.setAliveConversation(result);
        return result;
    }

    private ViewableConversation getInMemoryConversationDM(Long conversationLocalId) {
        for (Map.Entry<ViewableConversation, Long> conversationEntry : this.aliveConversationDMs.entrySet()) {
            if (conversationEntry.getValue().equals(conversationLocalId)) {
                return conversationEntry.getKey();
            }
            if (!conversationEntry.getValue().equals(ConversationHistoryDM.CONVERSATION_HISTORY_DM_IDENTIFIER)) continue;
            ViewableConversation viewableConversation = conversationEntry.getKey();
            if (!conversationLocalId.equals(viewableConversation.getActiveConversation().localId)) continue;
            return viewableConversation;
        }
        return null;
    }

    public boolean shouldOpenConversationFromNotification(long conversationLocalId) {
        ConversationDM conversationDM;
        ViewableConversation viewableConversation = this.getInMemoryConversationDM(conversationLocalId);
        if ((viewableConversation == null || viewableConversation.getActiveConversation() == null) && (conversationDM = this.conversationDAO.readConversationWithoutMessages(conversationLocalId)) != null) {
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            return conversationDM.shouldOpen();
        }
        return viewableConversation != null && viewableConversation.shouldOpen();
    }

    public ConversationDM getActiveConversationOrPreIssue() {
        ConversationDM activeConversation = this.getActiveConversationFromStorage();
        if (activeConversation == null && this.sdkConfigurationDM.getBoolean("conversationalIssueFiling")) {
            activeConversation = this.createLocalPreIssueConversation();
        }
        return activeConversation;
    }

    public ConversationDM getActiveConversationFromStorage() {
        ConversationDM activeConversation = null;
        if (!this.sdkConfigurationDM.getBoolean("disableInAppConversation")) {
            List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
            ArrayList<ConversationDM> openConversations = new ArrayList<ConversationDM>();
            for (ConversationDM conversation : conversations) {
                conversation.setDependencies(this.platform, this.domain, this.userDM);
                if (!conversation.shouldOpen()) continue;
                openConversations.add(conversation);
            }
            if (openConversations.size() > 0) {
                activeConversation = ConversationUtil.getLastConversationDMBasedOnCreatedAt(openConversations);
            }
        }
        return activeConversation;
    }

    public ConversationDM getOpenConversationWithMessages() {
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        ArrayList<ConversationDM> openConversations = new ArrayList<ConversationDM>();
        if (conversations.isEmpty()) {
            return null;
        }
        for (ConversationDM conversation : conversations) {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
            if (!conversation.isIssueInProgress()) continue;
            openConversations.add(conversation);
        }
        if (openConversations.isEmpty()) {
            return null;
        }
        ConversationDM conversationDMToReturn = ConversationUtil.getLastConversationDMBasedOnCreatedAt(openConversations);
        conversationDMToReturn.setMessageDMs(this.conversationDAO.readMessages(conversationDMToReturn.localId));
        return conversationDMToReturn;
    }

    public ConversationDM createLocalPreIssueConversation() {
        ConversationDM conversation = new ConversationDM(this.platform, this.domain, this.userDM);
        String currentDate = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAt = HSDateFormatSpec.convertToEpochTime(currentDate);
        conversation.userLocalId = this.userDM.getLocalId();
        conversation.setCreatedAt(currentDate);
        conversation.setEpochCreatedAtTime(epochCreatedAt);
        conversation.updatedAt = currentDate;
        conversation.state = IssueState.NEW;
        conversation.issueType = "preissue";
        conversation.title = "Pre Issue Conversation";
        this.conversationDAO.insertPreIssueConversation(conversation);
        return conversation;
    }

    public boolean isActiveConversationActionable() {
        ViewableConversation viewableConversation = this.getAliveConversationDM();
        ConversationDM activeInMemoryConversationDM = null;
        if (viewableConversation != null) {
            activeInMemoryConversationDM = viewableConversation.getActiveConversation();
        }
        ConversationDM conversation = activeInMemoryConversationDM == null ? this.getActiveConversationFromStorage() : activeInMemoryConversationDM;
        boolean isActionable = false;
        if (conversation != null) {
            if (conversation.isInPreIssueMode() && !StringUtils.isEmpty(conversation.preConversationServerId) && conversation.isIssueInProgress()) {
                isActionable = true;
            } else if (conversation.isIssueInProgress() || conversation.state == IssueState.RESOLUTION_REQUESTED) {
                isActionable = true;
            } else if (conversation.state == IssueState.RESOLUTION_REJECTED) {
                ConversationVMCallback conversationVMCallback;
                boolean isConversationOpenOnUI = false;
                if (viewableConversation != null && (conversationVMCallback = viewableConversation.getConversationVMCallback()) != null) {
                    isConversationOpenOnUI = true;
                    isActionable = conversationVMCallback.isMessageBoxVisible();
                }
                if (!isConversationOpenOnUI) {
                    boolean persistMessageBox = this.conversationInboxDAO.getPersistMessageBox(this.userDM.getLocalId());
                    String replyDraft = this.conversationInboxDAO.getUserReplyDraft(this.userDM.getLocalId());
                    isActionable = persistMessageBox || !StringUtils.isEmpty(replyDraft);
                }
            }
        }
        return isActionable;
    }

    public boolean shouldPersistMessageBox() {
        return this.conversationInboxDAO.getPersistMessageBox(this.userDM.getLocalId());
    }

    public void setPersistMessageBox(boolean value) {
        this.conversationInboxDAO.savePersistMessageBox(this.userDM.getLocalId(), value);
    }

    public void setConversationViewState(int conversationViewState) {
        this.conversationViewState = conversationViewState;
    }

    public void handlePushNotification(String issueType, String id, String appName) {
        String notificationTitle;
        int pushCount;
        PushNotificationData pushNotificationData;
        ConversationDM readableConversation;
        if ("issue".equals(issueType)) {
            readableConversation = this.conversationDAO.readConversationWithoutMessages(id);
        } else if ("preissue".equals(issueType)) {
            readableConversation = this.conversationDAO.readPreConversationWithoutMessages(id);
        } else {
            HSLogger.e(TAG, "Cannot handle push for unknown issue type. " + issueType);
            return;
        }
        if (readableConversation == null) {
            return;
        }
        if (StringUtils.isEmpty(appName)) {
            appName = this.platform.getDevice().getAppName();
        }
        if ((pushNotificationData = this.conversationInboxDAO.getPushNotificationData(readableConversation.localUUID)) == null) {
            pushCount = 1;
            notificationTitle = appName;
        } else {
            pushCount = pushNotificationData.count + 1;
            notificationTitle = pushNotificationData.title;
        }
        this.conversationInboxDAO.setPushNotificationData(readableConversation.localUUID, new PushNotificationData(pushCount, notificationTitle));
        if (pushCount > 0 && this.canShowNotificationForConversation(readableConversation)) {
            this.showNotificationOnUI(readableConversation.localId, readableConversation.localUUID, pushCount, appName);
        }
        this.sendUnreadCountUpdate();
    }

    public void resetPushNotificationCount(ConversationDM conversationDM) {
        this.conversationInboxDAO.setPushNotificationData(conversationDM.localUUID, null);
        this.domain.getDelegate().didReceiveNotification(0);
    }

    public void clearPushNotifications() {
        List<ConversationDM> readableConversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        for (ConversationDM readableConversation : readableConversations) {
            this.clearNotification(readableConversation);
        }
    }

    public void showPushNotifications() {
        List<ConversationDM> conversationDMs = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        for (ConversationDM conversationDM : conversationDMs) {
            PushNotificationData data = this.conversationInboxDAO.getPushNotificationData(conversationDM.localUUID);
            if (data == null || data.count <= 0) continue;
            Long conversationLocalId = conversationDM.localId;
            this.showNotificationOnUI(conversationLocalId, conversationDM.localUUID, data.count, data.title);
        }
    }

    public void clearNotification(final ConversationDM conversationDM) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                ConversationInboxDM.this.platform.clearNotifications(conversationDM.localUUID);
            }
        });
        this.clearInAppNotificationCountCache();
    }

    public int getNotificationCountSync() {
        if (this.userCanReadMessages) {
            return 0;
        }
        ConversationDM conversationDM = this.getActiveConversationFromUIOrStorage();
        if (conversationDM == null) {
            return 0;
        }
        int unSeenMessageCount = conversationDM.getUnSeenMessageCount();
        int pushNotificationCount = 0;
        PushNotificationData data = this.conversationInboxDAO.getPushNotificationData(conversationDM.localUUID);
        if (data != null) {
            pushNotificationCount = data.count;
        }
        return Math.max(unSeenMessageCount, pushNotificationCount);
    }

    public ValuePair<Integer, Boolean> fetchConversationsAndGetNotificationCount() {
        long timeLimitValue;
        if (this.userDM == null || !this.userDM.issueExists()) {
            return new ValuePair<Integer, Boolean>(-1, true);
        }
        if (this.userCanReadMessages) {
            return new ValuePair<Integer, Boolean>(0, true);
        }
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        if (ListUtils.isEmpty(conversations)) {
            return new ValuePair<Integer, Boolean>(0, true);
        }
        long l = timeLimitValue = ConversationUtil.shouldPollActivelyForConversations(conversations) ? 60000L : 300000L;
        if (System.currentTimeMillis() - this.lastNotifCountFetchTime < timeLimitValue) {
            int cachedCount = this.getNotificationCountSync();
            return new ValuePair<Integer, Boolean>(cachedCount, true);
        }
        this.lastNotifCountFetchTime = System.currentTimeMillis();
        this.fetchConversationUpdates();
        int unSeenMessageCount = 0;
        ConversationDM conversationDM = this.getActiveConversationFromUIOrStorage();
        if (conversationDM != null) {
            unSeenMessageCount = conversationDM.getUnSeenMessageCount();
        }
        return new ValuePair<Integer, Boolean>(unSeenMessageCount, false);
    }

    private ConversationDM getActiveConversationFromUIOrStorage() {
        ViewableConversation viewableConversation = this.getAliveConversationDM();
        if (viewableConversation == null) {
            ConversationDM readableConversation = this.getActiveConversationFromStorage();
            ConversationDM conversationDM = null;
            if (readableConversation != null) {
                conversationDM = readableConversation;
                conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            }
            return conversationDM;
        }
        return viewableConversation.getActiveConversation();
    }

    private ConversationDM getLastViewableSyncedConversation() {
        ConversationDM activeConversation;
        ViewableConversation viewableConversation = this.getAliveConversationDM();
        ConversationDM lastShownServerSyncedConversation = viewableConversation != null ? ((activeConversation = viewableConversation.getActiveConversation()).isSynced() ? activeConversation : this.getLastViewableSyncedConversationFromStorage()) : this.getLastViewableSyncedConversationFromStorage();
        return lastShownServerSyncedConversation;
    }

    private ConversationDM getLastViewableSyncedConversationFromStorage() {
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        if (conversations.isEmpty()) {
            return null;
        }
        List<ConversationDM> syncedConversations = Filters.filter(conversations, ConversationPredicates.newSyncedConversationPredicate());
        List<ConversationDM> openSyncedConversations = Filters.filter(syncedConversations, ConversationPredicates.newInProgressConversationPredicate());
        if (ListUtils.isEmpty(syncedConversations)) {
            return null;
        }
        ConversationDM conversationToReturn = openSyncedConversations.isEmpty() ? ConversationUtil.getLastConversationDMBasedOnCreatedAt(syncedConversations) : ConversationUtil.getLastConversationDMBasedOnCreatedAt(openSyncedConversations);
        return conversationToReturn;
    }

    public void deleteCachedFilesForResolvedConversations() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                List<ConversationDM> conversations = ConversationInboxDM.this.conversationDAO.readConversationsWithoutMessages(ConversationInboxDM.this.userDM.getLocalId());
                for (ConversationDM conversationDM : conversations) {
                    conversationDM.setDependencies(ConversationInboxDM.this.platform, ConversationInboxDM.this.domain, ConversationInboxDM.this.userDM);
                    if (conversationDM.shouldOpen()) continue;
                    conversationDM.deleteCachedScreenshotFiles();
                }
            }
        });
    }

    void resetPreIssueConversationsForUser(final UserDM userDM) {
        List<ConversationDM> allConversations = this.conversationDAO.readConversationsWithoutMessages(userDM.getLocalId());
        if (allConversations == null || allConversations.size() == 0) {
            return;
        }
        for (final ConversationDM conversation : allConversations) {
            conversation.setDependencies(this.platform, this.domain, userDM);
            if (StringUtils.isEmpty(conversation.preConversationServerId) || !conversation.isInPreIssueMode()) continue;
            long lastUserActivityTime = conversation.lastUserActivityTime;
            if (System.currentTimeMillis() - lastUserActivityTime < 86400000L || !conversation.isIssueInProgress() && conversation.state != IssueState.UNKNOWN) continue;
            this.clearNotification(conversation);
            this.domain.runParallel(new F(){

                @Override
                public void f() {
                    try {
                        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
                        data.put("state", String.valueOf(IssueState.REJECTED.getValue()));
                        Network resetPreConversationNetwork = new PUTNetwork(ConversationInboxDM.CREATE_PRE_ISSUE_ROUTE + conversation.preConversationServerId + "/", ConversationInboxDM.this.domain, ConversationInboxDM.this.platform);
                        resetPreConversationNetwork = new TSCorrectedNetwork(resetPreConversationNetwork, ConversationInboxDM.this.platform);
                        resetPreConversationNetwork = new GuardOKNetwork(resetPreConversationNetwork);
                        RequestData requestData = new RequestData(data);
                        resetPreConversationNetwork.makeRequest(requestData);
                        ViewableConversation viewableConversation = ConversationInboxDM.this.getInMemoryConversationDM(conversation.localId);
                        ConversationDM conversationDMToUpdate = viewableConversation == null ? conversation : viewableConversation.getActiveConversation();
                        conversationDMToUpdate.updateIssueStatus(IssueState.REJECTED);
                    }
                    catch (RootAPIException e) {
                        HSLogger.e(ConversationInboxDM.TAG, "Error resetting preissue : " + conversation.preConversationServerId, e);
                        throw e;
                    }
                }
            });
        }
    }

    private void mergePreIssue(ConversationDM localConversationDM, ConversationDM serverConversation, Set<ConversationDM> convToUpdate, ConversationUpdate conversationUpdate) {
        ConversationDM conversationToMerge = localConversationDM;
        boolean isConversationDMInMemory = false;
        boolean isConversationVisibleOnUI = false;
        ViewableConversation viewableConversation = this.getInMemoryConversationDM(localConversationDM.localId);
        if (viewableConversation != null) {
            ConversationDM activeConversationDM = viewableConversation.getActiveConversation();
            if (serverConversation.preConversationServerId.equals(activeConversationDM.preConversationServerId)) {
                conversationToMerge = activeConversationDM;
                isConversationDMInMemory = true;
            }
            isConversationVisibleOnUI = viewableConversation.isVisibleOnUI();
        }
        conversationToMerge.sendConversationPostedEvent(serverConversation);
        if (StringUtils.isEmpty(conversationToMerge.preConversationServerId) && conversationToMerge.isInPreIssueMode() && !StringUtils.isEmpty(serverConversation.preConversationServerId)) {
            if (isConversationDMInMemory) {
                viewableConversation.handlePreIssueCreationSuccess();
            } else {
                localConversationDM.handlePreIssueCreationSuccess();
            }
        }
        IssueState oldState = conversationToMerge.state;
        if (isConversationDMInMemory) {
            viewableConversation.mergePreIssue(serverConversation, conversationUpdate);
        } else {
            localConversationDM.mergePreIssue(serverConversation, false, conversationUpdate);
        }
        if (!isConversationVisibleOnUI) {
            conversationToMerge.checkAndIncrementMessageCount(oldState);
        }
        conversationToMerge.sendConversationEndedDelegateForPreIssue();
        convToUpdate.add(conversationToMerge);
    }

    private void mergeIssue(ConversationDM localConversationDM, ConversationDM serverConversation, Set<ConversationDM> convToUpdate, ConversationUpdate conversationUpdate) {
        ConversationDM activeStorageConversationDM;
        ConversationDM conversationToMerge = localConversationDM;
        boolean isConversationDMInMemory = false;
        boolean isConversationVisibleOnUI = false;
        ViewableConversation viewableConversation = this.getInMemoryConversationDM(localConversationDM.localId);
        if (viewableConversation != null) {
            ConversationDM activeConversationDM = viewableConversation.getActiveConversation();
            if (serverConversation.serverId.equals(activeConversationDM.serverId)) {
                conversationToMerge = activeConversationDM;
                isConversationDMInMemory = true;
            }
            isConversationVisibleOnUI = viewableConversation.isVisibleOnUI();
        }
        IssueState oldState = conversationToMerge.state;
        if (isConversationDMInMemory) {
            viewableConversation.mergeIssue(serverConversation, conversationUpdate);
        } else {
            localConversationDM.mergeIssue(serverConversation, false, conversationUpdate);
        }
        if ((viewableConversation == null || !viewableConversation.isVisibleOnUI()) && conversationToMerge.state == IssueState.REJECTED && (activeStorageConversationDM = this.getActiveConversationFromStorage()) != null && activeStorageConversationDM.localId.equals(conversationToMerge.localId)) {
            conversationToMerge.handleConversationEnded();
        }
        if (!isConversationVisibleOnUI) {
            conversationToMerge.checkAndIncrementMessageCount(oldState);
        }
        convToUpdate.add(conversationToMerge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchConversationHistory() {
        Object object = fetchConversationUpdatesLock;
        synchronized (object) {
            this.remoteConversationLoader.loadMoreMessages();
        }
    }

    @Override
    public void executeUserSync() {
        this.fetchInitialConversationUpdates();
        List<ConversationDM> storageConversationDMs = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        if (this.isAtLeastOneConversationNonActionable(storageConversationDMs)) {
            return;
        }
        int MAX_HISTORY_REQUEST_COUNT = 3;
        boolean hasOlderMessages = this.remoteConversationLoader.hasMoreMessage();
        for (int iterationCount = 0; !this.isAtLeastOneConversationNonActionable(storageConversationDMs) && hasOlderMessages && iterationCount < MAX_HISTORY_REQUEST_COUNT; ++iterationCount) {
            this.fetchConversationHistory();
            storageConversationDMs = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
            hasOlderMessages = this.remoteConversationLoader.hasMoreMessage();
        }
    }

    private boolean isAtLeastOneConversationNonActionable(List<ConversationDM> conversationDMS) {
        if (ListUtils.isEmpty(conversationDMS)) {
            return false;
        }
        for (ConversationDM conversationDM : conversationDMS) {
            if (conversationDM.isIssueInProgress()) continue;
            return true;
        }
        return false;
    }

    public Long getOldestConversationCreatedAtTime() {
        return this.conversationDAO.getOldestConversationCreatedAtTime(this.userDM.getLocalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redactConversations() {
        Object object = fetchConversationUpdatesLock;
        synchronized (object) {
            this.deleteConversationsAndMessages();
            this.aliveConversationDMs.clear();
            this.conversationInboxDAO.resetDataAfterConversationsDeletion(this.userDM.getLocalId());
        }
    }

    private class CreateConversationStateHolder {
        final String description;
        final String userProvidedName;
        final String userProvidedEmail;
        final ImagePickerFile imagePickerFile;
        private final F startNewConversationInternalF = new One(new F(){

            @Override
            public void f() {
                ConversationInboxDM.this.startNewConversationInternal(CreateConversationStateHolder.this.description, CreateConversationStateHolder.this.userProvidedName, CreateConversationStateHolder.this.userProvidedEmail, CreateConversationStateHolder.this.imagePickerFile);
            }
        });

        CreateConversationStateHolder(String description, String userProvidedName, String userProvidedEmail, ImagePickerFile imagePickerFile) {
            this.description = description;
            this.userProvidedName = userProvidedName;
            this.userProvidedEmail = userProvidedEmail;
            this.imagePickerFile = imagePickerFile;
        }

        F getStartNewConversationInternalF() {
            return this.startNewConversationInternalF;
        }
    }

    public static interface StartNewConversationListener {
        public void onCreateConversationSuccess(long var1);

        public void onCreateConversationFailure(Exception var1);
    }
}

