/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.domainmodel;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConversationInboxManagerDM {
    private final Platform platform;
    private final Domain domain;
    private final UserManagerDM userManagerDM;
    private Map<Long, ConversationInboxDM> activeUserAndInboxMapping = new HashMap<Long, ConversationInboxDM>();

    public ConversationInboxManagerDM(Platform platform, Domain domain, UserManagerDM userManagerDM) {
        this.platform = platform;
        this.domain = domain;
        this.userManagerDM = userManagerDM;
    }

    private ConversationInboxDM buildConversationInboxDM(UserDM userDM) {
        return new ConversationInboxDM(this.platform, this.domain, userDM);
    }

    public synchronized ConversationInboxDM getActiveConversationInboxDM() {
        UserDM activeUser = this.userManagerDM.getActiveUser();
        ConversationInboxDM activeConversationInboxDM = this.activeUserAndInboxMapping.get(activeUser.getLocalId());
        if (activeConversationInboxDM == null) {
            activeConversationInboxDM = this.buildConversationInboxDM(activeUser);
            activeConversationInboxDM.initialize();
            this.activeUserAndInboxMapping.clear();
            this.activeUserAndInboxMapping.put(activeUser.getLocalId(), activeConversationInboxDM);
        }
        return activeConversationInboxDM;
    }

    public synchronized ConversationInboxDM getConversationInboxDM(UserDM userDM) {
        if (userDM == null) {
            return null;
        }
        ConversationInboxDM conversationInboxDM = this.activeUserAndInboxMapping.get(userDM.getLocalId());
        if (conversationInboxDM == null) {
            conversationInboxDM = this.buildConversationInboxDM(userDM);
        }
        return conversationInboxDM;
    }

    public synchronized void deleteConversations(UserDM userDM) {
        ConversationInboxDM conversationInboxDM = this.getConversationInboxDM(userDM);
        if (conversationInboxDM != null) {
            conversationInboxDM.deleteAllConversationsData();
        }
    }

    public synchronized void resetPreIssueConversations() {
        List<UserDM> userDMs = this.domain.getUserManagerDM().getAllUsers();
        if (ListUtils.isEmpty(userDMs)) {
            return;
        }
        for (UserDM userDM : userDMs) {
            ConversationInboxDM conversationInboxDM = this.getConversationInboxDM(userDM);
            if (conversationInboxDM == null) continue;
            conversationInboxDM.resetPreIssueConversationsForUser(userDM);
        }
    }
}

