/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.dto;

import java.util.HashMap;
import java.util.Map;

public enum IssueState {
    NEW(0),
    NEW_FOR_AGENT(1),
    AGENT_REPLIED(2),
    WAITING_FOR_AGENT(3),
    RESOLUTION_REQUESTED(4),
    REJECTED(5),
    PENDING_REASSIGNMENT(6),
    COMPLETED_ISSUE_CREATED(7),
    RESOLUTION_ACCEPTED(101),
    RESOLUTION_REJECTED(102),
    ARCHIVED(103),
    AUTHOR_MISMATCH(104),
    UNKNOWN(-1);

    private static final Map<Integer, IssueState> map;
    private final int value;

    private IssueState(int value) {
        this.value = value;
    }

    public static IssueState fromInt(int i) {
        IssueState result;
        if (map.size() == 0) {
            for (IssueState preIssueStatus : IssueState.values()) {
                map.put(preIssueStatus.value, preIssueStatus);
            }
        }
        if ((result = map.get(i)) == null) {
            return UNKNOWN;
        }
        return result;
    }

    public int getValue() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, IssueState>();
    }
}

