/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.loaders;

import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.dao.ConversationDAO;
import java.util.ArrayList;
import java.util.List;

public abstract class ConversationDBLoader {
    protected ConversationDAO conversationDAO;
    private boolean hasMoreMessages = true;

    protected ConversationDBLoader(ConversationDAO conversationDAO) {
        this.conversationDAO = conversationDAO;
    }

    public abstract List<ConversationDM> fetchMessages(String var1, String var2, long var3);

    public boolean hasMoreMessages() {
        return this.hasMoreMessages;
    }

    public void setHasMoreMessages(boolean hasMoreMessages) {
        this.hasMoreMessages = hasMoreMessages;
    }

    int compareEpochTime(long firstTime, long secondTime) {
        if (firstTime > secondTime) {
            return 1;
        }
        if (firstTime < secondTime) {
            return -1;
        }
        return 0;
    }

    List<MessageDM> filterMessages(String cursor, long limit, List<MessageDM> messageDMs) {
        List<MessageDM> filteredMessageDMs;
        if (ListUtils.isEmpty(messageDMs) || limit < 1L) {
            return new ArrayList<MessageDM>();
        }
        ConversationUtil.sortMessagesBasedOnCreatedAt(messageDMs);
        if (StringUtils.isEmpty(cursor)) {
            filteredMessageDMs = messageDMs;
        } else {
            long cursorEpochTime = HSDateFormatSpec.convertToEpochTime(cursor);
            filteredMessageDMs = new ArrayList<MessageDM>();
            for (MessageDM messageDM : messageDMs) {
                if (cursorEpochTime <= messageDM.getEpochCreatedAtTime()) break;
                filteredMessageDMs.add(messageDM);
            }
            if (ListUtils.isEmpty(filteredMessageDMs)) {
                return new ArrayList<MessageDM>();
            }
        }
        int size = filteredMessageDMs.size();
        int sublistStartingIndex = Math.max(0, (int)((long)size - limit));
        return filteredMessageDMs.subList(sublistStartingIndex, size);
    }
}

