/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.loaders;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.loaders.ConversationDBLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConversationHistoryDBLoader
extends ConversationDBLoader {
    private UserDM userDM;

    public ConversationHistoryDBLoader(UserDM userDM, ConversationDAO conversationDAO) {
        super(conversationDAO);
        this.userDM = userDM;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ConversationDM> fetchMessages(String conversationCursor, String messageCursor, long limit) {
        List<ConversationDM> filteredConversations;
        List<ConversationDM> allConversationDMs = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        if (allConversationDMs.isEmpty()) {
            return new ArrayList<ConversationDM>();
        }
        ConversationUtil.sortConversationsBasedOnCreatedAt(allConversationDMs);
        boolean isFirstDataFetch = StringUtils.isEmpty(conversationCursor);
        ArrayList<ConversationDM> resultConversations = new ArrayList<ConversationDM>();
        if (isFirstDataFetch) {
            filteredConversations = allConversationDMs;
        } else {
            ConversationDM lastConversationDM;
            filteredConversations = this.filterOutConversationCreatedAfterCursor(conversationCursor, allConversationDMs);
            if (!ListUtils.isEmpty(filteredConversations) && (lastConversationDM = filteredConversations.get(filteredConversations.size() - 1)).getCreatedAt().equals(conversationCursor)) {
                List<MessageDM> messageDMs = this.conversationDAO.readMessages(lastConversationDM.localId);
                List<MessageDM> filteredMessageDMs = this.filterMessages(messageCursor, limit, messageDMs);
                if (!ListUtils.isEmpty(filteredMessageDMs)) {
                    lastConversationDM.setMessageDMs(filteredMessageDMs);
                    resultConversations.add(lastConversationDM);
                    limit -= (long)filteredMessageDMs.size();
                }
                filteredConversations.remove(lastConversationDM);
            }
        }
        if (limit < 1L) {
            return resultConversations;
        }
        if (isFirstDataFetch) {
            int size = filteredConversations.size();
            if (size > 1) {
                ConversationDM lastConversationDM = filteredConversations.get(size - 1);
                filteredConversations = this.filterOutFullPrivacyEnabledConversations(filteredConversations.subList(0, size - 1));
                filteredConversations.add(lastConversationDM);
            }
        } else {
            filteredConversations = this.filterOutFullPrivacyEnabledConversations(filteredConversations);
        }
        filteredConversations = this.filterOutRejectedEmptyPreIssues(filteredConversations);
        if (isFirstDataFetch) {
            ConversationDM lastOpenConversation = this.getLastOpenConversation(filteredConversations);
            filteredConversations = this.filterOutMultipleOpenConversations(filteredConversations);
            if (lastOpenConversation != null) {
                filteredConversations.add(lastOpenConversation);
            }
        } else {
            filteredConversations = this.filterOutMultipleOpenConversations(filteredConversations);
        }
        filteredConversations = this.filterOutConversationsForWhichMessagesLimitExceed(limit, filteredConversations);
        ArrayList<Long> conversationLocalIdsToBeLoaded = new ArrayList<Long>();
        HashMap<Long, ConversationDM> selectedConversationsLookup = new HashMap<Long, ConversationDM>();
        for (ConversationDM conversationDM : filteredConversations) {
            conversationLocalIdsToBeLoaded.add(conversationDM.localId);
            selectedConversationsLookup.put(conversationDM.localId, conversationDM);
        }
        List<MessageDM> messages = this.conversationDAO.readMessagesForConversations(conversationLocalIdsToBeLoaded);
        for (MessageDM messageDM : messages) {
            if (!selectedConversationsLookup.containsKey(messageDM.conversationLocalId)) continue;
            ConversationDM conversationDM = (ConversationDM)selectedConversationsLookup.get(messageDM.conversationLocalId);
            conversationDM.messageDMs.add(messageDM);
        }
        boolean bl = false;
        for (int i = filteredConversations.size() - 1; i >= 0; --i) {
            void var12_17;
            ConversationDM conversationDM3 = filteredConversations.get(i);
            void totalIncludingExtraMessages = var12_17 + conversationDM3.messageDMs.size();
            if ((long)totalIncludingExtraMessages > limit) {
                conversationDM3.sortMessageDMs();
                int messageCountToBeAdded = (int)(limit - (long)var12_17);
                ArrayList<MessageDM> copy = new ArrayList<MessageDM>(conversationDM3.messageDMs);
                conversationDM3.messageDMs.clear();
                List messagesToBeAdded = copy.subList(copy.size() - messageCountToBeAdded, copy.size());
                conversationDM3.messageDMs.addAll(messagesToBeAdded);
                continue;
            }
            var12_17 += conversationDM3.messageDMs.size();
        }
        resultConversations.addAll(0, filteredConversations);
        for (ConversationDM conversationDM : resultConversations) {
            conversationDM.sortMessageDMs();
        }
        return resultConversations;
    }

    private List<ConversationDM> filterOutConversationsForWhichMessagesLimitExceed(long limit, List<ConversationDM> conversations) {
        ArrayList<Long> allConversationLocalIds = new ArrayList<Long>();
        for (ConversationDM conversationDM : conversations) {
            allConversationLocalIds.add(conversationDM.localId);
        }
        Map<Long, Integer> messageCountMap = this.conversationDAO.getMessagesCountForConversations(allConversationLocalIds);
        int totalTillNow = 0;
        ArrayList<ConversationDM> selectedConversations = new ArrayList<ConversationDM>();
        for (int i = conversations.size() - 1; i >= 0; --i) {
            ConversationDM conversationDM = conversations.get(i);
            int messagesCount = messageCountMap.get(conversationDM.localId);
            selectedConversations.add(conversationDM);
            if ((long)(totalTillNow + messagesCount) >= limit) break;
            totalTillNow += messagesCount;
        }
        Collections.reverse(selectedConversations);
        return selectedConversations;
    }

    private List<ConversationDM> filterOutConversationCreatedAfterCursor(String cursor, List<ConversationDM> conversationDMs) {
        ConversationDM conversationDM;
        long conversationEpochTime;
        if (ListUtils.isEmpty(conversationDMs) || StringUtils.isEmpty(cursor)) {
            return conversationDMs;
        }
        long cursorEpochTime = HSDateFormatSpec.convertToEpochTime(cursor);
        ArrayList<ConversationDM> filteredConversations = new ArrayList<ConversationDM>();
        Iterator<ConversationDM> iterator = conversationDMs.iterator();
        while (iterator.hasNext() && this.compareEpochTime(conversationEpochTime = (conversationDM = iterator.next()).getEpochCreatedAtTime(), cursorEpochTime) <= 0) {
            filteredConversations.add(conversationDM);
        }
        return filteredConversations;
    }

    private List<ConversationDM> filterOutFullPrivacyEnabledConversations(List<ConversationDM> conversationDMs) {
        ArrayList<ConversationDM> filteredConversations = new ArrayList<ConversationDM>();
        if (conversationDMs.isEmpty()) {
            return filteredConversations;
        }
        int size = conversationDMs.size();
        for (int index = 0; index < size; ++index) {
            ConversationDM conversationDM = conversationDMs.get(index);
            if (conversationDM.wasFullPrivacyEnabledAtCreation) continue;
            filteredConversations.add(conversationDM);
        }
        return filteredConversations;
    }

    private List<ConversationDM> filterOutRejectedEmptyPreIssues(List<ConversationDM> conversationDMs) {
        ArrayList<ConversationDM> filteredConversations = new ArrayList<ConversationDM>();
        if (conversationDMs.isEmpty()) {
            return filteredConversations;
        }
        ArrayList<Long> rejectedPreIssuesLocalIds = new ArrayList<Long>();
        for (ConversationDM conversationDM : conversationDMs) {
            if (conversationDM.state != IssueState.REJECTED || !"preissue".equals(conversationDM.issueType)) continue;
            rejectedPreIssuesLocalIds.add(conversationDM.localId);
        }
        if (rejectedPreIssuesLocalIds.isEmpty()) {
            filteredConversations.addAll(conversationDMs);
            return filteredConversations;
        }
        Map<Long, Integer> messagesCountMap = ConversationUtil.getUserMessageCountForConversationLocalIds(this.conversationDAO, rejectedPreIssuesLocalIds);
        for (ConversationDM conversationDM : conversationDMs) {
            Integer count = messagesCountMap.get(conversationDM.localId);
            if (count != null && count == 0) continue;
            filteredConversations.add(conversationDM);
        }
        return filteredConversations;
    }

    private List<ConversationDM> filterOutMultipleOpenConversations(List<ConversationDM> conversationDMs) {
        ArrayList<ConversationDM> filteredConversations = new ArrayList<ConversationDM>();
        if (conversationDMs.isEmpty()) {
            return filteredConversations;
        }
        for (ConversationDM conversationDM : conversationDMs) {
            if (conversationDM.isIssueInProgress()) continue;
            filteredConversations.add(conversationDM);
        }
        return filteredConversations;
    }

    private ConversationDM getLastOpenConversation(List<ConversationDM> conversationDMList) {
        if (ListUtils.isEmpty(conversationDMList)) {
            return null;
        }
        ConversationDM lastOpenConversation = null;
        for (ConversationDM conversationDM : conversationDMList) {
            if (!conversationDM.isIssueInProgress()) continue;
            lastOpenConversation = conversationDM;
        }
        return lastOpenConversation;
    }
}

