/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.loaders;

import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.PaginationCursor;
import com.helpshift.conversation.loaders.ConversationDBLoader;
import com.helpshift.conversation.loaders.RemoteConversationLoader;
import java.util.ArrayList;
import java.util.List;

public abstract class ConversationsLoader {
    protected final ConversationDBLoader conversationDBLoader;
    protected final RemoteConversationLoader remoteConversationLoader;
    private final long messagesPageSize;

    public ConversationsLoader(Platform platform, ConversationDBLoader conversationDBLoader, RemoteConversationLoader remoteConversationLoader, long messagesPageSize) {
        this.conversationDBLoader = conversationDBLoader;
        this.remoteConversationLoader = remoteConversationLoader;
        this.messagesPageSize = messagesPageSize;
    }

    public List<ConversationDM> fetchInitialConversations() {
        List<ConversationDM> conversationDMs = this.conversationDBLoader.fetchMessages(null, null, this.messagesPageSize);
        this.updateLocalCache(conversationDMs);
        return conversationDMs;
    }

    public synchronized void loadMoreConversations(PaginationCursor paginationCursor, LoadMoreConversationsCallback callback) {
        List<ConversationDM> result;
        if (callback == null) {
            return;
        }
        if (paginationCursor == null || !this.hasMoreMessages()) {
            callback.onSuccess(new ArrayList<ConversationDM>(), false);
            return;
        }
        if (StringUtils.isEmpty(paginationCursor.conversationCursor) || StringUtils.isEmpty(paginationCursor.messageCursor)) {
            return;
        }
        callback.loading();
        if (this.conversationDBLoader.hasMoreMessages()) {
            result = this.conversationDBLoader.fetchMessages(paginationCursor.conversationCursor, paginationCursor.messageCursor, this.messagesPageSize);
            this.updateLocalCache(result);
            if (!ListUtils.isEmpty(result)) {
                callback.onSuccess(result, this.hasMoreMessages());
                return;
            }
        }
        if (!this.remoteConversationLoader.hasMoreMessage()) {
            callback.onSuccess(new ArrayList<ConversationDM>(), false);
            return;
        }
        try {
            callback.loading();
            boolean isResultUpdated = this.remoteConversationLoader.loadMoreMessages();
            if (isResultUpdated) {
                this.conversationDBLoader.setHasMoreMessages(true);
                result = this.conversationDBLoader.fetchMessages(paginationCursor.conversationCursor, paginationCursor.messageCursor, this.messagesPageSize);
                this.updateLocalCache(result);
                callback.onSuccess(result, this.hasMoreMessages());
            } else {
                callback.onSuccess(new ArrayList<ConversationDM>(), this.hasMoreMessages());
            }
        }
        catch (RootAPIException ex) {
            callback.onError();
        }
    }

    private void updateLocalCache(List<ConversationDM> conversationDMs) {
        if (ListUtils.isEmpty(conversationDMs)) {
            this.conversationDBLoader.setHasMoreMessages(false);
        }
        int totalFetchedMessageCount = 0;
        for (ConversationDM conversationDM : conversationDMs) {
            totalFetchedMessageCount += conversationDM.messageDMs.size();
        }
        if (totalFetchedMessageCount == 0) {
            this.conversationDBLoader.setHasMoreMessages(false);
        }
    }

    public abstract boolean hasMoreMessages();

    public static interface LoadMoreConversationsCallback {
        public void onSuccess(List<ConversationDM> var1, boolean var2);

        public void onError();

        public void loading();
    }
}

