/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.loaders;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.domainmodel.ConversationHistoryRemoteDataFetcher;
import com.helpshift.conversation.domainmodel.ConversationHistoryRemoteDataMerger;
import com.helpshift.conversation.dto.ConversationHistory;

public class RemoteConversationLoader {
    private Platform platform;
    private Domain domain;
    private UserDM userDM;
    private ConversationDAO conversationDAO;
    private ConversationInboxDAO conversationInboxDAO;
    private ConversationHistoryRemoteDataFetcher remoteDataFetcher;
    private ConversationHistoryRemoteDataMerger remoteDataMerger;

    public RemoteConversationLoader(Platform platform, Domain domain, UserDM userDM) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
        this.conversationDAO = platform.getConversationDAO();
        this.conversationInboxDAO = platform.getConversationInboxDAO();
        this.remoteDataFetcher = new ConversationHistoryRemoteDataFetcher(platform, domain, userDM);
        this.remoteDataMerger = new ConversationHistoryRemoteDataMerger(platform, domain, userDM);
    }

    public boolean hasMoreMessage() {
        return this.conversationInboxDAO.getHasOlderMessages(this.userDM.getLocalId());
    }

    public synchronized boolean loadMoreMessages() throws RootAPIException {
        ConversationHistory conversationHistory;
        if (!this.hasMoreMessage()) {
            return false;
        }
        String cursor = this.conversationDAO.getOldestMessageCursor(this.userDM.getLocalId());
        if (StringUtils.isEmpty(cursor)) {
            return false;
        }
        try {
            conversationHistory = this.remoteDataFetcher.fetchConversations(cursor);
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
            }
            throw e;
        }
        this.conversationInboxDAO.saveHasOlderMessages(this.userDM.getLocalId(), conversationHistory.hasOlderMessages);
        this.remoteDataMerger.merge(conversationHistory.conversations);
        return true;
    }
}

