/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.loaders;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.loaders.ConversationsLoader;
import com.helpshift.conversation.loaders.RemoteConversationLoader;
import com.helpshift.conversation.loaders.SingleConversationDBLoader;
import java.util.List;

public class SingleConversationLoader
extends ConversationsLoader {
    private Platform platform;
    private UserDM userDM;
    private Long activeConversationId;
    private boolean isActiveConversationFullyFetched = false;

    public SingleConversationLoader(Platform platform, UserDM userDM, Long activeConversationId, RemoteConversationLoader remoteConversationLoader, long messagesPageSize) {
        super(platform, new SingleConversationDBLoader(platform.getConversationDAO(), activeConversationId), remoteConversationLoader, messagesPageSize);
        this.platform = platform;
        this.userDM = userDM;
        this.activeConversationId = activeConversationId;
    }

    @Override
    public boolean hasMoreMessages() {
        if (this.isActiveConversationFullyFetched) {
            return false;
        }
        boolean isDBHasMoreMessages = this.conversationDBLoader.hasMoreMessages();
        if (isDBHasMoreMessages) {
            return true;
        }
        List<ConversationDM> conversationDMList = this.platform.getConversationDAO().readConversationsWithoutMessages(this.userDM.getLocalId());
        if (!ListUtils.isEmpty(conversationDMList)) {
            long activeConversationCreatedAt = 0L;
            for (ConversationDM conversationDM : conversationDMList) {
                if (!conversationDM.localId.equals(this.activeConversationId)) continue;
                activeConversationCreatedAt = conversationDM.getEpochCreatedAtTime();
                break;
            }
            for (ConversationDM conversationDM : conversationDMList) {
                long conversationCreateAt;
                if (conversationDM.localId.equals(this.activeConversationId) || activeConversationCreatedAt <= (conversationCreateAt = conversationDM.getEpochCreatedAtTime())) continue;
                this.isActiveConversationFullyFetched = true;
                return false;
            }
        }
        return this.remoteConversationLoader.hasMoreMessage();
    }
}

