/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.usersetup;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.conversation.activeconversation.usersetup.UserSetupRenderer;
import com.helpshift.widget.ProgressBarWidget;
import com.helpshift.widget.ProgressDescriptionWidget;
import com.helpshift.widget.Widget;
import com.helpshift.widget.WidgetMediator;

public class UserSetupMediator
implements WidgetMediator {
    private Domain domain;
    private UserSetupRenderer userSetupRenderer;
    private ProgressBarWidget progressBarWidget;
    private ProgressDescriptionWidget progressDescriptionWidget;

    UserSetupMediator(Domain domain, ProgressBarWidget progressBarWidget, ProgressDescriptionWidget progressDescriptionWidget) {
        this.domain = domain;
        this.progressBarWidget = progressBarWidget;
        this.progressDescriptionWidget = progressDescriptionWidget;
        this.progressBarWidget.setMediator(this);
        this.progressDescriptionWidget.setMediator(this);
    }

    synchronized void registerUserSetupRenderer(UserSetupRenderer userSetupRenderer) {
        this.userSetupRenderer = userSetupRenderer;
    }

    synchronized void unregisterUserSetupRenderer() {
        this.userSetupRenderer = null;
    }

    @Override
    public void onChanged(final Widget widget) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (widget == UserSetupMediator.this.progressBarWidget) {
                    UserSetupMediator.this.renderProgressBar();
                } else if (widget == UserSetupMediator.this.progressDescriptionWidget) {
                    UserSetupMediator.this.renderProgressDescriptionWidget();
                }
            }
        });
    }

    private void renderProgressBar() {
        if (this.userSetupRenderer == null) {
            return;
        }
        if (this.progressBarWidget.isVisible()) {
            this.userSetupRenderer.showProgressBar();
            this.userSetupRenderer.hideNoInternetView();
        } else {
            this.userSetupRenderer.hideProgressBar();
        }
    }

    private void renderProgressDescriptionWidget() {
        if (this.userSetupRenderer == null) {
            return;
        }
        if (this.progressDescriptionWidget.isVisible()) {
            this.progressBarWidget.setVisible(true);
            this.userSetupRenderer.showProgressDescription();
        } else {
            this.userSetupRenderer.hideProgressDescription();
        }
    }

    void renderAll() {
        this.renderProgressBar();
        this.renderProgressDescriptionWidget();
    }

    void onSetupCompleted() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (UserSetupMediator.this.userSetupRenderer != null) {
                    UserSetupMediator.this.userSetupRenderer.onUserSetupComplete();
                }
            }
        });
    }

    void showOfflineError() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                UserSetupMediator.this.progressBarWidget.setVisible(false);
                UserSetupMediator.this.progressDescriptionWidget.setVisible(false);
                if (UserSetupMediator.this.userSetupRenderer != null) {
                    UserSetupMediator.this.userSetupRenderer.showNoInternetView();
                }
            }
        });
    }

    void onAuthenticationFailure() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (UserSetupMediator.this.userSetupRenderer != null) {
                    UserSetupMediator.this.userSetupRenderer.onAuthenticationFailure();
                }
            }
        });
    }
}

