/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.usersetup;

import com.helpshift.account.AuthenticationFailureDM;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserSetupDM;
import com.helpshift.account.domainmodel.UserSetupState;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.usersetup.UserSetupRenderer;
import com.helpshift.conversation.usersetup.UserSetupMediator;
import com.helpshift.widget.ProgressBarWidget;
import com.helpshift.widget.ProgressDescriptionWidget;

public class UserSetupVM
implements UserSetupDM.UserSetupListener,
AuthenticationFailureDM.AuthenticationFailureObserver {
    private final ProgressBarWidget progressBarWidget;
    private final ProgressDescriptionWidget progressDescriptionWidget;
    private UserSetupDM userSetupDM;
    private UserSetupMediator userSetupMediator;
    private Platform platform;

    public UserSetupVM(Platform platform, Domain domain, UserSetupDM userSetupDM, UserSetupRenderer userSetupRenderer) {
        this.platform = platform;
        this.userSetupDM = userSetupDM;
        this.progressBarWidget = this.buildProgressBarWidget();
        this.progressDescriptionWidget = new ProgressDescriptionWidget();
        this.userSetupMediator = new UserSetupMediator(domain, this.progressBarWidget, this.progressDescriptionWidget);
        this.userSetupMediator.registerUserSetupRenderer(userSetupRenderer);
        this.userSetupDM.registerUserSetupListener(this);
        domain.getAuthenticationFailureDM().registerListener(this);
    }

    private ProgressBarWidget buildProgressBarWidget() {
        ProgressBarWidget progressBarWidget = new ProgressBarWidget();
        UserSetupState userSetupState = this.userSetupDM.getState();
        progressBarWidget.setVisible(userSetupState == UserSetupState.IN_PROGRESS);
        return progressBarWidget;
    }

    public void onResume() {
        this.userSetupMediator.renderAll();
        UserSetupState userSetupState = this.userSetupDM.getState();
        if (userSetupState == UserSetupState.COMPLETED) {
            this.userSetupMediator.onSetupCompleted();
        } else {
            this.userSetupDM.startSetup();
        }
    }

    public void onDestroyView() {
        this.userSetupMediator.unregisterUserSetupRenderer();
    }

    private void handleUserSetupState(UserSetupState userSetupState) {
        if (!this.platform.isOnline()) {
            this.onNetworkUnavailable();
            return;
        }
        switch (userSetupState) {
            case NON_STARTED: 
            case FAILED: {
                this.progressDescriptionWidget.setVisible(true);
                break;
            }
            case IN_PROGRESS: {
                this.progressBarWidget.setVisible(true);
                break;
            }
            case COMPLETED: {
                this.userSetupMediator.onSetupCompleted();
            }
        }
    }

    @Override
    public void userSetupStateChanged(UserDM userDM, UserSetupState newState) {
        this.handleUserSetupState(newState);
    }

    @Override
    public void onAuthenticationFailure() {
        this.userSetupMediator.onAuthenticationFailure();
    }

    public void onNetworkAvailable() {
        this.progressBarWidget.setVisible(true);
    }

    public void onNetworkUnavailable() {
        this.userSetupMediator.showOfflineError();
    }
}

