/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.account.AuthenticationFailureDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.UIConversation;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.HistoryLoadingState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemRedactedConversationMessageDM;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.viewmodel.ConversationMediator;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.conversation.viewmodel.MessageListVM;
import com.helpshift.conversation.viewmodel.MessageListVMCallback;
import com.helpshift.util.HSLogger;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.ConversationFooterWidget;
import com.helpshift.widget.HistoryLoadingWidget;
import com.helpshift.widget.ReplyFieldWidget;
import com.helpshift.widget.ScrollJumperWidget;
import com.helpshift.widget.WidgetGateway;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class ConversationVM
implements ConversationVMCallback,
MessageListVMCallback,
AuthenticationFailureDM.AuthenticationFailureObserver,
Observer {
    private static final String TAG = "Helpshift_ConvVM";
    public final ViewableConversation viewableConversation;
    final ConversationInboxDM conversationInboxDM;
    final SDKConfigurationDM sdkConfigurationDM;
    protected ConversationFooterWidget conversationFooterWidget;
    protected ButtonWidget attachImageButtonWidget;
    ConversationRenderer renderer;
    Domain domain;
    Platform platform;
    ReplyFieldWidget replyFieldWidget;
    WidgetGateway widgetGateway;
    ConversationMediator conversationMediator;
    ButtonWidget replyBoxWidget;
    HistoryLoadingWidget historyLoadingWidget;
    MessageListVM messageListVM;
    private ScrollJumperWidget scrollJumperWidget;
    private ButtonWidget confirmationBoxWidget;
    private boolean retainMessageBoxOnUI;
    private boolean isScreenCurrentlyVisible;

    public ConversationVM(Platform platform, Domain domain, ConversationInboxDM conversationInboxDM, ViewableConversation viewableConversation, ConversationRenderer renderer, boolean retainMessageBoxOnUI) {
        this.domain = domain;
        this.platform = platform;
        this.conversationInboxDM = conversationInboxDM;
        this.viewableConversation = viewableConversation;
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.retainMessageBoxOnUI = retainMessageBoxOnUI;
        this.sdkConfigurationDM.addObserver(this);
        domain.getAuthenticationFailureDM().registerListener(this);
        this.createWidgetGateway();
        this.conversationMediator = this.createMediator(domain);
        this.attachImageButtonWidget = this.widgetGateway.makeAttachImageButtonWidget();
        this.conversationMediator.setAttachImageButton(this.attachImageButtonWidget);
        ButtonWidget replyButtonWidget = new ButtonWidget();
        this.replyFieldWidget = this.widgetGateway.makeReplyFieldWidget();
        this.scrollJumperWidget = this.widgetGateway.makeScrollJumperWidget();
        this.conversationMediator.setScrollJumperWidget(this.scrollJumperWidget);
        this.conversationMediator.setReplyButtonWidget(replyButtonWidget);
        this.conversationMediator.setReplyFieldWidget(this.replyFieldWidget);
        boolean shouldShowReplyBoxOnConversationRejected = this.shouldShowReplyBoxOnConversationRejected();
        ConversationDM activeConversation = viewableConversation.getActiveConversation();
        activeConversation.setEnableMessageClickOnResolutionRejected(shouldShowReplyBoxOnConversationRejected);
        this.replyBoxWidget = this.widgetGateway.makeReplyBoxWidget(activeConversation, shouldShowReplyBoxOnConversationRejected);
        this.conversationMediator.setReplyBoxWidget(this.replyBoxWidget);
        this.confirmationBoxWidget = this.widgetGateway.makeConfirmationBoxWidget(activeConversation);
        this.conversationMediator.setConfirmationBoxWidget(this.confirmationBoxWidget);
        this.conversationFooterWidget = this.widgetGateway.makeConversationFooterWidget(activeConversation, shouldShowReplyBoxOnConversationRejected);
        this.conversationMediator.setConversationFooterWidget(this.conversationFooterWidget);
        this.historyLoadingWidget = new HistoryLoadingWidget();
        this.conversationMediator.setHistoryLoadingWidget(this.historyLoadingWidget);
        if (this.replyBoxWidget.isVisible()) {
            conversationInboxDM.setConversationViewState(2);
        } else {
            conversationInboxDM.setConversationViewState(-1);
        }
        if (!shouldShowReplyBoxOnConversationRejected && activeConversation.state == IssueState.RESOLUTION_REJECTED) {
            activeConversation.handleConversationEnded();
        }
        viewableConversation.setConversationVMCallback(this);
        this.renderer = renderer;
        this.conversationMediator.setRenderer(this.renderer);
        this.conversationMediator.renderAll();
        this.initMessagesList();
    }

    protected void createWidgetGateway() {
        this.widgetGateway = new WidgetGateway(this.sdkConfigurationDM, this.conversationInboxDM);
    }

    protected ConversationMediator createMediator(Domain domain) {
        return new ConversationMediator(domain);
    }

    protected void initMessagesList() {
        if (this.messageListVM != null) {
            this.messageListVM.unregisterMessageListVMCallback();
        }
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        this.viewableConversation.initializeConversationsForUI();
        activeConversation.initializeIssueStatusForUI();
        boolean hasMoreMessages = this.viewableConversation.hasMoreMessages();
        this.messageListVM = new MessageListVM(this.platform, this.domain);
        List<UIConversation> uiConversationOrder = this.viewableConversation.getUIConversations();
        ArrayList<MessageDM> messageDMs = new ArrayList<MessageDM>();
        List<ConversationDM> conversationDMList = this.viewableConversation.getAllConversations();
        for (ConversationDM conversationDM : conversationDMList) {
            messageDMs.addAll(this.getUIMessages(conversationDM));
        }
        this.messageListVM.initializeMessageList(uiConversationOrder, messageDMs, hasMoreMessages, this);
        this.renderer.initializeMessages(this.messageListVM.getUiMessageDMs());
        this.viewableConversation.registerMessagesObserver(this);
        boolean isStateRejected = activeConversation.state == IssueState.REJECTED;
        this.conversationMediator.setConversationRejected(isStateRejected);
        this.prefillReplyBox();
    }

    protected void prefillReplyBox() {
        this.renderer.setReply(this.conversationInboxDM.getUserReplyText());
    }

    private List<MessageDM> getUIMessages(ConversationDM conversationDM) {
        ArrayList<MessageDM> result = new ArrayList<MessageDM>();
        if (conversationDM.isRedacted) {
            result.add(this.generateSystemRedactedConversationMessageDM(conversationDM));
        } else {
            result.addAll(this.buildUIMessages(conversationDM));
        }
        return result;
    }

    protected List<MessageDM> buildUIMessages(ConversationDM conversationDM) {
        return new ArrayList<MessageDM>(conversationDM.messageDMs);
    }

    private SystemRedactedConversationMessageDM generateSystemRedactedConversationMessageDM(ConversationDM conversationDM) {
        SystemRedactedConversationMessageDM systemRedactedConversationMessageDM = new SystemRedactedConversationMessageDM(conversationDM.getCreatedAt(), conversationDM.getEpochCreatedAtTime(), 1);
        systemRedactedConversationMessageDM.setDependencies(this.domain, this.platform);
        systemRedactedConversationMessageDM.conversationLocalId = conversationDM.localId;
        return systemRedactedConversationMessageDM;
    }

    public void onResume() {
        this.refreshVM();
        this.renderMenuItems();
        this.setScreenVisibility(true);
        this.setUserCanReadMessages(true);
        this.markMessagesAsSeenOnEntry();
        this.clearNotifications();
    }

    public void onPause() {
        this.setScreenVisibility(false);
        this.setUserCanReadMessages(false);
        this.markMessagesAsSeenOnExit();
        this.clearNotifications();
        this.resetIncrementMessageCountFlag();
        this.saveReplyText(this.renderer.getReply());
    }

    public boolean shouldShowUnreadMessagesIndicator() {
        return this.scrollJumperWidget.shouldShowUnreadMessagesIndicator();
    }

    public void refreshVM() {
        boolean shouldShowReplyBoxOnConversationRejected = this.shouldShowReplyBoxOnConversationRejected();
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        this.widgetGateway.updateReplyBoxWidget(this.replyBoxWidget, activeConversation, shouldShowReplyBoxOnConversationRejected);
        this.widgetGateway.updateConfirmationBoxWidget(this.confirmationBoxWidget, activeConversation);
        this.widgetGateway.updateConversationFooterWidget(this.conversationFooterWidget, activeConversation, shouldShowReplyBoxOnConversationRejected);
        if (this.replyBoxWidget.isVisible()) {
            this.conversationInboxDM.setConversationViewState(2);
        } else {
            this.conversationInboxDM.setConversationViewState(-1);
        }
        this.viewableConversation.registerMessagesObserver(this);
        this.viewableConversation.setConversationVMCallback(this);
        if (activeConversation.serverId != null || activeConversation.preConversationServerId != null) {
            this.conversationInboxDM.getConversationInboxPoller().startChatPoller();
        }
    }

    public void unregisterRenderer() {
        this.viewableConversation.unregisterConversationVMCallback();
        if (this.messageListVM != null) {
            this.messageListVM.unregisterMessageListVMCallback();
            this.messageListVM = null;
        }
        this.renderer = null;
        this.conversationMediator.setRenderer(null);
        this.sdkConfigurationDM.deleteObserver(this);
        this.conversationInboxDM.deletePreIssueIfNotCreated(this.viewableConversation);
        this.domain.getAuthenticationFailureDM().unregisterListener(this);
    }

    private void setUserCanReadMessages(boolean value) {
        this.conversationInboxDM.setUserCanReadMessages(value);
        this.onAgentTypingUpdate(this.viewableConversation.isAgentTyping());
    }

    public void saveReplyText(String reply) {
        this.conversationInboxDM.saveUserReplyText(reply);
    }

    public void clearUserReplyDraft() {
        this.conversationInboxDM.saveUserReplyText("");
        this.clearReply();
    }

    public void sendTextMessage() {
        String replyToBeSent = this.renderer.getReply();
        if (StringUtils.isEmpty(replyToBeSent)) {
            return;
        }
        this.conversationInboxDM.setPersistMessageBox(true);
        this.sendTextMessage(replyToBeSent.trim());
    }

    void clearReply() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.setReply("");
                }
            }
        });
    }

    protected void sendTextMessage(final String reply) {
        this.clearReply();
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.getActiveConversation().sendTextMessage(reply);
            }
        });
    }

    public void retryMessage(final MessageDM readableMessage) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.domain.runParallel(new F(){

                    @Override
                    public void f() {
                        ConversationVM.this.viewableConversation.getActiveConversation().retryMessage(readableMessage);
                    }
                });
            }
        });
    }

    public void handleScreenshotMessageClick(final ScreenshotMessageDM message) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.onScreenshotMessageClicked(message);
            }
        });
    }

    public void handleAppReviewRequestClick(final RequestAppReviewMessageDM requestAppReviewMessageDM) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                final String reviewUrl = ConversationVM.this.sdkConfigurationDM.getString("reviewUrl").trim();
                if (!StringUtils.isEmpty(reviewUrl)) {
                    ConversationVM.this.sdkConfigurationDM.setAppReviewed(true);
                    ConversationVM.this.domain.runOnUI(new F(){

                        @Override
                        public void f() {
                            if (ConversationVM.this.renderer != null) {
                                ConversationVM.this.renderer.openAppReviewStore(reviewUrl);
                            }
                        }
                    });
                }
                ConversationVM.this.viewableConversation.getActiveConversation().handleAppReviewRequestClick(requestAppReviewMessageDM);
            }
        });
    }

    @Override
    public void launchScreenshotAttachment(final String filePath, final String contentType) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.launchScreenshotAttachment(filePath, contentType);
                }
            }
        });
    }

    @Override
    public boolean isMessageBoxVisible() {
        return this.replyBoxWidget.isVisible();
    }

    @Override
    public boolean isVisibleOnUI() {
        return this.isScreenCurrentlyVisible;
    }

    private void setScreenVisibility(boolean isScreenCurrentlyVisible) {
        this.isScreenCurrentlyVisible = isScreenCurrentlyVisible;
    }

    @Override
    public void onAgentTypingUpdate(final boolean isAgentTyping) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    boolean shouldShowTypingIndicator = false;
                    if (ConversationVM.this.viewableConversation.getActiveConversation().isIssueInProgress()) {
                        shouldShowTypingIndicator = isAgentTyping;
                    }
                    ConversationVM.this.updateTypingIndicatorStatus(shouldShowTypingIndicator);
                }
            }
        });
    }

    @Override
    public void onConversationInboxPollFailure() {
    }

    @Override
    public void onConversationInboxPollSuccess() {
    }

    @Override
    public void handlePreIssueCreationSuccess() {
    }

    private List<MessageDM> getUIMessagesForHistory(ConversationDM conversationDM) {
        ArrayList<MessageDM> result = new ArrayList<MessageDM>();
        if (conversationDM.isRedacted) {
            result.add(this.generateSystemRedactedConversationMessageDM(conversationDM));
        } else {
            result.addAll(conversationDM.messageDMs);
        }
        return result;
    }

    @Override
    public void prependConversations(List<ConversationDM> conversations, boolean hasOlderMessages) {
        if (ListUtils.isEmpty(conversations)) {
            if (!hasOlderMessages) {
                this.messageListVM.prependMessages(new ArrayList<MessageDM>(), false);
            }
            return;
        }
        List<UIConversation> uiConversationOrderList = this.viewableConversation.getUIConversations();
        ArrayList<MessageDM> messageDMList = new ArrayList<MessageDM>();
        for (ConversationDM conversation : conversations) {
            messageDMList.addAll(this.getUIMessagesForHistory(conversation));
        }
        if (this.messageListVM != null) {
            this.messageListVM.updateUIConversationOrder(uiConversationOrderList);
            this.messageListVM.prependMessages(messageDMList, hasOlderMessages);
        }
    }

    @Override
    public void onHistoryLoadingSuccess() {
        this.conversationMediator.setHistoryLoadingWidgetState(HistoryLoadingState.NONE);
    }

    @Override
    public void onHistoryLoadingError() {
        this.conversationMediator.setHistoryLoadingWidgetState(HistoryLoadingState.ERROR);
    }

    @Override
    public void onHistoryLoadingStarted() {
        this.conversationMediator.setHistoryLoadingWidgetState(HistoryLoadingState.LOADING);
    }

    public void sendScreenShot(final ImagePickerFile imagePickerFile, final String referId) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.getActiveConversation().sendScreenshot(imagePickerFile, referId);
            }
        });
    }

    public void handleAdminAttachmentMessageClick(final AttachmentMessageDM message) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.onAdminAttachmentMessageClicked(message);
            }
        });
    }

    @Override
    public void launchAttachment(final String filePath, final String contentType) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.launchAttachment(filePath, contentType);
                }
            }
        });
    }

    public void markConversationResolutionStatus(final boolean accepted) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                HSLogger.d(ConversationVM.TAG, "Sending resolution event : Accepted? " + accepted);
                ConversationDM activeConversation = ConversationVM.this.viewableConversation.getActiveConversation();
                if (activeConversation.state == IssueState.RESOLUTION_REQUESTED) {
                    activeConversation.markConversationResolutionStatus(accepted);
                }
            }
        });
    }

    private void markMessagesAsSeenOnEntry() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationDM activeConversationDM = ConversationVM.this.viewableConversation.getActiveConversation();
                if (activeConversationDM != null) {
                    activeConversationDM.markMessagesAsSeen();
                }
            }
        });
    }

    private void markMessagesAsSeenOnExit() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                for (ConversationDM conversation : ConversationVM.this.viewableConversation.getAllConversations()) {
                    conversation.markMessagesAsSeen();
                }
            }
        });
    }

    public void renderMenuItems() {
        this.conversationMediator.renderAll();
    }

    @Override
    public void onIssueStatusChange(IssueState newStatus) {
        boolean isConversationRejected = false;
        int conversationViewState = -1;
        boolean hideAgentTypingIndicator = true;
        boolean showUnreadMessageCountIndicator = true;
        HSLogger.d(TAG, "Changing conversation status to: " + (Object)((Object)newStatus));
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        if (activeConversation.isInProgressState(newStatus)) {
            this.resetDefaultMenuItemsVisibility();
            this.conversationMediator.showMessageBox();
            conversationViewState = 2;
            hideAgentTypingIndicator = false;
        } else if (newStatus == IssueState.RESOLUTION_REQUESTED) {
            if (this.sdkConfigurationDM.shouldShowConversationResolutionQuestion()) {
                this.conversationMediator.confirmationBox();
            }
            showUnreadMessageCountIndicator = false;
            if (!this.scrollJumperWidget.isVisible()) {
                this.notifyRendererForScrollToBottom();
            }
        } else if (newStatus == IssueState.REJECTED) {
            isConversationRejected = true;
            this.handleConversationRejectedState();
        } else if (newStatus == IssueState.RESOLUTION_ACCEPTED) {
            this.conversationInboxDM.saveUserReplyText("");
            if (activeConversation.shouldShowCSATInFooter()) {
                this.conversationMediator.showStartNewConversation(ConversationFooterState.CSAT_RATING);
            } else {
                this.conversationMediator.showStartNewConversation(ConversationFooterState.START_NEW_CONVERSATION);
            }
        } else if (newStatus == IssueState.RESOLUTION_REJECTED) {
            this.conversationInboxDM.setPersistMessageBox(false);
            this.conversationMediator.showMessageBox();
            activeConversation.setEnableMessageClickOnResolutionRejected(true);
            conversationViewState = 2;
        } else if (newStatus == IssueState.ARCHIVED) {
            this.conversationMediator.showStartNewConversation(ConversationFooterState.ARCHIVAL_MESSAGE);
        } else if (newStatus == IssueState.AUTHOR_MISMATCH) {
            this.conversationMediator.showStartNewConversation(ConversationFooterState.AUTHOR_MISMATCH);
        }
        if (showUnreadMessageCountIndicator) {
            this.updateUIOnNewMessageReceived();
        }
        if (hideAgentTypingIndicator) {
            this.onAgentTypingUpdate(false);
        }
        this.conversationInboxDM.setConversationViewState(conversationViewState);
        if (!isConversationRejected) {
            this.conversationMediator.setConversationRejected(false);
        }
    }

    void handleConversationRejectedState() {
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        this.conversationInboxDM.saveUserReplyText("");
        ConversationFooterState conversationFooterState = activeConversation.isRedacted ? ConversationFooterState.REDACTED_STATE : ConversationFooterState.REJECTED_MESSAGE;
        this.conversationMediator.showStartNewConversation(conversationFooterState);
        this.conversationMediator.setConversationRejected(true);
    }

    protected void resetDefaultMenuItemsVisibility() {
        this.attachImageButtonWidget.setVisible(this.widgetGateway.getDefaultVisibilityForAttachImageButton());
    }

    public void onImageAttachmentButtonClick() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.conversationInboxDM.setPersistMessageBox(true);
            }
        });
    }

    private boolean shouldShowReplyBoxOnConversationRejected() {
        return !StringUtils.isEmpty(this.conversationInboxDM.getUserReplyText()) || this.conversationInboxDM.shouldPersistMessageBox() || this.retainMessageBoxOnUI;
    }

    public void onCSATSurveySubmitted(final int rating, final String feedback) {
        ConversationDM activeConversation;
        if (this.renderer != null) {
            this.renderer.showCSATSubmittedView();
        }
        if (!(activeConversation = this.viewableConversation.getActiveConversation()).isIssueInProgress()) {
            this.conversationMediator.showStartNewConversation(ConversationFooterState.START_NEW_CONVERSATION);
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                HSLogger.d(ConversationVM.TAG, "Sending CSAT rating : " + rating + ", feedback: " + feedback);
                activeConversation.sendCSATSurvey(rating, feedback);
            }
        });
    }

    public void setConversationViewState(int conversationViewState) {
        this.conversationInboxDM.setConversationViewState(conversationViewState);
    }

    public void onNewConversationButtonClicked() {
        this.stopLiveUpdates();
        this.viewableConversation.getActiveConversation().setStartNewConversationButtonClicked(true, true);
    }

    private void clearNotifications() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationDM activeConversation = ConversationVM.this.viewableConversation.getActiveConversation();
                ConversationVM.this.conversationInboxDM.clearNotification(activeConversation);
                ConversationVM.this.conversationInboxDM.resetPushNotificationCount(activeConversation);
            }
        });
    }

    private void resetIncrementMessageCountFlag() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.getActiveConversation().setShouldIncrementMessageCount(false, true);
            }
        });
    }

    public void pushAnalyticsEvent(AnalyticsEventType type, Map<String, Object> data) {
        this.domain.getAnalyticsEventDM().pushEvent(type, data);
    }

    public void onAdminMessageLinkClicked(String url, MessageDM messageDM) {
        String protocol = null;
        try {
            URI uri = URI.create(url);
            if (uri != null) {
                protocol = uri.getScheme();
            }
        }
        catch (Exception uri) {
            // empty catch block
        }
        Long conversationLocalId = messageDM.conversationLocalId;
        List<ConversationDM> conversationDMs = this.viewableConversation.getAllConversations();
        ConversationDM correspondingConversationDM = null;
        for (ConversationDM conversationDM : conversationDMs) {
            if (!conversationDM.localId.equals(conversationLocalId)) continue;
            correspondingConversationDM = conversationDM;
            break;
        }
        if (!StringUtils.isEmpty(protocol)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (correspondingConversationDM != null) {
                if (!StringUtils.isEmpty(correspondingConversationDM.preConversationServerId)) {
                    data.put("preissue_id", correspondingConversationDM.preConversationServerId);
                }
                if (!StringUtils.isEmpty(correspondingConversationDM.serverId)) {
                    data.put("issue_id", correspondingConversationDM.serverId);
                }
            }
            data.put("p", protocol);
            data.put("u", url);
            this.pushAnalyticsEvent(AnalyticsEventType.ADMIN_MESSAGE_DEEPLINK_CLICKED, data);
        }
    }

    public void startLiveUpdates() {
        this.viewableConversation.startLiveUpdates();
    }

    public void stopLiveUpdates() {
        this.viewableConversation.stopLiveUpdates();
    }

    @Override
    public void update(final Observable observable, Object o) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null && observable instanceof SDKConfigurationDM) {
                    ConversationVM.this.refreshAll();
                }
            }
        });
    }

    public void onSkipClick() {
    }

    @Override
    public void add(MessageDM element) {
        this.addAll((Collection<? extends MessageDM>)Collections.singletonList(element));
    }

    @Override
    public void addAll(Collection<? extends MessageDM> elements) {
        HSLogger.d(TAG, "addAll called : " + elements.size());
        if (this.messageListVM != null) {
            this.messageListVM.addMessages(elements);
        }
    }

    @Override
    public void update(MessageDM element) {
        HSLogger.d(TAG, "update called : " + element);
        if (this.messageListVM != null) {
            this.messageListVM.insertOrUpdateMessage(element);
        }
    }

    public void updateLastUserActivityTime() {
        this.viewableConversation.getActiveConversation().updateLastUserActivityTime(System.currentTimeMillis());
    }

    @Override
    public void appendMessages(int startPosition, int itemCount) {
        if (this.renderer != null) {
            this.renderer.appendMessages(startPosition, itemCount);
        }
    }

    @Override
    public void newAdminMessagesAdded() {
        this.updateUIOnNewMessageReceived();
    }

    @Override
    public void newUserMessagesAdded() {
        this.notifyRendererForScrollToBottom();
    }

    private void showUnreadMessagesIndicator() {
        this.scrollJumperWidget.setShouldShowUnreadMessagesIndicator(true);
    }

    protected void updateUIOnNewMessageReceived() {
        if (this.scrollJumperWidget.isVisible()) {
            this.showUnreadMessagesIndicator();
        } else {
            this.notifyRendererForScrollToBottom();
        }
    }

    @Override
    public void updateMessages(int startPosition, int itemCount) {
        if (this.renderer != null) {
            this.renderer.updateMessages(startPosition, itemCount);
        }
    }

    @Override
    public void refreshAll() {
        if (this.renderer != null) {
            this.renderer.notifyRefreshList();
        }
    }

    @Override
    public void onUIMessageListUpdated() {
    }

    @Override
    public void onAuthenticationFailure() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.onAuthenticationFailure();
                }
            }
        });
    }

    public void onScrollJumperViewClicked() {
        this.notifyRendererForScrollToBottom();
    }

    public void onScrolledToBottom() {
        this.scrollJumperWidget.setVisible(false);
        this.scrollJumperWidget.setShouldShowUnreadMessagesIndicator(false);
    }

    public void onScrolling() {
        this.scrollJumperWidget.setVisible(true);
    }

    public void onScrolledToTop() {
        if (this.historyLoadingWidget.getState() == HistoryLoadingState.NONE) {
            this.loadHistoryMessagesInternal();
        }
    }

    public void retryHistoryLoadingMessages() {
        if (this.historyLoadingWidget.getState() == HistoryLoadingState.ERROR) {
            this.loadHistoryMessagesInternal();
        }
    }

    private void loadHistoryMessagesInternal() {
        if (this.historyLoadingWidget.getState() == HistoryLoadingState.LOADING) {
            return;
        }
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationVM.this.viewableConversation.loadMoreMessages();
            }
        });
    }

    protected void updateTypingIndicatorStatus(boolean shouldShowTypingIndicator) {
        boolean shouldScrollToBottom = false;
        if (shouldShowTypingIndicator) {
            this.renderer.showAgentTypingIndicator();
            shouldScrollToBottom = !this.scrollJumperWidget.isVisible();
        } else {
            this.renderer.hideAgentTypingIndicator();
        }
        if (shouldScrollToBottom) {
            this.notifyRendererForScrollToBottom();
        }
    }

    private void notifyRendererForScrollToBottom() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationVM.this.renderer != null) {
                    ConversationVM.this.renderer.scrollToBottom();
                }
            }
        });
    }

    public void updateUnreadMessageCountIndicator(boolean shouldShowUnreadMessageCountIndicator) {
        this.scrollJumperWidget.setShouldShowUnreadMessagesIndicator(shouldShowUnreadMessageCountIndicator);
    }
}

