/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.domain.Domain;
import com.helpshift.conversation.activeconversation.ConversationalRenderer;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.viewmodel.ConversationMediator;
import com.helpshift.conversation.viewmodel.ConversationalMediatorCallback;

class ConversationalMediator
extends ConversationMediator {
    private boolean isBotExecuting;
    private MessageDM botMessageDM;
    private final ConversationalMediatorCallback conversationalMediatorCallback;

    ConversationalMediator(Domain domain, ConversationalMediatorCallback conversationalMediatorCallback) {
        super(domain);
        this.conversationalMediatorCallback = conversationalMediatorCallback;
    }

    private ConversationalRenderer getConversationalRenderer() {
        return (ConversationalRenderer)this.renderer;
    }

    public void setIsBotExecuting(boolean isBotExecuting) {
        this.isBotExecuting = isBotExecuting;
    }

    public void setBotMessageDMToRender(MessageDM botMessageDM) {
        this.botMessageDM = botMessageDM;
    }

    public MessageDM getRenderedBotMessage() {
        return this.botMessageDM;
    }

    private void showOptions(OptionInputMessageDM optionInputMessageDM) {
        if (optionInputMessageDM.input.type == OptionInput.Type.PILL) {
            this.getConversationalRenderer().showInput(optionInputMessageDM.input);
        } else {
            this.conversationalMediatorCallback.showListPicker(optionInputMessageDM);
        }
    }

    @Override
    protected void renderReplyBoxWidget() {
        if (this.renderer == null) {
            return;
        }
        if (this.botMessageDM != null && this.isBotExecuting && !this.isConversationRejected) {
            switch (this.botMessageDM.messageType) {
                case ADMIN_TEXT_WITH_TEXT_INPUT: {
                    AdminMessageWithTextInputDM adminMessageWithTextInputDM = (AdminMessageWithTextInputDM)this.botMessageDM;
                    this.getConversationalRenderer().showInput(adminMessageWithTextInputDM.input);
                    return;
                }
                case OPTION_INPUT: {
                    this.showOptions((OptionInputMessageDM)this.botMessageDM);
                    return;
                }
            }
        }
        if (this.replyBoxWidget.isVisible()) {
            this.renderer.showSendReplyUI();
        } else {
            this.renderer.hideSendReplyUI();
        }
    }
}

