/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationalRenderer;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForOptionInput;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForTextInputDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.activeconversation.message.input.TextInput;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.viewmodel.ConversationMediator;
import com.helpshift.conversation.viewmodel.ConversationVM;
import com.helpshift.conversation.viewmodel.ConversationalMediator;
import com.helpshift.conversation.viewmodel.ConversationalMediatorCallback;
import com.helpshift.conversation.viewmodel.ListPickerVM;
import com.helpshift.conversation.viewmodel.ListPickerVMCallback;
import com.helpshift.conversation.viewmodel.OptionUIModel;
import com.helpshift.util.HSLogger;
import com.helpshift.util.ValuePair;
import com.helpshift.widget.ConversationalWidgetGateway;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ConversationalVM
extends ConversationVM
implements ConversationInboxDM.StartNewConversationListener,
ConversationalMediatorCallback,
ListPickerVMCallback {
    public static final int PRE_ISSUE_CREATION_ERROR = 0;
    public static final int NO_NETWORK_ERROR = 1;
    public static final int POLL_FAILURE_ERROR = 2;
    private static final String TAG = "Helpshift_ConvsatnlVM";
    boolean isNetworkAvailable = true;
    boolean isInBetweenBotExecution;
    boolean isUserReplyDraftClearedForBotChange;
    boolean awaitingUserInputForBotStep;
    boolean isShowingPollFailureError;
    private boolean showConversationHistory;
    private ListPickerVM listPickerVM;

    public ConversationalVM(Platform platform, Domain domain, ConversationInboxDM conversationInboxDM, ViewableConversation viewableConversation, ConversationalRenderer renderer, boolean showConversationHistory, boolean retainMessageBoxOnUI) {
        super(platform, domain, conversationInboxDM, viewableConversation, renderer, retainMessageBoxOnUI);
        this.showConversationHistory = showConversationHistory;
        ConversationDM activeConversation = viewableConversation.getActiveConversation();
        if (!activeConversation.isInProgressState(activeConversation.state) && activeConversation.isStartNewConversationClicked) {
            this.onNewConversationButtonClicked();
        }
    }

    @Override
    protected void createWidgetGateway() {
        this.widgetGateway = new ConversationalWidgetGateway(this.sdkConfigurationDM, this.viewableConversation.getActiveConversation(), this.conversationInboxDM);
    }

    @Override
    protected ConversationMediator createMediator(Domain domain) {
        return new ConversationalMediator(domain, this);
    }

    @Override
    protected void initMessagesList() {
        super.initMessagesList();
        this.addGreetingMessageIfNewPreIssue();
    }

    @Override
    protected void prefillReplyBox() {
        String prefillText = this.conversationInboxDM.getUserReplyText();
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        if (StringUtils.isEmpty(prefillText) && !activeConversation.containsAtleastOneUserMessage()) {
            String archivalPrefillText = this.conversationInboxDM.getConversationArchivalPrefillText();
            prefillText = StringUtils.isEmpty(archivalPrefillText) ? this.sdkConfigurationDM.getString("conversationPrefillText") : archivalPrefillText;
        }
        if (prefillText != null) {
            this.renderer.setReply(prefillText);
        }
    }

    private void addGreetingMessageIfNewPreIssue() {
        String greetingMessage;
        if (StringUtils.isEmpty(this.viewableConversation.getActiveConversation().serverId) && StringUtils.isEmpty(this.viewableConversation.getActiveConversation().preConversationServerId) && !StringUtils.isEmpty(greetingMessage = this.sdkConfigurationDM.getString("conversationGreetingMessage"))) {
            String currentFormattedTime = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(currentFormattedTime);
            AdminMessageDM greetingMessageDM = new AdminMessageDM("", greetingMessage, currentFormattedTime, epochCreatedAtTime, "Bot");
            greetingMessageDM.setDependencies(this.domain, this.platform);
            greetingMessageDM.conversationLocalId = this.viewableConversation.getActiveConversation().localId;
            this.messageListVM.addMessages(Collections.singletonList(greetingMessageDM));
        }
    }

    @Override
    protected List<MessageDM> buildUIMessages(ConversationDM conversationDM) {
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        boolean isActive = activeConversation.localId.equals(conversationDM.localId);
        if (isActive && activeConversation.shouldOpen()) {
            return this.processMessagesForBots(conversationDM.messageDMs, false);
        }
        return new ArrayList<MessageDM>(conversationDM.messageDMs);
    }

    private List<MessageDM> processMessagesForBots(Collection<? extends MessageDM> messages, boolean currentBotExecutionState) {
        ArrayList<MessageDM> processedMessages = new ArrayList<MessageDM>(messages);
        ConversationDM conversationDM = this.viewableConversation.getActiveConversation();
        this.isInBetweenBotExecution = conversationDM.evaluateBotExecutionState(processedMessages, currentBotExecutionState);
        this.getConversationalMediator().setIsBotExecuting(this.isInBetweenBotExecution);
        if (this.isInBetweenBotExecution) {
            MessageDM messageDM = conversationDM.getLatestActionableBotMessage();
            MessageDM lastRenderedBot = this.getConversationalMediator().getRenderedBotMessage();
            if (lastRenderedBot != null && messageDM != null && lastRenderedBot.serverId.equals(messageDM.serverId)) {
                this.awaitingUserInputForBotStep = true;
                return processedMessages;
            }
            if (messageDM != null && (messageDM.messageType == MessageType.ADMIN_TEXT_WITH_OPTION_INPUT || messageDM.messageType == MessageType.FAQ_LIST_WITH_OPTION_INPUT)) {
                int index = processedMessages.indexOf(messageDM);
                if (index != -1) {
                    ValuePair<MessageDM, OptionInputMessageDM> optionsMessagePair = messageDM.messageType == MessageType.ADMIN_TEXT_WITH_OPTION_INPUT ? this.splitOptionsBotMessage((AdminMessageWithOptionInputDM)messageDM) : this.splitOptionsBotMessage((FAQListMessageWithOptionInputDM)messageDM);
                    this.incrementCreatedAt((MessageDM)optionsMessagePair.second, (MessageDM)optionsMessagePair.first);
                    processedMessages.remove(index);
                    processedMessages.add(index, (MessageDM)optionsMessagePair.first);
                    if (((OptionInputMessageDM)optionsMessagePair.second).input.type == OptionInput.Type.PILL) {
                        processedMessages.add(index + 1, (MessageDM)optionsMessagePair.second);
                    }
                    this.getConversationalMediator().setBotMessageDMToRender((MessageDM)optionsMessagePair.second);
                }
            } else {
                this.getConversationalMediator().setBotMessageDMToRender(messageDM);
            }
            if (messageDM != null) {
                this.removeOptionsMessageFromUI();
                this.awaitingUserInputForBotStep = true;
            } else {
                this.awaitingUserInputForBotStep = false;
            }
        } else {
            this.awaitingUserInputForBotStep = false;
        }
        return processedMessages;
    }

    private void removeOptionsMessageFromUI() {
        if (this.messageListVM == null) {
            return;
        }
        List<MessageDM> currentUIMessages = this.messageListVM.copyOfUIMessageDMs();
        ArrayList<MessageDM> previousOptionsMessageDMs = new ArrayList<MessageDM>();
        if (!ListUtils.isEmpty(currentUIMessages)) {
            for (MessageDM message : currentUIMessages) {
                if (message.messageType != MessageType.OPTION_INPUT) continue;
                previousOptionsMessageDMs.add(message);
            }
            this.messageListVM.remove(previousOptionsMessageDMs);
        }
        this.hideListPicker(false);
    }

    @Override
    public void refreshVM() {
        super.refreshVM();
        if (StringUtils.isEmpty(this.viewableConversation.getActiveConversation().serverId) && StringUtils.isEmpty(this.viewableConversation.getActiveConversation().preConversationServerId)) {
            this.createPreIssue();
        } else {
            this.evaluateBotMessages(this.viewableConversation.getActiveConversation().messageDMs);
        }
    }

    public void createPreIssue() {
        if (!this.isNetworkAvailable) {
            this.onCreateConversationFailure(new Exception("No internet connection."));
            return;
        }
        this.disableUserInputOptions();
        this.showFakeTypingIndicator(true);
        this.conversationInboxDM.createPreIssue(this.viewableConversation, this);
    }

    @Override
    public void onConversationInboxPollFailure() {
        HSLogger.e(TAG, "On conversation inbox poll failure");
        this.showFakeTypingIndicator(false);
        if (this.platform.isOnline() && !this.awaitingUserInputForBotStep && (this.isInBetweenBotExecution || this.viewableConversation.getActiveConversation().isInPreIssueMode()) && this.viewableConversation.getActiveConversation().isIssueInProgress()) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    if (ConversationalVM.this.getConversationalRenderer() != null) {
                        ConversationalVM.this.getConversationalRenderer().showNetworkErrorFooter(2);
                    }
                }
            });
            this.isShowingPollFailureError = true;
        }
    }

    @Override
    public void onConversationInboxPollSuccess() {
        if (this.isShowingPollFailureError) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    if (ConversationalVM.this.getConversationalRenderer() != null) {
                        ConversationalVM.this.getConversationalRenderer().hideNetworkErrorFooter();
                    }
                }
            });
            this.isShowingPollFailureError = false;
        }
    }

    void showFakeTypingIndicator(final boolean showFakeTAI) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationalVM.this.renderer == null) {
                    return;
                }
                boolean shouldShowTypingIndicator = false;
                if (ConversationalVM.this.viewableConversation.getActiveConversation().isIssueInProgress() || ConversationalVM.this.viewableConversation.getActiveConversation().isInPreIssueMode() || ConversationalVM.this.isInBetweenBotExecution) {
                    shouldShowTypingIndicator = ConversationalVM.this.viewableConversation.isAgentTyping() || showFakeTAI;
                }
                ConversationalVM.this.updateTypingIndicatorStatus(shouldShowTypingIndicator);
            }
        });
    }

    @Override
    protected void sendTextMessage(final String reply) {
        this.updateLastUserActivityTime();
        ConversationDM conversationDM = this.viewableConversation.getActiveConversation();
        if (!conversationDM.containsAtleastOneUserMessage() && StringUtils.userVisibleCharacterCount(reply) < this.sdkConfigurationDM.getMinimumConversationDescriptionLength()) {
            this.getConversationalRenderer().showReplyValidationFailedError(1);
            return;
        }
        if (!this.isInBetweenBotExecution) {
            super.sendTextMessage(reply);
            return;
        }
        MessageDM lastMessage = this.getConversationalMediator().getRenderedBotMessage();
        if (lastMessage == null || !(lastMessage instanceof AdminMessageWithTextInputDM)) {
            super.sendTextMessage();
            return;
        }
        final AdminMessageWithTextInputDM adminMessageWithTextInputDM = (AdminMessageWithTextInputDM)lastMessage;
        TextInput textInput = adminMessageWithTextInputDM.input;
        boolean isValid = adminMessageWithTextInputDM.input.validate(reply);
        if (!isValid) {
            this.getConversationalRenderer().showReplyValidationFailedError(textInput.keyboard);
            return;
        }
        this.getConversationalRenderer().hideReplyValidationFailedError();
        this.disableUserInputOptions();
        this.clearReply();
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    ConversationalVM.this.viewableConversation.getActiveConversation().sendTextMessage(reply, adminMessageWithTextInputDM, false);
                }
                catch (RootAPIException e) {
                    ConversationalVM.this.showErrorForNoNetwork(e);
                    throw e;
                }
                ConversationalVM.this.showFakeTypingIndicator(true);
            }
        });
    }

    private void showErrorForNoNetwork(RootAPIException e) {
        if (e.exceptionType instanceof NetworkException && !this.platform.isOnline()) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    if (ConversationalVM.this.getConversationalRenderer() != null) {
                        ConversationalVM.this.getConversationalRenderer().showNetworkErrorFooter(1);
                    }
                }
            });
        }
    }

    @Override
    public void retryMessage(final MessageDM readableMessage) {
        if (!this.isNetworkAvailable) {
            return;
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationalVM.this.domain.runParallel(new F(){

                    @Override
                    public void f() {
                        ConversationalVM.this.viewableConversation.getActiveConversation().retryMessage(readableMessage);
                        ConversationalVM.this.showFakeTypingIndicator(ConversationalVM.this.isInBetweenBotExecution);
                    }
                });
            }
        });
    }

    @Override
    public void onSkipClick() {
        this.updateLastUserActivityTime();
        final MessageDM lastMessage = this.getConversationalMediator().getRenderedBotMessage();
        if (lastMessage instanceof AdminMessageWithTextInputDM) {
            this.clearUserReplyDraft();
            this.disableUserInputOptions();
            this.domain.runParallel(new F(){

                @Override
                public void f() {
                    AdminMessageWithTextInputDM adminMessageWithTextInputDM = (AdminMessageWithTextInputDM)lastMessage;
                    try {
                        ConversationalVM.this.viewableConversation.getActiveConversation().sendTextMessage(adminMessageWithTextInputDM.input.skipLabel, adminMessageWithTextInputDM, true);
                    }
                    catch (RootAPIException e) {
                        ConversationalVM.this.showErrorForNoNetwork(e);
                        throw e;
                    }
                    ConversationalVM.this.showFakeTypingIndicator(true);
                }
            });
        }
        this.getConversationalRenderer().hideSkipButton();
    }

    @Override
    public void addAll(Collection<? extends MessageDM> elements) {
        boolean hasBotSwitchedToAnotherBot = this.viewableConversation.getActiveConversation().hasBotSwitchedToAnotherBotInPollerResponse(elements);
        if (hasBotSwitchedToAnotherBot) {
            this.viewableConversation.getActiveConversation().updateMessagesClickOnBotSwitch(false);
        }
        List<MessageDM> processedBotMessages = this.evaluateBotMessages(elements);
        if (this.isInBetweenBotExecution) {
            ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
            if (!this.isUserReplyDraftClearedForBotChange && activeConversation.containsAtleastOneUserMessage()) {
                this.clearUserReplyDraft();
                this.isUserReplyDraftClearedForBotChange = true;
            }
        } else {
            this.isUserReplyDraftClearedForBotChange = false;
        }
        super.addAll((Collection<? extends MessageDM>)processedBotMessages);
    }

    @Override
    public void update(MessageDM element) {
        this.updateUserInputState();
        super.update(element);
    }

    ConversationalRenderer getConversationalRenderer() {
        return (ConversationalRenderer)this.renderer;
    }

    private ConversationalMediator getConversationalMediator() {
        return (ConversationalMediator)this.conversationMediator;
    }

    public void handleOptionSelected(final OptionInputMessageDM message, final OptionInput.Option selectedOption, final boolean isSkipped) {
        if (this.messageListVM == null) {
            return;
        }
        if (message.input.type == OptionInput.Type.PILL) {
            int optionsMessageIndex = this.messageListVM.getUiMessageDMs().indexOf(message);
            this.messageListVM.remove(Collections.singletonList(message));
            this.renderer.updateMessages(optionsMessageIndex - 1, 1);
        }
        this.updateLastUserActivityTime();
        if (message.input.type == OptionInput.Type.PILL) {
            this.disableUserInputOptions();
        } else if (message.input.type == OptionInput.Type.PICKER) {
            this.hideListPicker(true);
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                ConversationalVM.this.domain.runParallel(new F(){

                    @Override
                    public void f() {
                        try {
                            ConversationalVM.this.viewableConversation.getActiveConversation().sendOptionInputMessage(message, selectedOption, isSkipped);
                        }
                        catch (RootAPIException e) {
                            ConversationalVM.this.showErrorForNoNetwork(e);
                            throw e;
                        }
                        if (ConversationalVM.this.viewableConversation.getActiveConversation().isIssueInProgress()) {
                            ConversationalVM.this.showFakeTypingIndicator(true);
                        }
                    }
                });
            }
        });
    }

    private void hideListPicker(final boolean hideSmoothly) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationalVM.this.getConversationalRenderer() != null) {
                    ConversationalVM.this.getConversationalRenderer().hideListPicker(hideSmoothly);
                }
            }
        });
    }

    private void disableUserInputOptions() {
        if (this.renderer != null) {
            this.renderer.hideKeyboard();
        }
        this.attachImageButtonWidget.setVisible(false);
        this.disableUserTextInput();
    }

    private List<MessageDM> evaluateBotMessages(Collection<? extends MessageDM> messageDMs) {
        ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
        boolean isBotExecutingOldState = this.isInBetweenBotExecution;
        List<MessageDM> processedBotMessages = this.processMessagesForBots(messageDMs, this.isInBetweenBotExecution);
        if (!activeConversation.isInPreIssueMode()) {
            if (isBotExecutingOldState && !this.isInBetweenBotExecution) {
                activeConversation.updateMessagesClickOnBotSwitch(activeConversation.shouldEnableMessagesClick());
                this.removeOptionsMessageFromUI();
                this.replyBoxWidget.setVisible(true);
                this.domain.runOnUI(new F(){

                    @Override
                    public void f() {
                        ConversationalVM.this.resetDefaultMenuItemsVisibility();
                        if (ConversationalVM.this.renderer != null) {
                            ConversationalVM.this.getConversationalRenderer().hideReplyValidationFailedError();
                        }
                    }
                });
            } else if (this.isInBetweenBotExecution && !isBotExecutingOldState) {
                activeConversation.updateMessagesClickOnBotSwitch(false);
            }
        }
        this.updateUserInputState();
        return processedBotMessages;
    }

    private void disableUserTextInput() {
        this.replyBoxWidget.setVisible(false);
    }

    private void updateUserInputState() {
        boolean shouldShowFakeTAI;
        IssueState state = this.viewableConversation.getActiveConversation().state;
        if (state == IssueState.REJECTED) {
            shouldShowFakeTAI = false;
            this.disableUserInputOptions();
        } else if (state == IssueState.RESOLUTION_REQUESTED || state == IssueState.RESOLUTION_ACCEPTED || state == IssueState.COMPLETED_ISSUE_CREATED) {
            shouldShowFakeTAI = false;
        } else if (this.isInBetweenBotExecution) {
            this.attachImageButtonWidget.setVisible(false);
            if (this.awaitingUserInputForBotStep) {
                shouldShowFakeTAI = false;
            } else {
                this.disableUserInputOptions();
                shouldShowFakeTAI = true;
                if (this.messageListVM != null) {
                    MessageDM lastMessageDM;
                    ConversationDM activeConversation = this.viewableConversation.getActiveConversation();
                    int messagesCount = activeConversation.messageDMs.size();
                    if (messagesCount > 0 && ((lastMessageDM = (MessageDM)activeConversation.messageDMs.get(messagesCount - 1)) instanceof UserResponseMessageForTextInputDM || lastMessageDM instanceof UserResponseMessageForOptionInput)) {
                        UserMessageDM userMessageDM = (UserMessageDM)lastMessageDM;
                        shouldShowFakeTAI = userMessageDM.getState() == UserMessageState.SENT;
                    }
                }
            }
        } else if (this.viewableConversation.getActiveConversation().isInPreIssueMode()) {
            this.disableUserInputOptions();
            shouldShowFakeTAI = true;
        } else {
            shouldShowFakeTAI = false;
        }
        this.showFakeTypingIndicator(shouldShowFakeTAI);
    }

    public void onNetworkAvailable() {
        this.isNetworkAvailable = true;
        if (StringUtils.isEmpty(this.viewableConversation.getActiveConversation().serverId) && StringUtils.isEmpty(this.viewableConversation.getActiveConversation().preConversationServerId)) {
            this.createPreIssue();
        } else {
            this.updateUserInputState();
        }
        this.getConversationalRenderer().hideNetworkErrorFooter();
    }

    public void onNetworkUnAvailable() {
        boolean notWaitingForUserInputForBot;
        this.isNetworkAvailable = false;
        this.showFakeTypingIndicator(false);
        boolean shouldShowForPreIssue = this.viewableConversation.getActiveConversation().isInPreIssueMode() && (StringUtils.isEmpty(this.viewableConversation.getActiveConversation().preConversationServerId) || !this.awaitingUserInputForBotStep);
        boolean bl = notWaitingForUserInputForBot = this.isInBetweenBotExecution && !this.awaitingUserInputForBotStep;
        if (shouldShowForPreIssue || notWaitingForUserInputForBot) {
            this.getConversationalRenderer().showNetworkErrorFooter(1);
        }
    }

    @Override
    public void onIssueStatusChange(IssueState newStatus) {
        if (!this.viewableConversation.getActiveConversation().isInPreIssueMode()) {
            super.onIssueStatusChange(newStatus);
            if (this.isInBetweenBotExecution) {
                this.attachImageButtonWidget.setVisible(false);
            }
            return;
        }
        switch (newStatus) {
            case RESOLUTION_ACCEPTED: {
                this.awaitingUserInputForBotStep = false;
                this.conversationMediator.showStartNewConversation(ConversationFooterState.START_NEW_CONVERSATION);
                this.updateUIOnNewMessageReceived();
                break;
            }
            case REJECTED: {
                this.awaitingUserInputForBotStep = false;
                this.removeOptionsMessageFromUI();
                this.handleConversationRejectedState();
                this.updateUIOnNewMessageReceived();
            }
        }
        this.updateUserInputState();
    }

    @Override
    public void onCreateConversationSuccess(long conversationLocalId) {
        this.handlePreIssueCreationSuccess();
    }

    @Override
    public void handlePreIssueCreationSuccess() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ConversationalVM.this.renderer == null) {
                    return;
                }
                ConversationalVM.this.conversationInboxDM.getConversationInboxPoller().startChatPoller();
                ConversationalVM.this.initMessagesList();
                ConversationalVM.this.renderer.notifyRefreshList();
                if (!ConversationalVM.this.isInBetweenBotExecution) {
                    ConversationalVM.this.showFakeTypingIndicator(true);
                }
                ConversationalVM.this.getConversationalRenderer().hideNetworkErrorFooter();
            }
        });
    }

    @Override
    public void onCreateConversationFailure(Exception e) {
        HSLogger.e(TAG, "Error filing a pre-issue", e);
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                ConversationalVM.this.showFakeTypingIndicator(false);
                if (ConversationalVM.this.getConversationalRenderer() != null) {
                    int errorCode = ConversationalVM.this.isNetworkAvailable ? 0 : 1;
                    ConversationalVM.this.getConversationalRenderer().showNetworkErrorFooter(errorCode);
                }
            }
        });
    }

    public void handleAdminSuggestedQuestionRead(MessageDM messageDM, final String questionServerId, final String questionPublishId) {
        if (!StringUtils.isEmpty(questionPublishId)) {
            final Long conversationLocalId = messageDM.conversationLocalId;
            final String messageServerId = messageDM.serverId;
            this.domain.runParallel(new F(){

                @Override
                public void f() {
                    List<ConversationDM> conversationDMs = ConversationalVM.this.viewableConversation.getAllConversations();
                    ConversationDM correspondingConversationDM = null;
                    for (ConversationDM conversationDM : conversationDMs) {
                        if (!conversationDM.localId.equals(conversationLocalId)) continue;
                        correspondingConversationDM = conversationDM;
                        break;
                    }
                    if (correspondingConversationDM != null) {
                        correspondingConversationDM.handleAdminSuggestedQuestionRead(messageServerId, questionServerId, questionPublishId);
                    }
                }
            });
        }
    }

    @Override
    public void onNewConversationButtonClicked() {
        super.onNewConversationButtonClicked();
        if (this.showConversationHistory) {
            this.conversationMediator.hideAllFooterWidgets();
            ConversationDM nextConversationToOpen = this.conversationInboxDM.getOpenConversationWithMessages();
            if (nextConversationToOpen == null) {
                nextConversationToOpen = this.conversationInboxDM.createLocalPreIssueConversation();
            }
            this.viewableConversation.onNewConversationStarted(nextConversationToOpen);
            this.refreshVM();
            this.renderMenuItems();
            this.initMessagesList();
            this.renderer.notifyRefreshList();
        } else {
            this.renderer.openFreshConversationScreen();
        }
    }

    ValuePair<MessageDM, OptionInputMessageDM> splitOptionsBotMessage(FAQListMessageWithOptionInputDM message) {
        if (message == null) {
            return null;
        }
        FAQListMessageDM adminMessage = new FAQListMessageDM(message);
        OptionInputMessageDM optionInputMessageDM = new OptionInputMessageDM(message);
        optionInputMessageDM.setDependencies(this.domain, this.platform);
        adminMessage.setDependencies(this.domain, this.platform);
        return new ValuePair<MessageDM, OptionInputMessageDM>(adminMessage, optionInputMessageDM);
    }

    ValuePair<MessageDM, OptionInputMessageDM> splitOptionsBotMessage(AdminMessageWithOptionInputDM message) {
        if (message == null) {
            return null;
        }
        AdminMessageDM adminMessage = new AdminMessageDM(message);
        OptionInputMessageDM optionInputMessageDM = new OptionInputMessageDM(message);
        optionInputMessageDM.setDependencies(this.domain, this.platform);
        adminMessage.setDependencies(this.domain, this.platform);
        return new ValuePair<MessageDM, OptionInputMessageDM>(adminMessage, optionInputMessageDM);
    }

    private void incrementCreatedAt(MessageDM messageDMToIncrement, MessageDM incrementFromMessageDM) {
        Date newDate = new Date(incrementFromMessageDM.getEpochCreatedAtTime() + 1L);
        String createdAt = HSDateFormatSpec.STORAGE_TIME_FORMAT.format(newDate);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        messageDMToIncrement.setCreatedAt(createdAt);
        messageDMToIncrement.setEpochCreatedAtTime(epochCreatedAtTime);
    }

    @Override
    public void onUIMessageListUpdated() {
        if (this.conversationMediator != null) {
            this.conversationMediator.renderReplyBoxWidget();
        }
    }

    @Override
    public void updateListPickerOptions(List<OptionUIModel> optionUIModels) {
        this.getConversationalRenderer().updateListPickerOptions(optionUIModels);
    }

    @Override
    public void handleOptionSelectedForPicker(OptionInputMessageDM messageDM, OptionInput.Option selectedOption, boolean isSkipped) {
        this.listPickerVM = null;
        this.handleOptionSelected(messageDM, selectedOption, isSkipped);
    }

    @Override
    public void showEmptyListPickerView() {
        this.getConversationalRenderer().showEmptyListPickerView();
    }

    @Override
    public void showListPicker(final OptionInputMessageDM optionInputMessageDM) {
        this.listPickerVM = new ListPickerVM(this.domain, optionInputMessageDM, this);
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                ConversationalVM.this.getConversationalRenderer().showListPicker(ConversationalVM.this.listPickerVM.getAllOptions(), optionInputMessageDM.input.inputLabel, optionInputMessageDM.input.required, optionInputMessageDM.input.skipLabel);
            }
        });
    }

    public void onListPickerSearchQueryChange(String query) {
        if (this.listPickerVM != null) {
            this.listPickerVM.onListPickerSearchQueryChange(query);
        }
    }

    public void handleOptionSelectedForPicker(OptionUIModel optionUIModel, boolean isSkipped) {
        if (this.listPickerVM != null) {
            this.listPickerVM.handleOptionSelectedForPicker(optionUIModel, isSkipped);
        }
    }

    @Override
    public void showPickerClearButton() {
        this.getConversationalRenderer().showPickerClearButton();
    }

    @Override
    public void hidePickerClearButton() {
        this.getConversationalRenderer().hidePickerClearButton();
    }
}

