/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.viewmodel.HSRange;
import com.helpshift.conversation.viewmodel.ListPickerVMCallback;
import com.helpshift.conversation.viewmodel.OptionUIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ListPickerVM {
    private Domain domain;
    private static final int MIN_CHAR_FOR_SEARCH = 2;
    private final OptionInputMessageDM messageDM;
    private final ListPickerVMCallback listPickerVMCallback;
    private static final Object lock = new Object();

    ListPickerVM(Domain domain, OptionInputMessageDM messageDM, ListPickerVMCallback listPickerVMCallback) {
        this.domain = domain;
        this.messageDM = messageDM;
        this.listPickerVMCallback = listPickerVMCallback;
    }

    List<OptionUIModel> getAllOptions() {
        return this.convertToOptionUIModels(this.messageDM.input.options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onListPickerSearchQueryChange(String query) {
        if (StringUtils.isEmpty(query)) {
            this.notifyListPickerOptions(this.getAllOptions());
            this.notifyHideClearButton();
            return;
        }
        this.notifyShowClearButton();
        String trimmedQuery = query.trim();
        if (trimmedQuery.length() < 2) {
            this.notifyListPickerOptions(this.getAllOptions());
            return;
        }
        String[] splitSearchTokens = trimmedQuery.split("\\b");
        final ArrayList<String> searchQueryTokens = new ArrayList<String>();
        for (String token : splitSearchTokens) {
            String trimmedToken = token.trim().toLowerCase();
            if (trimmedToken.length() < 2) continue;
            searchQueryTokens.add(trimmedToken);
        }
        if (searchQueryTokens.size() == 0) {
            this.notifyListPickerOptions(this.getAllOptions());
            return;
        }
        Object object = lock;
        synchronized (object) {
            this.domain.runParallel(new F(){

                @Override
                public void f() {
                    ArrayList<OptionFilter> optionFilters = new ArrayList<OptionFilter>(Arrays.asList(new SentencePrefixOptionFilter(), new WordPrefixOptionFilter(), new WordSubStringFilter()));
                    CompositeOptionFilter searchFilter = new CompositeOptionFilter(optionFilters);
                    List<OptionInput.Option> filteredOptions = searchFilter.filter(((ListPickerVM)ListPickerVM.this).messageDM.input.options, searchQueryTokens);
                    if (filteredOptions.size() == 0) {
                        ListPickerVM.this.notifyShowEmptyListPickerView();
                        return;
                    }
                    ArrayList<OptionUIModel> searchResult = new ArrayList<OptionUIModel>();
                    for (OptionInput.Option option : filteredOptions) {
                        searchResult.add(ListPickerVM.this.convertToOptionUIModel(option, searchQueryTokens));
                    }
                    ListPickerVM.this.notifyListPickerOptions(searchResult);
                }
            });
        }
    }

    private void notifyShowClearButton() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ListPickerVM.this.listPickerVMCallback != null) {
                    ListPickerVM.this.listPickerVMCallback.showPickerClearButton();
                }
            }
        });
    }

    private void notifyHideClearButton() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ListPickerVM.this.listPickerVMCallback != null) {
                    ListPickerVM.this.listPickerVMCallback.hidePickerClearButton();
                }
            }
        });
    }

    private void notifyShowEmptyListPickerView() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ListPickerVM.this.listPickerVMCallback != null) {
                    ListPickerVM.this.listPickerVMCallback.showEmptyListPickerView();
                }
            }
        });
    }

    private void notifyListPickerOptions(final List<OptionUIModel> optionUIModels) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (ListPickerVM.this.listPickerVMCallback != null) {
                    ListPickerVM.this.listPickerVMCallback.updateListPickerOptions(optionUIModels);
                }
            }
        });
    }

    private List<OptionUIModel> convertToOptionUIModels(List<OptionInput.Option> options, List<String> searchQueryTokens) {
        ArrayList<OptionUIModel> optionUIModels = new ArrayList<OptionUIModel>();
        for (OptionInput.Option option : options) {
            optionUIModels.add(this.convertToOptionUIModel(option, searchQueryTokens));
        }
        return optionUIModels;
    }

    private OptionUIModel convertToOptionUIModel(OptionInput.Option option, List<String> searchQueryTokens) {
        List<HSRange> titleHighlightInfo = null;
        if (!ListUtils.isEmpty(searchQueryTokens)) {
            titleHighlightInfo = this.getHighlightInfo(option.title, searchQueryTokens);
        }
        return new OptionUIModel(option, titleHighlightInfo);
    }

    void handleOptionSelectedForPicker(OptionUIModel selectedOptionUIModel, boolean isSkipped) {
        OptionInput.Option selectedOption = isSkipped ? null : selectedOptionUIModel.option;
        this.listPickerVMCallback.handleOptionSelectedForPicker(this.messageDM, selectedOption, isSkipped);
    }

    List<HSRange> getHighlightInfo(String data, List<String> searchTokens) {
        if (StringUtils.isEmpty(data) || ListUtils.isEmpty(searchTokens)) {
            return null;
        }
        data = data.toLowerCase();
        ArrayList<HSRange> result = new ArrayList<HSRange>();
        HashSet<Integer> indexIncluded = new HashSet<Integer>();
        for (String searchToken : searchTokens) {
            if (StringUtils.isEmpty(searchToken)) continue;
            searchToken = searchToken.toLowerCase();
            String regex = "\\b" + searchToken;
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(data);
            while (matcher.find()) {
                int startIndex = matcher.start();
                if (indexIncluded.contains(startIndex)) continue;
                int length = matcher.end() - startIndex;
                result.add(new HSRange(startIndex, length));
                indexIncluded.add(startIndex);
            }
        }
        if (ListUtils.isEmpty(result)) {
            return null;
        }
        return result;
    }

    class WordSubStringFilter
    extends BaseOptionFilter {
        WordSubStringFilter() {
        }

        @Override
        String getRegex(String token) {
            return "\\B" + token;
        }
    }

    class WordPrefixOptionFilter
    extends BaseOptionFilter {
        WordPrefixOptionFilter() {
        }

        @Override
        String getRegex(String token) {
            return "\\b" + token;
        }
    }

    class SentencePrefixOptionFilter
    extends BaseOptionFilter {
        SentencePrefixOptionFilter() {
        }

        @Override
        String getRegex(String token) {
            return "^" + token;
        }
    }

    private abstract class BaseOptionFilter
    implements OptionFilter {
        private BaseOptionFilter() {
        }

        @Override
        public final List<OptionInput.Option> filter(List<OptionInput.Option> optionList, List<String> searchQueryTokens) {
            LinkedHashSet<OptionInput.Option> searchResult = new LinkedHashSet<OptionInput.Option>();
            for (String searchQueryToken : searchQueryTokens) {
                String regexForSentencePrefix = this.getRegex(searchQueryToken);
                List<OptionInput.Option> options = this.filterResult(optionList, regexForSentencePrefix);
                searchResult.addAll(options);
            }
            return new ArrayList<OptionInput.Option>(searchResult);
        }

        private List<OptionInput.Option> filterResult(List<OptionInput.Option> inputList, String regex) {
            ArrayList<OptionInput.Option> result = new ArrayList<OptionInput.Option>();
            Pattern pattern = Pattern.compile(regex);
            for (OptionInput.Option option : inputList) {
                Matcher matcher = pattern.matcher(option.title.toLowerCase());
                if (!matcher.find()) continue;
                result.add(option);
            }
            return result;
        }

        abstract String getRegex(String var1);
    }

    class CompositeOptionFilter
    implements OptionFilter {
        private List<OptionFilter> optionFilters;

        CompositeOptionFilter(List<OptionFilter> optionFilters) {
            this.optionFilters = optionFilters;
        }

        @Override
        public List<OptionInput.Option> filter(List<OptionInput.Option> input, List<String> tokens) {
            LinkedHashSet<OptionInput.Option> searchResult = new LinkedHashSet<OptionInput.Option>();
            for (OptionFilter optionFilter : this.optionFilters) {
                searchResult.addAll(optionFilter.filter(input, tokens));
            }
            return new ArrayList<OptionInput.Option>(searchResult);
        }
    }

    static interface OptionFilter {
        public List<OptionInput.Option> filter(List<OptionInput.Option> var1, List<String> var2);
    }
}

