/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.activeconversation.UIConversation;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemDateMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemDividerMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemPublishIdMessageDM;
import com.helpshift.conversation.activeconversation.message.SystemRedactedConversationMessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.viewmodel.MessageListVMCallback;
import com.helpshift.util.ValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageListVM {
    protected final Platform platform;
    protected final Domain domain;
    MessageListVMCallback messageListVMCallback;
    List<MessageDM> uiMessageDMs;
    private Map<Long, UIConversation> uiConversationLocalIdMap = new ConcurrentHashMap<Long, UIConversation>();
    private long timeZoneOffSet = 0L;

    public MessageListVM(Platform platform, Domain domain) {
        this.platform = platform;
        this.domain = domain;
        this.timeZoneOffSet = this.platform.getDevice().getTimeZoneOffSet();
    }

    public void initializeMessageList(List<UIConversation> uiConversations, List<MessageDM> messageDMList, boolean hasMoreMessages, MessageListVMCallback messageListVMCallback) {
        this.updateUIConversationOrder(uiConversations);
        List<MessageDM> messageDMs = this.processAddedMessages(messageDMList);
        messageDMs = this.groupConversationRedactedMessages(messageDMs);
        this.uiMessageDMs = this.insertSystemMessageDMs(messageDMs, null, hasMoreMessages);
        this.checkAndUpdateGroupByTime(this.uiMessageDMs, 0, this.uiMessageDMs.size() - 1);
        this.messageListVMCallback = messageListVMCallback;
    }

    private synchronized List<MessageDM> groupConversationRedactedMessages(List<MessageDM> messageDMList) {
        ArrayList<MessageDM> result = new ArrayList<MessageDM>();
        if (ListUtils.isEmpty(messageDMList)) {
            return result;
        }
        int continuousRedactionConversationCount = 0;
        SystemRedactedConversationMessageDM lastRedactedConversationMessageDM = null;
        for (MessageDM messageDM : messageDMList) {
            if (messageDM instanceof SystemRedactedConversationMessageDM) {
                ++continuousRedactionConversationCount;
                lastRedactedConversationMessageDM = (SystemRedactedConversationMessageDM)messageDM;
                continue;
            }
            if (lastRedactedConversationMessageDM != null) {
                lastRedactedConversationMessageDM.contiguousRedactedConversationsCount = continuousRedactionConversationCount;
                result.add(lastRedactedConversationMessageDM);
                lastRedactedConversationMessageDM = null;
                continuousRedactionConversationCount = 0;
            }
            result.add(messageDM);
        }
        if (lastRedactedConversationMessageDM != null) {
            lastRedactedConversationMessageDM.contiguousRedactedConversationsCount = continuousRedactionConversationCount;
            result.add(lastRedactedConversationMessageDM);
        }
        return result;
    }

    private synchronized List<MessageDM> filterUIMessages(Collection<? extends MessageDM> messageDMList) {
        ArrayList<MessageDM> uiMessageDMs = new ArrayList<MessageDM>();
        if (messageDMList == null) {
            return uiMessageDMs;
        }
        for (MessageDM messageDM : messageDMList) {
            if (!messageDM.isUISupportedMessage()) continue;
            uiMessageDMs.add(messageDM);
        }
        return uiMessageDMs;
    }

    private boolean isDifferentConversationMessages(MessageDM firstMessage, MessageDM secondMessage) {
        if (firstMessage == null || secondMessage == null) {
            return false;
        }
        return !firstMessage.conversationLocalId.equals(secondMessage.conversationLocalId);
    }

    private IssueState getIssueStateForMessage(MessageDM message) {
        if (message == null) {
            return IssueState.UNKNOWN;
        }
        UIConversation uiConversation = this.getUIConversation(message.conversationLocalId);
        if (uiConversation == null) {
            return IssueState.UNKNOWN;
        }
        return uiConversation.issueState;
    }

    private synchronized List<MessageDM> insertSystemMessageDMs(List<MessageDM> messageDMList, MessageDM lastMessage, boolean hasOlderMessage) {
        ArrayList<MessageDM> messagesWithSystemMessageDM = new ArrayList<MessageDM>();
        boolean isShowConversationInfoEnabled = this.domain.getSDKConfigurationDM().getBoolean("showConversationInfoScreen");
        boolean isFirstMessageInList = !hasOlderMessage && lastMessage == null;
        for (MessageDM messageDM : messageDMList) {
            List<SystemMessageDM> systemMessageDMList = this.buildSystemMessages(lastMessage, messageDM, isFirstMessageInList, isShowConversationInfoEnabled);
            messagesWithSystemMessageDM.addAll(systemMessageDMList);
            messagesWithSystemMessageDM.add(messageDM);
            lastMessage = messageDM;
            isFirstMessageInList = false;
        }
        return messagesWithSystemMessageDM;
    }

    private SystemDividerMessageDM buildSystemDividerMessages(MessageDM previousMessage, MessageDM nextMessage) {
        if (previousMessage == null || nextMessage == null) {
            return null;
        }
        boolean isDifferentConversationMessages = this.isDifferentConversationMessages(previousMessage, nextMessage);
        if (!isDifferentConversationMessages) {
            return null;
        }
        UIConversation uiConversation = this.getUIConversation(previousMessage.conversationLocalId);
        boolean isConversationRedacted = uiConversation != null && uiConversation.isRedacted;
        boolean showDividerText = !isConversationRedacted && this.getIssueStateForMessage(previousMessage) == IssueState.REJECTED;
        SystemDividerMessageDM systemDividerMessageDM = this.generateConversationDividerMessage(this.getDateFromMessageDM(nextMessage), showDividerText);
        systemDividerMessageDM.conversationLocalId = nextMessage.conversationLocalId;
        return systemDividerMessageDM;
    }

    private List<SystemMessageDM> buildSystemMessages(MessageDM previousMessage, MessageDM currentMessage, boolean isFirstMessageInList, boolean isShowConversationInfoEnabled) {
        boolean isConversationRedacted;
        if (currentMessage == null) {
            return new ArrayList<SystemMessageDM>();
        }
        ArrayList<SystemMessageDM> systemMessageDMList = new ArrayList<SystemMessageDM>();
        SystemDividerMessageDM systemDividerMessageDM = this.buildSystemDividerMessages(previousMessage, currentMessage);
        if (systemDividerMessageDM != null) {
            systemMessageDMList.add(systemDividerMessageDM);
        }
        boolean isDifferentConversationMessages = this.isDifferentConversationMessages(previousMessage, currentMessage);
        Date currentMessageDate = this.getDateFromMessageDM(currentMessage);
        UIConversation uiConversation = this.getUIConversation(currentMessage.conversationLocalId);
        boolean bl = isConversationRedacted = uiConversation != null && uiConversation.isRedacted;
        if (!isConversationRedacted) {
            if (isDifferentConversationMessages || isFirstMessageInList) {
                if (uiConversation != null) {
                    boolean shouldShowPublishId;
                    boolean bl2 = shouldShowPublishId = isShowConversationInfoEnabled && !uiConversation.isInPreIssueMode && !StringUtils.isEmpty(uiConversation.publishId);
                    if (shouldShowPublishId) {
                        SystemPublishIdMessageDM systemPublishIdMessageDM = this.generateSystemPublishIdMessageDM(uiConversation.publishId, currentMessageDate, isFirstMessageInList, currentMessage.conversationLocalId);
                        systemPublishIdMessageDM.conversationLocalId = currentMessage.conversationLocalId;
                        systemMessageDMList.add(systemPublishIdMessageDM);
                        isFirstMessageInList = false;
                    }
                }
                SystemDateMessageDM systemDateMessageDM = this.generateSystemMessageDM(currentMessageDate, isFirstMessageInList, currentMessage.conversationLocalId);
                systemDateMessageDM.conversationLocalId = currentMessage.conversationLocalId;
                systemMessageDMList.add(systemDateMessageDM);
            } else if (this.isMessagesDayDifferent(previousMessage, currentMessage) && !this.isSystemDateMessage(currentMessage)) {
                SystemDateMessageDM systemDateMessageDM = this.generateSystemMessageDM(currentMessageDate, isFirstMessageInList, currentMessage.conversationLocalId);
                systemDateMessageDM.conversationLocalId = currentMessage.conversationLocalId;
                systemMessageDMList.add(systemDateMessageDM);
            }
        }
        return systemMessageDMList;
    }

    private SystemDateMessageDM generateSystemMessageDM(Date currentMessageDate, boolean isFirstMessageInList, Long conversationLocalId) {
        Date systemMessageDate = new Date(currentMessageDate.getTime());
        systemMessageDate.setHours(0);
        systemMessageDate.setMinutes(0);
        systemMessageDate.setSeconds(0);
        String systemMessageCreatedAt = HSDateFormatSpec.STORAGE_TIME_FORMAT.format(systemMessageDate);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(systemMessageCreatedAt);
        SystemDateMessageDM systemDateMessageDM = new SystemDateMessageDM(systemMessageCreatedAt, epochCreatedAtTime, isFirstMessageInList);
        systemDateMessageDM.setDependencies(this.domain, this.platform);
        systemDateMessageDM.conversationLocalId = conversationLocalId;
        return systemDateMessageDM;
    }

    private SystemDividerMessageDM generateConversationDividerMessage(Date currentMessageDate, boolean showDividerText) {
        Date systemMessageDate = new Date(currentMessageDate.getTime());
        systemMessageDate.setHours(0);
        systemMessageDate.setMinutes(0);
        systemMessageDate.setSeconds(0);
        String createdAt = HSDateFormatSpec.STORAGE_TIME_FORMAT.format(systemMessageDate);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        SystemDividerMessageDM systemDividerMessageDM = new SystemDividerMessageDM(createdAt, epochCreatedAtTime, showDividerText);
        systemDividerMessageDM.setDependencies(this.domain, this.platform);
        return systemDividerMessageDM;
    }

    private SystemPublishIdMessageDM generateSystemPublishIdMessageDM(String publishId, Date currentMessageDate, boolean isFirstMessageInList, Long conversationLocalId) {
        Date systemMessageDate = new Date(currentMessageDate.getTime());
        systemMessageDate.setHours(0);
        systemMessageDate.setMinutes(0);
        systemMessageDate.setSeconds(0);
        String createdAt = HSDateFormatSpec.STORAGE_TIME_FORMAT.format(systemMessageDate);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        SystemPublishIdMessageDM systemPublishIdMessageDM = new SystemPublishIdMessageDM(publishId, createdAt, epochCreatedAtTime, isFirstMessageInList);
        systemPublishIdMessageDM.setDependencies(this.domain, this.platform);
        systemPublishIdMessageDM.conversationLocalId = conversationLocalId;
        return systemPublishIdMessageDM;
    }

    private Date getDateFromMessageDM(MessageDM messageDM) {
        return new Date(messageDM.getEpochCreatedAtTime());
    }

    private boolean isSystemMessage(MessageDM messageDM) {
        return messageDM instanceof SystemMessageDM;
    }

    private boolean isSystemDateMessage(MessageDM messageDM) {
        return messageDM instanceof SystemDateMessageDM;
    }

    private boolean isMessagesDayDifferent(MessageDM firstMessage, MessageDM secondMessage) {
        if (firstMessage == null || secondMessage == null) {
            return false;
        }
        return this.isDayDifferent(firstMessage.getEpochCreatedAtTime(), secondMessage.getEpochCreatedAtTime());
    }

    private boolean isDayDifferent(long firstEpochTime, long secondEpochTime) {
        long oneDayOffSet = 86400000L;
        long firstNumberOfDays = (firstEpochTime += this.timeZoneOffSet) / oneDayOffSet;
        long secondNumberOfDays = (secondEpochTime += this.timeZoneOffSet) / oneDayOffSet;
        return firstNumberOfDays != secondNumberOfDays;
    }

    private boolean isMinuteDifferent(long firstEpochTime, long secondEpochTime) {
        long oneMinuteOffSet = 60000L;
        long firstNumberOfMinute = (firstEpochTime += this.timeZoneOffSet) / oneMinuteOffSet;
        long secondNumberOfMinute = (secondEpochTime += this.timeZoneOffSet) / oneMinuteOffSet;
        return firstNumberOfMinute != secondNumberOfMinute;
    }

    private Comparator<MessageDM> getSortMessagesComparator() {
        return new Comparator<MessageDM>(){

            @Override
            public int compare(MessageDM m1, MessageDM m2) {
                long m2Time;
                UIConversation firstConversation = MessageListVM.this.getUIConversation(m1.conversationLocalId);
                UIConversation secondConversation = MessageListVM.this.getUIConversation(m2.conversationLocalId);
                if (firstConversation == null || secondConversation == null) {
                    return 0;
                }
                Integer conversation1Index = firstConversation.index;
                Integer conversation2Index = secondConversation.index;
                if (conversation1Index < conversation2Index) {
                    return -1;
                }
                if (conversation1Index > conversation2Index) {
                    return 1;
                }
                long m1Time = m1.getEpochCreatedAtTime();
                if (m1Time > (m2Time = m2.getEpochCreatedAtTime())) {
                    return 1;
                }
                if (m1Time < m2Time) {
                    return -1;
                }
                return 0;
            }
        };
    }

    protected List<MessageDM> processAddedMessages(Collection<? extends MessageDM> elements) {
        List<MessageDM> newUISupportedMessages = this.filterUIMessages(elements);
        Collections.sort(newUISupportedMessages, this.getSortMessagesComparator());
        return newUISupportedMessages;
    }

    public void addMessages(Collection<? extends MessageDM> elements) {
        final List<MessageDM> newUISupportedMessages = this.processAddedMessages(elements);
        if (newUISupportedMessages.size() > 0) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    MessageDM lastMessage = MessageListVM.this.getItemAtPosition(MessageListVM.this.uiMessageDMs.size() - 1);
                    if (lastMessage == null || lastMessage.getEpochCreatedAtTime() <= ((MessageDM)newUISupportedMessages.get(0)).getEpochCreatedAtTime()) {
                        MessageListVM.this.appendUIMessages(newUISupportedMessages);
                    } else {
                        MessageListVM.this.insertUIMessages(newUISupportedMessages);
                    }
                    MessageListVM.this.notifyNewUIMessagesAdded(newUISupportedMessages);
                    MessageListVM.this.notifyUIMessageListUpdated();
                }
            });
        }
    }

    private void notifyNewUIMessagesAdded(List<MessageDM> newUISupportedMessages) {
        boolean containsAdminMessages = this.containsAdminMessages(newUISupportedMessages);
        if (this.messageListVMCallback != null) {
            if (containsAdminMessages) {
                this.messageListVMCallback.newAdminMessagesAdded();
            } else {
                this.messageListVMCallback.newUserMessagesAdded();
            }
        }
    }

    private void appendUIMessages(List<MessageDM> messageDMList) {
        int currentSize = this.uiMessageDMs.size();
        MessageDM lastMessage = this.getItemAtPosition(currentSize - 1);
        List<MessageDM> newMessageList = this.insertSystemMessageDMs(messageDMList, lastMessage, true);
        this.uiMessageDMs.addAll(newMessageList);
        ValuePair<Integer, Integer> updatedMessages = this.checkAndUpdateGroupByTime(this.uiMessageDMs, currentSize - 1, this.uiMessageDMs.size() - 1);
        if (this.messageListVMCallback != null) {
            int fromIndex;
            this.messageListVMCallback.appendMessages(currentSize, newMessageList.size());
            if (updatedMessages != null && (fromIndex = ((Integer)updatedMessages.first).intValue()) < currentSize) {
                this.messageListVMCallback.updateMessages(fromIndex, currentSize - fromIndex);
            }
        }
    }

    private void insertUIMessages(List<MessageDM> messageDMList) {
        for (MessageDM messageDM : messageDMList) {
            this.insertUIMessage(messageDM);
        }
        this.notifyMessageListVMRefreshAll();
    }

    void insertUIMessage(MessageDM messageDM) {
        int index = this.findBinaryIndexIntoUIList(messageDM);
        this.uiMessageDMs.add(index, messageDM);
        this.checkAndUpdateGroupByDate(index);
        this.checkAndUpdateGroupByTime(this.uiMessageDMs, index - 1, index + 1);
    }

    private boolean containsAdminMessages(List<MessageDM> messageDMList) {
        for (MessageDM messageDM : messageDMList) {
            if (!this.isAdminMessage(messageDM)) continue;
            return true;
        }
        return false;
    }

    public void insertOrUpdateMessage(final MessageDM messageDM) {
        if (messageDM == null || !messageDM.isUISupportedMessage()) {
            return;
        }
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (MessageListVM.this.uiMessageDMs.contains(messageDM)) {
                    MessageListVM.this.updateUIMessage(messageDM);
                } else {
                    MessageListVM.this.insertUIMessage(messageDM);
                    MessageListVM.this.notifyNewUIMessagesAdded(new ArrayList<MessageDM>(Collections.singletonList(messageDM)));
                    MessageListVM.this.notifyMessageListVMRefreshAll();
                }
                MessageListVM.this.notifyUIMessageListUpdated();
            }
        });
    }

    void updateUIMessage(MessageDM messageDM) {
        int index = this.uiMessageDMs.indexOf(messageDM);
        if (index == -1) {
            return;
        }
        if (this.isMessageAtCorrectPosition(index)) {
            boolean isSystemMessageInserted = this.checkAndUpdateGroupByDate(index);
            ValuePair<Integer, Integer> updateRange = this.checkAndUpdateGroupByTime(this.uiMessageDMs, index - 1, index + 1);
            if (isSystemMessageInserted) {
                this.notifyMessageListVMRefreshAll();
            } else {
                int fromIndex = index;
                int toIndex = index;
                if (updateRange != null) {
                    fromIndex = Math.min(fromIndex, (Integer)updateRange.first);
                    toIndex = Math.max(toIndex, (Integer)updateRange.second);
                }
                if (this.messageListVMCallback != null && fromIndex <= toIndex && toIndex < this.uiMessageDMs.size()) {
                    this.messageListVMCallback.updateMessages(fromIndex, toIndex - fromIndex + 1);
                }
            }
        } else {
            this.uiMessageDMs.remove(index);
            this.checkAndUpdateGroupByDate(index - 1);
            this.checkAndUpdateGroupByTime(this.uiMessageDMs, index - 1, index + 1);
            this.insertUIMessage(messageDM);
            this.notifyMessageListVMRefreshAll();
        }
    }

    void notifyMessageListVMRefreshAll() {
        if (this.messageListVMCallback != null) {
            this.messageListVMCallback.refreshAll();
        }
    }

    void notifyMessageListUpdate(ValuePair<Integer, Integer> updatedMessages) {
        if (updatedMessages == null) {
            return;
        }
        int startPosition = (Integer)updatedMessages.first;
        int size = (Integer)updatedMessages.second - startPosition + 1;
        if (this.messageListVMCallback != null && startPosition > 0 && size > 0 && (Integer)updatedMessages.second < this.uiMessageDMs.size()) {
            this.messageListVMCallback.updateMessages(startPosition, size);
        }
    }

    boolean isMessageAtCorrectPosition(int index) {
        MessageDM message = this.getItemAtPosition(index);
        if (message == null) {
            return true;
        }
        MessageDM lastMessage = this.getItemAtPosition(index - 1);
        if (lastMessage != null && message.getEpochCreatedAtTime() < lastMessage.getEpochCreatedAtTime()) {
            return false;
        }
        MessageDM nextMessage = this.getItemAtPosition(index + 1);
        return nextMessage == null || message.getEpochCreatedAtTime() <= nextMessage.getEpochCreatedAtTime();
    }

    private MessageDM getItemAtPosition(int index) {
        if (index < 0 || index >= this.uiMessageDMs.size()) {
            return null;
        }
        return this.uiMessageDMs.get(index);
    }

    private int findBinaryIndexIntoUIList(MessageDM messageDM) {
        int size = this.uiMessageDMs.size();
        if (size == 0) {
            return 0;
        }
        int index = this.findBinaryIndex(messageDM.getEpochCreatedAtTime(), 0, size - 1);
        if (index < 0) {
            index = 0;
        } else if (index > size) {
            index = size;
        }
        return index;
    }

    private int findBinaryIndex(long epochTime, int low, int high) {
        int mid = low + (high - low) / 2;
        if (low == mid) {
            long epochTimeAtLow = this.uiMessageDMs.get(low).getEpochCreatedAtTime();
            long epochTimeAtHigh = this.uiMessageDMs.get(high).getEpochCreatedAtTime();
            if (epochTime < epochTimeAtLow) {
                return low;
            }
            if (epochTime >= epochTimeAtHigh) {
                return high + 1;
            }
            return high;
        }
        long epochTimeAtMid = this.uiMessageDMs.get(mid).getEpochCreatedAtTime();
        if (epochTimeAtMid <= epochTime) {
            return this.findBinaryIndex(epochTime, mid, high);
        }
        return this.findBinaryIndex(epochTime, low, mid);
    }

    private boolean isUserMessage(MessageDM messageDM) {
        return !this.isAdminMessage(messageDM) && !this.isSystemMessage(messageDM);
    }

    private boolean isAdminMessage(MessageDM messageDM) {
        return messageDM.isAdminMessage;
    }

    private boolean isUserMessageSent(MessageDM messageDM) {
        if (messageDM == null) {
            return false;
        }
        if (messageDM.messageType == MessageType.USER_TEXT || messageDM.messageType == MessageType.USER_RESP_FOR_TEXT_INPUT || messageDM.messageType == MessageType.USER_RESP_FOR_OPTION_INPUT) {
            return ((UserMessageDM)messageDM).getState() == UserMessageState.SENT;
        }
        if (messageDM.messageType == MessageType.SCREENSHOT) {
            return ((ScreenshotMessageDM)messageDM).state == UserMessageState.SENT;
        }
        return false;
    }

    private boolean canGroupMessagesByTime(MessageDM firstMessageDM, MessageDM secondMessageDM) {
        if (firstMessageDM == null || secondMessageDM == null) {
            return false;
        }
        if (StringUtils.isEmpty(secondMessageDM.body)) {
            return false;
        }
        if (!(this.isUserMessage(firstMessageDM) && this.isUserMessage(secondMessageDM) || this.isAdminMessage(firstMessageDM) && this.isAdminMessage(secondMessageDM))) {
            return false;
        }
        if (this.isMinuteDifferent(firstMessageDM.getEpochCreatedAtTime(), secondMessageDM.getEpochCreatedAtTime())) {
            return false;
        }
        if (this.isUserMessage(firstMessageDM)) {
            return this.isUserMessageSent(firstMessageDM) && this.isUserMessageSent(secondMessageDM);
        }
        String firstMessageAuthorName = firstMessageDM.getDisplayedAuthorName();
        String secondMessageAuthorName = secondMessageDM.getDisplayedAuthorName();
        if (firstMessageAuthorName == null) {
            return secondMessageAuthorName == null;
        }
        return secondMessageAuthorName != null && firstMessageAuthorName.equals(secondMessageAuthorName);
    }

    private boolean updateMessageGroupViewState(MessageDM messageDM, boolean isGroupStartMessage, boolean isGroupEndMessage) {
        UIViewState uiViewState = messageDM.getUiViewState();
        UIViewState newViewState = isGroupStartMessage ? (isGroupEndMessage ? new UIViewState(true, false) : new UIViewState(false, this.isUserMessage(messageDM))) : (isGroupEndMessage ? new UIViewState(true, this.isAdminMessage(messageDM)) : new UIViewState(false, true));
        if (uiViewState.equals(newViewState)) {
            return false;
        }
        uiViewState.updateViewState(newViewState);
        return true;
    }

    boolean isGroupFirstMessageAtIndex(int index) {
        if (index < 0) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        MessageDM messageDM = this.uiMessageDMs.get(index);
        MessageDM lastMessageDM = this.uiMessageDMs.get(index - 1);
        return !this.canGroupMessagesByTime(lastMessageDM, messageDM);
    }

    synchronized ValuePair<Integer, Integer> checkAndUpdateGroupByTime(List<MessageDM> messageDMList, int fromIndex, int toIndex) {
        int uiMessageListSize = messageDMList.size();
        fromIndex = Math.max(fromIndex, 0);
        if ((toIndex = Math.min(toIndex, uiMessageListSize - 1)) < fromIndex) {
            return null;
        }
        int minIndex = -1;
        int maxIndex = -1;
        boolean isGroupFirstMessage = true;
        if (fromIndex > 0) {
            boolean canGroupMessage;
            boolean isFirstMessage;
            int lastMessageIndex = fromIndex - 1;
            MessageDM lastMessageDM = messageDMList.get(lastMessageIndex);
            if (this.updateMessageGroupViewState(lastMessageDM, isFirstMessage = this.isGroupFirstMessageAtIndex(lastMessageIndex), !(canGroupMessage = this.canGroupMessagesByTime(lastMessageDM, messageDMList.get(fromIndex))))) {
                minIndex = lastMessageIndex;
                maxIndex = lastMessageIndex;
            }
            isGroupFirstMessage = !canGroupMessage;
        }
        for (int index = fromIndex; index <= toIndex; ++index) {
            boolean isMessageUpdated;
            MessageDM currentMessageDM = messageDMList.get(index);
            if (index == uiMessageListSize - 1) {
                isMessageUpdated = this.updateMessageGroupViewState(currentMessageDM, isGroupFirstMessage, true);
            } else {
                MessageDM nextMessageDM = messageDMList.get(index + 1);
                if (this.canGroupMessagesByTime(currentMessageDM, nextMessageDM)) {
                    isMessageUpdated = this.updateMessageGroupViewState(currentMessageDM, isGroupFirstMessage, false);
                    isGroupFirstMessage = false;
                } else {
                    isMessageUpdated = this.updateMessageGroupViewState(currentMessageDM, isGroupFirstMessage, true);
                    isGroupFirstMessage = true;
                }
            }
            if (!isMessageUpdated) continue;
            if (minIndex == -1) {
                minIndex = index;
            }
            maxIndex = index;
        }
        ValuePair<Integer, Integer> result = null;
        if (minIndex != -1) {
            result = new ValuePair<Integer, Integer>(minIndex, maxIndex);
        }
        return result;
    }

    boolean checkAndUpdateGroupByDate(int index) {
        boolean result = false;
        MessageDM messageDM = this.getItemAtPosition(index);
        MessageDM nextMessageDM = this.getItemAtPosition(index + 1);
        if (this.isSystemDateMessage(messageDM) && (nextMessageDM == null || this.isSystemDateMessage(nextMessageDM))) {
            this.uiMessageDMs.remove(index);
            --index;
            result = true;
        }
        messageDM = this.getItemAtPosition(index);
        MessageDM lastMessageDM = this.getItemAtPosition(index - 1);
        if (lastMessageDM == null || messageDM == null || this.isSystemDateMessage(messageDM)) {
            return result;
        }
        if (this.isMessagesDayDifferent(lastMessageDM, messageDM)) {
            SystemDateMessageDM systemDateMessageDM = this.generateSystemMessageDM(new Date(messageDM.getEpochCreatedAtTime()), messageDM.getEpochCreatedAtTime() == -1L, messageDM.conversationLocalId);
            this.uiMessageDMs.add(index, systemDateMessageDM);
            result = true;
        }
        return result;
    }

    public void unregisterMessageListVMCallback() {
        this.messageListVMCallback = null;
    }

    public List<MessageDM> getUiMessageDMs() {
        return this.uiMessageDMs;
    }

    public void prependMessages(List<MessageDM> messageDMList, boolean hasOlderMessages) {
        if (ListUtils.isEmpty(messageDMList)) {
            if (!hasOlderMessages) {
                this.checkAndPrependSystemMessagesBeforeFirstMessage();
            }
            return;
        }
        messageDMList = this.filterUIMessages(messageDMList);
        Collections.sort(messageDMList, this.getSortMessagesComparator());
        messageDMList = this.groupConversationRedactedMessages(messageDMList);
        messageDMList = this.insertSystemMessageDMs(messageDMList, null, hasOlderMessages);
        this.checkAndUpdateGroupByTime(messageDMList, 0, messageDMList.size() - 1);
        this.prependMessagesInternal(messageDMList);
    }

    void checkAndPrependSystemMessagesBeforeFirstMessage() {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                int size = MessageListVM.this.uiMessageDMs.size();
                if (size == 0) {
                    return;
                }
                MessageDM firstMessageInUIList = MessageListVM.this.uiMessageDMs.get(0);
                if (MessageListVM.this.isSystemMessage(firstMessageInUIList)) {
                    return;
                }
                boolean isShowConversationInfoEnabled = MessageListVM.this.domain.getSDKConfigurationDM().getBoolean("showConversationInfoScreen");
                List systemMessageList = MessageListVM.this.buildSystemMessages(null, firstMessageInUIList, true, isShowConversationInfoEnabled);
                if (ListUtils.isEmpty(systemMessageList)) {
                    return;
                }
                MessageListVM.this.uiMessageDMs.addAll(0, systemMessageList);
                if (MessageListVM.this.messageListVMCallback != null) {
                    MessageListVM.this.messageListVMCallback.appendMessages(0, systemMessageList.size());
                }
            }
        });
    }

    void prependMessagesInternal(final List<MessageDM> newMessageList) {
        if (ListUtils.isEmpty(newMessageList)) {
            return;
        }
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                MessageDM lastMessageOfInputList = (MessageDM)newMessageList.get(newMessageList.size() - 1);
                MessageDM firstMessageOfUIList = null;
                if (!ListUtils.isEmpty(MessageListVM.this.uiMessageDMs)) {
                    firstMessageOfUIList = MessageListVM.this.uiMessageDMs.get(0);
                }
                boolean isShowConversationInfoEnabled = MessageListVM.this.domain.getSDKConfigurationDM().getBoolean("showConversationInfoScreen");
                List systemMessages = MessageListVM.this.buildSystemMessages(lastMessageOfInputList, firstMessageOfUIList, false, isShowConversationInfoEnabled);
                newMessageList.addAll(systemMessages);
                int size = newMessageList.size();
                MessageListVM.this.uiMessageDMs.addAll(0, newMessageList);
                if (MessageListVM.this.messageListVMCallback != null) {
                    MessageListVM.this.messageListVMCallback.appendMessages(0, size);
                }
                boolean isDateGroupingChanged = MessageListVM.this.checkAndUpdateGroupByDate(size - 1);
                ValuePair<Integer, Integer> updatedMessages = MessageListVM.this.checkAndUpdateGroupByTime(MessageListVM.this.uiMessageDMs, size - 1, size + 1);
                if (isDateGroupingChanged) {
                    MessageListVM.this.notifyMessageListVMRefreshAll();
                } else if (updatedMessages != null) {
                    MessageListVM.this.notifyMessageListUpdate(updatedMessages);
                }
            }
        });
    }

    public synchronized UIConversation getUIConversation(long conversationLocalId) {
        return this.uiConversationLocalIdMap.get(conversationLocalId);
    }

    public synchronized void updateUIConversationOrder(List<UIConversation> uiConversationOrderList) {
        if (ListUtils.isEmpty(uiConversationOrderList)) {
            return;
        }
        this.uiConversationLocalIdMap.clear();
        for (UIConversation uiConversation : uiConversationOrderList) {
            this.uiConversationLocalIdMap.put(uiConversation.localID, uiConversation);
        }
    }

    public List<MessageDM> copyOfUIMessageDMs() {
        if (this.uiMessageDMs != null) {
            return new ArrayList<MessageDM>(this.uiMessageDMs);
        }
        return new ArrayList<MessageDM>();
    }

    public MessageDM getLastUIMessage() {
        int messagesCount = this.uiMessageDMs.size();
        if (messagesCount > 0) {
            return this.uiMessageDMs.get(messagesCount - 1);
        }
        return null;
    }

    public void remove(List<MessageDM> messageDMs) {
        final List<MessageDM> filteredMessages = this.filterUIMessages(messageDMs);
        if (ListUtils.isEmpty(filteredMessages)) {
            return;
        }
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                boolean shouldNotify = false;
                for (MessageDM messageDM : filteredMessages) {
                    int index = MessageListVM.this.uiMessageDMs.indexOf(messageDM);
                    if (index == -1) continue;
                    shouldNotify = true;
                    MessageListVM.this.uiMessageDMs.remove(index);
                    MessageListVM.this.checkAndUpdateGroupByDate(index - 1);
                    MessageListVM.this.checkAndUpdateGroupByTime(MessageListVM.this.uiMessageDMs, index - 1, index + 1);
                }
                if (shouldNotify) {
                    MessageListVM.this.notifyMessageListVMRefreshAll();
                    MessageListVM.this.notifyUIMessageListUpdated();
                }
            }
        });
    }

    void notifyUIMessageListUpdated() {
        if (this.messageListVMCallback != null) {
            this.messageListVMCallback.onUIMessageListUpdated();
        }
    }
}

