/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.viewmodel;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.NewConversationRenderer;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.EmailWidget;
import com.helpshift.widget.ImageAttachmentWidget;
import com.helpshift.widget.ProfileFormWidget;
import com.helpshift.widget.ProgressBarWidget;
import com.helpshift.widget.TextWidget;
import com.helpshift.widget.Widget;
import com.helpshift.widget.WidgetMediator;

class NewConversationMediator
implements WidgetMediator {
    private final Domain domain;
    TextWidget descriptionWidget;
    TextWidget nameWidget;
    EmailWidget emailWidget;
    ButtonWidget startConversationButton;
    ImageAttachmentWidget imageAttachmentWidget;
    ButtonWidget attachImageButton;
    ProgressBarWidget progressBarWidget;
    private NewConversationRenderer renderer;
    private ProfileFormWidget profileFormWidget;

    NewConversationMediator(NewConversationRenderer renderer, Domain domain) {
        this.renderer = renderer;
        this.domain = domain;
    }

    void setRenderer(NewConversationRenderer renderer) {
        this.renderer = renderer;
    }

    void setDescriptionWidget(TextWidget descriptionWidget) {
        descriptionWidget.setMediator(this);
        this.descriptionWidget = descriptionWidget;
    }

    void setNameWidget(TextWidget nameWidget) {
        nameWidget.setMediator(this);
        this.nameWidget = nameWidget;
    }

    void setEmailWidget(EmailWidget emailWidget) {
        emailWidget.setMediator(this);
        this.emailWidget = emailWidget;
    }

    void setStartConversationButton(ButtonWidget startConversationButton) {
        startConversationButton.setMediator(this);
        this.startConversationButton = startConversationButton;
    }

    void setImageAttachmentWidget(ImageAttachmentWidget imageAttachmentWidget) {
        imageAttachmentWidget.setMediator(this);
        this.imageAttachmentWidget = imageAttachmentWidget;
    }

    void setAttachImageButton(ButtonWidget attachImageButton) {
        attachImageButton.setMediator(this);
        this.attachImageButton = attachImageButton;
    }

    void setProgressBarWidget(ProgressBarWidget progressBarWidget) {
        progressBarWidget.setMediator(this);
        this.progressBarWidget = progressBarWidget;
    }

    void setProfileFormWidget(ProfileFormWidget profileFormWidget) {
        this.profileFormWidget = profileFormWidget;
    }

    @Override
    public void onChanged(final Widget widget) {
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                if (widget == NewConversationMediator.this.descriptionWidget) {
                    NewConversationMediator.this.renderDescription();
                } else if (widget == NewConversationMediator.this.nameWidget) {
                    NewConversationMediator.this.renderName();
                } else if (widget == NewConversationMediator.this.emailWidget) {
                    NewConversationMediator.this.renderEmail();
                } else if (widget == NewConversationMediator.this.startConversationButton) {
                    NewConversationMediator.this.renderStartNewConversationButton();
                } else if (widget == NewConversationMediator.this.attachImageButton) {
                    NewConversationMediator.this.renderAttachImageButton();
                } else if (widget == NewConversationMediator.this.progressBarWidget) {
                    NewConversationMediator.this.renderProgressBarWidget();
                    NewConversationMediator.this.updateAttachImageButtonWidget();
                    NewConversationMediator.this.updateStartNewConversationButtonWidget();
                    NewConversationMediator.this.updateImageAttachmentWidget();
                }
                if (widget == NewConversationMediator.this.imageAttachmentWidget) {
                    NewConversationMediator.this.renderImageAttachment();
                    NewConversationMediator.this.updateAttachImageButtonWidget();
                }
            }
        });
    }

    void renderAll() {
        this.renderDescription();
        this.renderName();
        this.renderEmail();
        this.renderImageAttachment();
        this.renderAttachImageButton();
        this.renderProfileFormWidget();
        this.renderProgressBarWidget();
        this.renderStartNewConversationButton();
    }

    void renderProgressBarWidget() {
        if (this.progressBarWidget.isVisible()) {
            this.renderer.showProgressBar();
        } else {
            this.renderer.hideProgressBar();
        }
    }

    void renderStartNewConversationButton() {
        if (this.startConversationButton.isVisible()) {
            this.renderer.showStartConversationButton();
        } else {
            this.renderer.hideStartConversationButton();
        }
    }

    void renderEmail() {
        this.renderer.setEmail(this.emailWidget.getText());
        if (TextWidget.TextWidgetError.INVALID_EMAIL.equals((Object)this.emailWidget.getError())) {
            this.renderer.showEmailInvalidError();
        } else if (TextWidget.TextWidgetError.EMPTY.equals((Object)this.emailWidget.getError())) {
            this.renderer.showEmailEmptyError();
        } else {
            this.renderer.clearEmailError();
        }
        if (this.emailWidget.isRequired()) {
            this.renderer.setEmailRequired();
        }
    }

    void renderDescription() {
        this.renderer.setDescription(this.descriptionWidget.getText());
        if (TextWidget.TextWidgetError.EMPTY.equals((Object)this.descriptionWidget.getError())) {
            this.renderer.showDescriptionEmptyError();
        } else if (TextWidget.TextWidgetError.ONLY_SPECIAL_CHARACTERS.equals((Object)this.descriptionWidget.getError())) {
            this.renderer.showDescriptionOnlySpecialCharactersError();
        } else if (TextWidget.TextWidgetError.LESS_THAN_MINIMUM_LENGTH.equals((Object)this.descriptionWidget.getError())) {
            this.renderer.showDescriptionLessThanMinimumError();
        } else {
            this.renderer.clearDescriptionError();
        }
    }

    void renderName() {
        this.renderer.setName(this.nameWidget.getText());
        if (TextWidget.TextWidgetError.EMPTY.equals((Object)this.nameWidget.getError())) {
            this.renderer.showNameEmptyError();
        } else if (TextWidget.TextWidgetError.ONLY_SPECIAL_CHARACTERS.equals((Object)this.nameWidget.getError())) {
            this.renderer.showNameOnlySpecialCharactersError();
        } else {
            this.renderer.clearNameError();
        }
    }

    void renderImageAttachment() {
        ImagePickerFile attachmentDraft = this.imageAttachmentWidget.getImagePickerFile();
        if (attachmentDraft == null || StringUtils.isEmpty(attachmentDraft.filePath)) {
            this.renderer.hideImageAttachmentContainer();
        } else {
            this.renderer.showImageAttachmentContainer(attachmentDraft.filePath, attachmentDraft.originalFileName, attachmentDraft.originalFileSize);
        }
        if (this.imageAttachmentWidget.isClickable()) {
            this.renderer.enableImageAttachmentClickable();
        } else {
            this.renderer.disableImageAttachmentClickable();
        }
    }

    void renderAttachImageButton() {
        if (this.attachImageButton.isVisible()) {
            this.renderer.showImageAttachmentButton();
        } else {
            this.renderer.hideImageAttachmentButton();
        }
    }

    private void renderProfileFormWidget() {
        if (this.profileFormWidget.isVisible()) {
            this.renderer.showProfileForm();
        } else {
            this.renderer.hideProfileForm();
        }
    }

    void updateAttachImageButtonWidget() {
        if (this.progressBarWidget.isVisible()) {
            this.attachImageButton.setVisible(false);
        } else {
            this.attachImageButton.setVisible(StringUtils.isEmpty(this.imageAttachmentWidget.getImagePath()));
        }
    }

    void updateStartNewConversationButtonWidget() {
        if (this.progressBarWidget.isVisible()) {
            this.startConversationButton.setVisible(false);
        } else {
            this.startConversationButton.setVisible(true);
        }
    }

    void updateImageAttachmentWidget() {
        this.imageAttachmentWidget.setClickable(!this.progressBarWidget.isVisible());
    }
}

