/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.crypto;

import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.util.HSLogger;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CryptoDM {
    private static final String TAG = "Helpshift_CryptoDM";
    private static final int MAX_HMAC_RETRY_COUNT = 1;

    public String getSignature(String message, String key) throws GeneralSecurityException {
        String signature = this.getHMacSHA256(message, key, 0);
        if (signature == null) {
            throw new GeneralSecurityException();
        }
        return signature;
    }

    private String getHMacSHA256(String message, String key, int retryCount) {
        if (retryCount > 1) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKey);
            byte[] hmacData = mac.doFinal(message.getBytes("UTF-8"));
            return this.toHex(hmacData);
        }
        catch (Exception e) {
            if (retryCount == 1) {
                HSLogger.f(TAG, "Could not generate mac signature: " + e.getLocalizedMessage() + ", retryCount: " + retryCount, e, new ILogExtrasModel[0]);
            } else {
                HSLogger.e(TAG, "Could not generate mac signature: " + e.getLocalizedMessage() + ", retryCount: " + retryCount, e);
            }
            return this.getHMacSHA256(message, key, retryCount + 1);
        }
    }

    private String toHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

