/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.delegate;

import com.helpshift.HelpshiftUser;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.delegate.AuthenticationFailureReason;
import com.helpshift.delegate.RootDelegate;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UIThreadDelegateDecorator {
    private Domain domain;
    private RootDelegate delegate;
    private Map<String, Boolean> authenticationFailedCalledList;

    public UIThreadDelegateDecorator(Domain domain) {
        this.domain = domain;
        this.authenticationFailedCalledList = new HashMap<String, Boolean>();
    }

    public void sessionBegan() {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.sessionBegan();
                }
            });
        }
    }

    public void sessionEnded() {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.sessionEnded();
                }
            });
        }
    }

    public void newConversationStarted(final String newConversationMessage) {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.newConversationStarted(newConversationMessage);
                }
            });
        }
    }

    public void conversationEnded() {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.conversationEnded();
                }
            });
        }
    }

    public void userRepliedToConversation(final String newMessage) {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.userRepliedToConversation(newMessage);
                }
            });
        }
    }

    public void userCompletedCustomerSatisfactionSurvey(final int rating, final String feedback) {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.userCompletedCustomerSatisfactionSurvey(rating, feedback);
                }
            });
        }
    }

    public void displayAttachmentFile(final File attachmentFile) {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.displayAttachmentFile(attachmentFile);
                }
            });
        }
    }

    public void didReceiveNotification(final int newMessagesCount) {
        if (this.delegate != null) {
            this.domain.runOnUI(new F(){

                @Override
                public void f() {
                    UIThreadDelegateDecorator.this.delegate.didReceiveNotification(newMessagesCount);
                }
            });
        }
    }

    public void authenticationFailed(UserDM userDM, final AuthenticationFailureReason reason) {
        if (this.delegate == null || !userDM.isActiveUser()) {
            return;
        }
        String key = userDM.getLocalId() + "_" + userDM.getAuthToken();
        if (this.authenticationFailedCalledList.containsKey(key) && this.authenticationFailedCalledList.get(key).booleanValue()) {
            return;
        }
        this.authenticationFailedCalledList.put(key, true);
        final HelpshiftUser user = new HelpshiftUser.Builder(userDM.getIdentifier(), userDM.getEmail()).setName(userDM.getName()).setAuthToken(userDM.getAuthToken()).build();
        this.domain.runOnUI(new F(){

            @Override
            public void f() {
                UIThreadDelegateDecorator.this.delegate.authenticationFailed(user, reason);
            }
        });
    }

    public boolean isDelegateRegistered() {
        return this.delegate != null;
    }

    public void setDelegate(RootDelegate delegate) {
        this.delegate = delegate;
    }
}

