/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.exceptions.handlers;

import android.content.Context;
import android.util.Log;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.util.ErrorReportProvider;
import com.helpshift.util.HSLogger;

public class UncaughtExceptionHandler {
    private static final CharSequence HELPSHIFT_BASE_PACKAGE_NAME = "com.helpshift";

    public static void init(final Context context) {
        final Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (UncaughtExceptionHandler.isCausedByHelpshift(ex)) {
                    ILogExtrasModel[] extrasModels = ErrorReportProvider.getErrorReportExtras(context, thread).toArray(new ILogExtrasModel[0]);
                    HSLogger.f("UncaughtExceptionHandler", "UNCAUGHT EXCEPTION ", ex, extrasModels);
                }
                if (defaultUncaughtExceptionHandler != null) {
                    defaultUncaughtExceptionHandler.uncaughtException(thread, ex);
                }
            }
        });
    }

    static boolean isCausedByHelpshift(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        String stackTrace = Log.getStackTraceString((Throwable)throwable);
        return stackTrace.contains(HELPSHIFT_BASE_PACKAGE_NAME);
    }
}

