/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.faq;

import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.ContentUnchangedNetwork;
import com.helpshift.common.domain.network.ETagNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GETNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.faq.FaqCore;
import com.helpshift.faq.FaqsResponse;
import com.helpshift.faq.dao.FaqEventDAO;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FaqsDM
implements AutoRetriableDM {
    final Domain domain;
    final Platform platform;
    final FaqEventDAO faqEventDAO;

    public FaqsDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.faqEventDAO = platform.getFaqEventDAO();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.FAQ, this);
    }

    public void markHelpful(final String faqId, final boolean isHelpful) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                block2: {
                    try {
                        FaqsDM.this.send(faqId, isHelpful);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.NON_RETRIABLE) break block2;
                        FaqsDM.this.faqEventDAO.insertFaqMarkHelpfulEvent(faqId, isHelpful);
                        FaqsDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.FAQ, e.getServerStatusCode());
                        throw e;
                    }
                }
            }
        });
        AnalyticsEventType eventType = isHelpful ? AnalyticsEventType.MARKED_HELPFUL : AnalyticsEventType.MARKED_UNHELPFUL;
        this.domain.getAnalyticsEventDM().pushEvent(eventType, faqId);
    }

    public void fetchQuestion(final FetchDataFromThread<FaqCore, Integer> callback, final String publishId, final String faqLanguage, final boolean isAdminSuggested) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                block4: {
                    try {
                        HashMap<String, String> body = new HashMap<String, String>();
                        String faqLang = faqLanguage;
                        boolean enableDefaultFallbackLanguage = isAdminSuggested ? true : FaqsDM.this.domain.getSDKConfigurationDM().getBoolean("defaultFallbackLanguageEnable");
                        body.put("edfl", String.valueOf(enableDefaultFallbackLanguage));
                        String route = "/faqs/" + publishId + "/";
                        RequestData requestData = new RequestData(body);
                        FaqsDM.this.setFaqsCustomHeaders(requestData, faqLang);
                        Network network = FaqsDM.this.getFaqsNetwork(route);
                        Response response = network.makeRequest(new RequestData(body));
                        FaqCore faqCore = FaqsDM.this.platform.getResponseParser().parseSingleFAQ(response.responseString);
                        callback.onDataFetched(faqCore);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONTENT_UNCHANGED) break block4;
                        int statusCode = e.getServerStatusCode();
                        if (statusCode == NetworkErrorCodes.FORBIDDEN_ACCESS || statusCode == NetworkErrorCodes.CONTENT_NOT_FOUND) {
                            if (isAdminSuggested) {
                                FaqsDM.this.platform.getFAQSuggestionsDAO().removeFAQ(publishId, faqLanguage);
                            }
                            String eTagUrl = "/faqs/" + publishId + "/";
                            FaqsDM.this.platform.getNetworkRequestDAO().storeETag(eTagUrl, "");
                        }
                        callback.onFailure(statusCode);
                    }
                }
            }
        });
    }

    public void fetchFaqs(final FetchDataFromThread<FaqsResponse, ExceptionType> callback) {
        if (callback == null) {
            return;
        }
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    int faqResponseCode;
                    Network network = FaqsDM.this.getFaqsNetwork("/faqs/");
                    HashMap<String, String> body = new HashMap<String, String>();
                    boolean enableDefaultFallbackLanguage = FaqsDM.this.domain.getSDKConfigurationDM().getBoolean("defaultFallbackLanguageEnable");
                    body.put("edfl", String.valueOf(enableDefaultFallbackLanguage));
                    RequestData requestData = new RequestData(body);
                    HashMap<String, String> customHeaders = new HashMap<String, String>();
                    String sdkLanguage = FaqsDM.this.domain.getLocaleProviderDM().getSDKLanguage();
                    String deviceLanguage = FaqsDM.this.domain.getLocaleProviderDM().getDefaultLanguage();
                    String faqLanguage = StringUtils.isEmpty(sdkLanguage) ? deviceLanguage : sdkLanguage;
                    customHeaders.put("Accept-Language", String.format(Locale.ENGLISH, "%s;q=1.0", faqLanguage));
                    requestData.setCustomHeaders(customHeaders);
                    FaqsDM.this.setFaqsCustomHeaders(requestData, null);
                    Response response = network.makeRequest(requestData);
                    String responseString = response.responseString;
                    Object faqResponse = null;
                    if (responseString != null) {
                        faqResponse = FaqsDM.this.platform.getJsonifier().jsonifyToArray(responseString);
                        faqResponseCode = 1;
                    } else {
                        faqResponseCode = 2;
                    }
                    FaqsResponse faqsResponse = new FaqsResponse(faqResponse, faqResponseCode);
                    callback.onDataFetched(faqsResponse);
                }
                catch (RootAPIException e) {
                    callback.onFailure(e.exceptionType);
                }
            }
        });
    }

    @Override
    public void sendFailedApiCalls(AutoRetryFailedEventDM.EventType eventType) {
        if (eventType != AutoRetryFailedEventDM.EventType.FAQ) {
            return;
        }
        Map<String, Boolean> unSentFaqEvents = this.faqEventDAO.getUnSentFaqMarkHelpfulEvents();
        if (unSentFaqEvents != null) {
            for (String faqId : unSentFaqEvents.keySet()) {
                Boolean isHelpful = unSentFaqEvents.get(faqId);
                try {
                    this.send(faqId, isHelpful);
                    this.faqEventDAO.removeFaqMarkHelpfulEvent(faqId);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                        this.faqEventDAO.removeFaqMarkHelpfulEvent(faqId);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    void send(String faqId, boolean isHelpful) {
        String route = isHelpful ? "/faqs/" + faqId + "/helpful/" : "/faqs/" + faqId + "/unhelpful/";
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new FailedAPICallNetworkDecorator(sendMessageNetwork);
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new GuardOKNetwork(sendMessageNetwork);
        RequestData requestData = new RequestData(new HashMap<String, String>());
        sendMessageNetwork.makeRequest(requestData);
    }

    void setFaqsCustomHeaders(RequestData requestData, String faqLanguage) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        if (StringUtils.isEmpty(faqLanguage)) {
            String sdkLanguage = this.domain.getLocaleProviderDM().getSDKLanguage();
            String deviceLanguage = this.domain.getLocaleProviderDM().getDefaultLanguage();
            faqLanguage = StringUtils.isEmpty(sdkLanguage) ? deviceLanguage : sdkLanguage;
        }
        customHeaders.put("Accept-Language", String.format(Locale.ENGLISH, "%s;q=1.0", faqLanguage));
        requestData.setCustomHeaders(customHeaders);
    }

    Network getFaqsNetwork(String route) {
        Network network = new GETNetwork(route, this.domain, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new ContentUnchangedNetwork(network);
        network = new GuardOKNetwork(network);
        network = new ETagNetwork(network, this.platform, route);
        return network;
    }
}

