/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.logger;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.CustomAuthDataPOSTNetwork;
import com.helpshift.common.domain.network.ETagNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.logger.model.LogModel;
import com.helpshift.util.HSFormat;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ErrorReportsDM {
    Domain domain;
    Platform platform;

    public ErrorReportsDM(Platform platform, Domain domain) {
        this.platform = platform;
        this.domain = domain;
    }

    public void sendErrorReport(final FetchDataFromThread<Response, Float> callback, final List<LogModel> logs, final UserDM userDM, final String hsDomain, final String apiVersion, final String sdkVersion, final String buildModel, final String campaignDeviceId, final String os) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    Object logsData = ErrorReportsDM.this.platform.getJsonifier().jsonifyLogModelList(logs);
                    ArrayList<String> metaDataList = new ArrayList<String>(5);
                    metaDataList.add(ErrorReportsDM.this.platform.getJsonifier().jsonifyToObject("domain", hsDomain).toString());
                    metaDataList.add(ErrorReportsDM.this.platform.getJsonifier().jsonifyToObject("dm", buildModel).toString());
                    metaDataList.add(ErrorReportsDM.this.platform.getJsonifier().jsonifyToObject("did", userDM.getDeviceId()).toString());
                    if (!StringUtils.isEmpty(campaignDeviceId)) {
                        metaDataList.add(ErrorReportsDM.this.platform.getJsonifier().jsonifyToObject("cdid", campaignDeviceId).toString());
                    }
                    metaDataList.add(ErrorReportsDM.this.platform.getJsonifier().jsonifyToObject("os", os).toString());
                    Object metaData = ErrorReportsDM.this.platform.getJsonifier().jsonifyListToJsonArray(metaDataList);
                    HashMap<String, String> hashMapData = new HashMap<String, String>();
                    hashMapData.put("id", UUID.randomUUID().toString());
                    hashMapData.put("v", apiVersion);
                    float serverTimeDelta = ErrorReportsDM.this.platform.getNetworkRequestDAO().getServerTimeDelta();
                    long deviceTs = System.currentTimeMillis();
                    if (serverTimeDelta != 0.0f) {
                        deviceTs = (long)((float)deviceTs + serverTimeDelta * 1000.0f);
                    }
                    hashMapData.put("ctime", HSFormat.errorLogReportingTimeFormat.format(new Date(deviceTs)));
                    hashMapData.put("src", "sdk.android." + sdkVersion);
                    hashMapData.put("logs", logsData.toString());
                    hashMapData.put("md", metaData.toString());
                    Network network = new CustomAuthDataPOSTNetwork("/events/crash-log", ErrorReportsDM.this.domain, ErrorReportsDM.this.platform, ErrorReportsDM.this.getAuthDataForErrorReports());
                    network = new FailedAPICallNetworkDecorator(network);
                    network = new TSCorrectedNetwork(network, ErrorReportsDM.this.platform);
                    network = new GuardOKNetwork(network);
                    network = new ETagNetwork(network, ErrorReportsDM.this.platform, "/faqs");
                    Response response = network.makeRequest(new RequestData(hashMapData));
                    callback.onDataFetched(response);
                }
                catch (RootAPIException e) {
                    float serverTimeDelta = ErrorReportsDM.this.platform.getNetworkRequestDAO().getServerTimeDelta();
                    callback.onFailure(Float.valueOf(serverTimeDelta));
                }
            }
        });
    }

    Map<String, String> getAuthDataForErrorReports() {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add("platform-id=sdk");
            String token = UUID.randomUUID().toString();
            dataList.add("token=" + token);
            data.put("token", token);
            data.put("sm", this.platform.getJsonifier().jsonify(NetworkDataRequestUtil.getSdkMeta()));
            dataList.add("sm=" + this.platform.getJsonifier().jsonify(NetworkDataRequestUtil.getSdkMeta()));
            data.put("signature", this.domain.getCryptoDM().getSignature(StringUtils.join("&", dataList), "sdk"));
            return data;
        }
        catch (GeneralSecurityException e) {
            throw RootAPIException.wrap(e, null, "SecurityException while creating signature");
        }
    }
}

