/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.logger;

import android.content.Context;
import android.util.Log;
import com.helpshift.logger.ILogger;
import com.helpshift.logger.LogMessage;
import com.helpshift.logger.WorkerThread;
import com.helpshift.logger.database.LogSQLiteStorage;
import com.helpshift.logger.database.LogStorage;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.model.LogModel;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class Logger
implements ILogger {
    static final int MAX_LOG_SIZE = 5000;
    static final int MAX_EXTRAS_COUNT = 20;
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String FATAL = "FATAL";
    private int loggingLevel = 4;
    private static final String TAG = Logger.class.getSimpleName();
    private final String sdkVersion;
    private boolean enableConsoleLogging;
    private boolean enableLogCaching;
    private long timestampDelta;
    private LogStorage logStorage;
    private ThreadPoolExecutor threadPoolExecutor;

    Logger(Context context, String dbName, String sdkVersion) {
        this.logStorage = new LogSQLiteStorage(context, dbName);
        this.sdkVersion = sdkVersion;
    }

    @Override
    public void enableLogging(boolean enableConsoleLogging, boolean enableLogCaching) {
        this.enableConsoleLogging = enableConsoleLogging;
        if (this.enableLogCaching == enableLogCaching) {
            return;
        }
        this.enableLogCaching = enableLogCaching;
        if (this.enableLogCaching) {
            LinkedBlockingQueue<Runnable> logMessagesQueue = new LinkedBlockingQueue<Runnable>();
            this.threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, logMessagesQueue, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "HS-Logger");
                }
            });
        } else if (this.threadPoolExecutor != null) {
            this.threadPoolExecutor.shutdown();
        }
    }

    @Override
    public void setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    @Override
    public void setTimestampDelta(long timestampDelta) {
        this.timestampDelta = timestampDelta;
    }

    @Override
    public void d(String tag, String message) {
        this.d(tag, message, (Throwable[])null, (ILogExtrasModel[])null);
    }

    @Override
    public void w(String tag, String message) {
        this.w(tag, message, (Throwable[])null, (ILogExtrasModel[])null);
    }

    @Override
    public void e(String tag, String message) {
        this.e(tag, message, (Throwable[])null, (ILogExtrasModel[])null);
    }

    @Override
    public void d(String tag, String message, Throwable[] tr) {
        this.d(tag, message, tr, null);
    }

    @Override
    public void w(String tag, String message, Throwable[] tr) {
        this.w(tag, message, tr, null);
    }

    @Override
    public void e(String tag, String message, Throwable[] tr) {
        this.e(tag, message, tr, null);
    }

    @Override
    public void f(String tag, String message, Throwable[] tr) {
        this.f(tag, message, tr, null);
    }

    @Override
    public void d(String tag, String message, ILogExtrasModel ... extras) {
        this.d(tag, message, (Throwable[])null, extras);
    }

    @Override
    public void w(String tag, String message, ILogExtrasModel ... extras) {
        this.w(tag, message, (Throwable[])null, extras);
    }

    @Override
    public void e(String tag, String message, ILogExtrasModel ... extras) {
        this.e(tag, message, (Throwable[])null, extras);
    }

    @Override
    public void d(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        if (this.isConsoleLoggingEnabled() && this.loggingLevel <= 2) {
            String stacktrace = this.getStackTraceString(tr);
            Log.d((String)tag, (String)(message + this.getExtrasForConsoleLogging(extras) + stacktrace));
        }
    }

    @Override
    public void w(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        String stacktrace = null;
        if (this.isConsoleLoggingEnabled() && this.loggingLevel <= 4) {
            stacktrace = this.getStackTraceString(tr);
            Log.w((String)tag, (String)(message + this.getExtrasForConsoleLogging(extras) + stacktrace));
        }
        if (this.isLogCachingEnabled()) {
            if (stacktrace == null) {
                stacktrace = this.getStackTraceString(tr);
            }
            this.logMessageToDatabase(WARN, message, stacktrace, extras);
        }
    }

    @Override
    public void e(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        String stacktrace = null;
        if (this.isConsoleLoggingEnabled() && this.loggingLevel <= 8) {
            stacktrace = this.getStackTraceString(tr);
            Log.e((String)tag, (String)(message + this.getExtrasForConsoleLogging(extras) + stacktrace));
        }
        if (this.isLogCachingEnabled() && !this.containsUnknownHostException(tr)) {
            if (stacktrace == null) {
                stacktrace = this.getStackTraceString(tr);
            }
            this.logMessageToDatabase(ERROR, message, stacktrace, extras);
        }
    }

    @Override
    public void f(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        String stacktrace = null;
        if (this.isConsoleLoggingEnabled() && this.loggingLevel <= 16) {
            stacktrace = this.getStackTraceString(tr);
            Log.e((String)tag, (String)(message + this.getExtrasForConsoleLogging(extras) + stacktrace));
        }
        if (this.isLogCachingEnabled()) {
            if (stacktrace == null) {
                stacktrace = this.getStackTraceString(tr);
            }
            Future future = this.logMessageToDatabase(FATAL, message, stacktrace, extras);
            try {
                if (future != null) {
                    future.get();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error logging fatal log : " + e.getMessage()));
            }
        }
    }

    @Override
    public List<LogModel> getAll() {
        return this.logStorage.getAll();
    }

    @Override
    public void deleteAllCachedLogs() {
        this.logStorage.deleteAll();
    }

    @Override
    public int getCount(int mask) {
        return this.logStorage.getCount(this.convertMaskToLogLevel(mask));
    }

    private boolean isConsoleLoggingEnabled() {
        return this.enableConsoleLogging;
    }

    private boolean isLogCachingEnabled() {
        return this.enableLogCaching;
    }

    private Future logMessageToDatabase(String level, String message, String stacktrace, ILogExtrasModel[] extras) {
        LogMessage logMessage = new LogMessage();
        logMessage.level = level;
        logMessage.extras = extras;
        logMessage.message = message;
        logMessage.timeStamp = System.currentTimeMillis() + this.timestampDelta;
        logMessage.stacktrace = stacktrace;
        logMessage.sdkVersion = this.sdkVersion;
        try {
            Future<?> future = this.threadPoolExecutor.submit(new WorkerThread(logMessage, this.logStorage));
            return future;
        }
        catch (RejectedExecutionException e) {
            Log.e((String)TAG, (String)("Rejected execution of log message : " + logMessage.message), (Throwable)e);
            return null;
        }
    }

    private boolean containsUnknownHostException(Throwable[] throwables) {
        if (throwables == null) {
            return false;
        }
        boolean containsUnknownHostException = false;
        for (int i = 0; i < throwables.length; ++i) {
            if (!(throwables[i] instanceof UnknownHostException)) continue;
            containsUnknownHostException = true;
            break;
        }
        return containsUnknownHostException;
    }

    private String getExtrasForConsoleLogging(ILogExtrasModel[] extras) {
        String extrasLogMessage = " ";
        if (extras != null && extras.length > 0) {
            StringBuilder sb = new StringBuilder(" ");
            for (ILogExtrasModel extra : extras) {
                if (extra == null) continue;
                sb.append(extra.getConsoleLoggingMessage());
                sb.append(" ");
            }
            extrasLogMessage = sb.toString();
        }
        return extrasLogMessage;
    }

    private String getStackTraceString(Throwable[] throwables) {
        String stacktrace = "";
        if (throwables != null) {
            StringBuilder builder = new StringBuilder();
            if (this.containsUnknownHostException(throwables)) {
                stacktrace = "UnknownHostException";
            } else {
                for (int i = 0; i < throwables.length; ++i) {
                    String throwableString = Log.getStackTraceString((Throwable)throwables[i]);
                    builder.append(throwableString);
                }
                stacktrace = builder.toString();
            }
        }
        return stacktrace;
    }

    private List<String> convertMaskToLogLevel(int mask) {
        if (mask == 0) {
            return null;
        }
        ArrayList<String> levels = new ArrayList<String>();
        if ((mask & 8) != 0) {
            levels.add(ERROR);
        }
        if ((mask & 4) != 0) {
            levels.add(WARN);
        }
        if ((mask & 0x10) != 0) {
            levels.add(FATAL);
        }
        return levels;
    }
}

