/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.logger.adapters;

import android.content.ContentValues;
import android.database.Cursor;
import com.helpshift.logger.model.LogModel;
import java.util.ArrayList;
import java.util.List;

public class LogStorageModelAdapter {
    public static ContentValues toContentValues(LogModel model) {
        ContentValues values = new ContentValues();
        values.put("TIMESTAMP", model.timeStamp);
        values.put("MESSAGE", model.message);
        values.put("LEVEL", model.level);
        values.put("EXTRAS", model.extras);
        values.put("STACKTRACE", model.stacktrace);
        values.put("SDK_VERSION", model.sdkVersion);
        return values;
    }

    public static List<LogModel> fromCursor(Cursor c) {
        ArrayList<LogModel> logs = new ArrayList<LogModel>();
        if (c != null && c.moveToFirst()) {
            while (!c.isAfterLast()) {
                String timestamp = c.getString(c.getColumnIndex("TIMESTAMP"));
                String message = c.getString(c.getColumnIndex("MESSAGE"));
                String level = c.getString(c.getColumnIndex("LEVEL"));
                String stacktrace = c.getString(c.getColumnIndex("STACKTRACE"));
                String extras = c.getString(c.getColumnIndex("EXTRAS"));
                String sdkVersion = c.getString(c.getColumnIndex("SDK_VERSION"));
                LogModel logModel = new LogModel(timestamp, level, message, stacktrace, extras, sdkVersion);
                logs.add(logModel);
                c.moveToNext();
            }
        }
        return logs;
    }
}

