/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.logger.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.helpshift.logger.adapters.LogStorageModelAdapter;
import com.helpshift.logger.database.LogStorage;
import com.helpshift.logger.database.LogStorageSQLiteHelper;
import com.helpshift.logger.model.LogModel;
import java.util.List;

public class LogSQLiteStorage
implements LogStorage {
    private static final String TAG = "LogSqliteStorage";
    private static final Object syncLock = new Object();
    private static final int MAX_ROWS = 100;
    private LogStorageSQLiteHelper logStorageSQLiteHelper;

    public LogSQLiteStorage(Context context, String dbName) {
        this.logStorageSQLiteHelper = new LogStorageSQLiteHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(LogModel logModel) {
        SQLiteDatabase db = null;
        Cursor allRowIdCursor = null;
        Object object = syncLock;
        synchronized (object) {
            try {
                db = this.logStorageSQLiteHelper.getWritableDatabase();
                db.beginTransaction();
                try {
                    allRowIdCursor = db.rawQuery("SELECT rowid FROM LOG_MESSAGES", null);
                    if (allRowIdCursor != null && allRowIdCursor.getCount() >= 100) {
                        allRowIdCursor.moveToFirst();
                        int firstRowId = allRowIdCursor.getInt(0);
                        db.delete("LOG_MESSAGES", "rowid = ?", new String[]{String.valueOf(firstRowId)});
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)("Error in rotation of logs + " + e.getMessage()));
                    db.delete("LOG_MESSAGES", null, null);
                }
                db.insert("LOG_MESSAGES", null, LogStorageModelAdapter.toContentValues(logModel));
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error inserting log : ", (Throwable)e);
            }
            finally {
                try {
                    if (db != null) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error inserting log inside finally block: ", (Throwable)e);
                }
                if (allRowIdCursor != null) {
                    allRowIdCursor.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogModel> getAll() {
        List<LogModel> logs = null;
        Cursor cursor = null;
        Object object = syncLock;
        synchronized (object) {
            try {
                SQLiteDatabase db = this.logStorageSQLiteHelper.getReadableDatabase();
                cursor = db.rawQuery("SELECT * FROM LOG_MESSAGES", null);
                logs = LogStorageModelAdapter.fromCursor(cursor);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error getting all log messages : ", (Throwable)e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        Object object = syncLock;
        synchronized (object) {
            try {
                SQLiteDatabase db = this.logStorageSQLiteHelper.getWritableDatabase();
                db.execSQL("DELETE FROM LOG_MESSAGES");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error deleting all logs from db", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(List<String> levels) {
        if (levels == null || levels.isEmpty()) {
            return 0;
        }
        int rowCount = 0;
        String inQuery = this.makeINQueryPlaceHolders(levels.size());
        try (Cursor countCursor = null;){
            SQLiteDatabase db = this.logStorageSQLiteHelper.getReadableDatabase();
            countCursor = db.rawQuery("SELECT COUNT(*) FROM LOG_MESSAGES WHERE LEVEL IN " + inQuery, levels.toArray(new String[0]));
            if (countCursor != null && countCursor.moveToFirst()) {
                rowCount = countCursor.getInt(0);
            }
        }
        return rowCount;
    }

    private String makeINQueryPlaceHolders(int count) {
        if (count == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < count - 1; ++i) {
            sb.append("?,");
        }
        sb.append("?)");
        return sb.toString();
    }
}

