/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.meta;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.meta.RootMetaDataCallable;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.meta.dto.BreadCrumbDTO;
import com.helpshift.meta.dto.DebugLogDTO;
import com.helpshift.meta.dto.DeviceDiskSpaceDTO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;

public class MetaDataDM {
    private final SDKConfigurationDM sdkConfigurationDM;
    private final Jsonifier jsonifier;
    private final Device device;
    private Domain domain;
    private MetaDataDAO metaDataDAO;
    private RootMetaDataCallable customMetaDataCallable;
    private LinkedList<DebugLogDTO> debugLogDTOs = new LinkedList();

    public MetaDataDM(Domain domain, Platform platform, SDKConfigurationDM sdkConfigurationDM) {
        this.domain = domain;
        this.sdkConfigurationDM = sdkConfigurationDM;
        this.metaDataDAO = platform.getMetaDataDAO();
        this.jsonifier = platform.getJsonifier();
        this.device = platform.getDevice();
    }

    private static String[] cleanTags(String[] input) {
        HashSet<String> result = new HashSet<String>();
        if (input != null) {
            for (String value : input) {
                if (StringUtils.isEmpty(value) || value.trim().length() <= 0) continue;
                result.add(value.trim());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized void pushBreadCrumb(String breadCrumb) {
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH).format(new Date());
        ArrayList<BreadCrumbDTO> breadCrumbDTOs = this.metaDataDAO.getBreadCrumbs();
        if (breadCrumbDTOs == null) {
            breadCrumbDTOs = new ArrayList();
        }
        breadCrumbDTOs.add(new BreadCrumbDTO(breadCrumb, dateTime));
        int breadCrumbLimit = this.sdkConfigurationDM.getInt("breadcrumbLimit");
        int length = breadCrumbDTOs.size();
        if (breadCrumbLimit > 0) {
            if (length > breadCrumbLimit) {
                int index = length - breadCrumbLimit;
                breadCrumbDTOs = new ArrayList<BreadCrumbDTO>(breadCrumbDTOs.subList(index, length));
            }
            this.metaDataDAO.setBreadCrumbs(breadCrumbDTOs);
        }
    }

    public synchronized void clearBreadCrumbs() {
        this.metaDataDAO.setBreadCrumbs(null);
    }

    private Object getBreadCrumbs() {
        return this.jsonifier.jsonifyBreadCrumbDTOList(this.metaDataDAO.getBreadCrumbs());
    }

    private Object getDiskSpace() {
        DeviceDiskSpaceDTO diskSpaceDTO = this.device.getDiskSpace();
        HashMap<String, Object> diskSpace = new HashMap<String, Object>();
        if (diskSpaceDTO != null) {
            diskSpace.put("total-space-phone", diskSpaceDTO.phoneTotalSpace);
            diskSpace.put("free-space-phone", diskSpaceDTO.phoneFreeSpace);
        }
        return this.jsonifier.jsonifyToObject(diskSpace);
    }

    private Object getDeviceInfo() {
        HashMap<String, Object> deviceDataMap = new HashMap<String, Object>();
        deviceDataMap.put("platform", this.device.getPlatformName());
        deviceDataMap.put("library-version", this.device.getSDKVersion());
        deviceDataMap.put("device-model", this.device.getDeviceModel());
        deviceDataMap.put("os-version", this.device.getOSVersion());
        try {
            String sdkLanguage = this.sdkConfigurationDM.getString("sdkLanguage");
            if (StringUtils.isEmpty(sdkLanguage)) {
                sdkLanguage = this.device.getLanguage();
            }
            if (!StringUtils.isEmpty(sdkLanguage)) {
                deviceDataMap.put("language-code", sdkLanguage);
            }
        }
        catch (MissingResourceException sdkLanguage) {
            // empty catch block
        }
        deviceDataMap.put("timestamp", this.device.getTimeStamp());
        deviceDataMap.put("application-identifier", this.device.getAppIdentifier());
        String appName = this.device.getAppName();
        if (StringUtils.isEmpty(appName)) {
            appName = "(unknown)";
        }
        deviceDataMap.put("application-name", appName);
        deviceDataMap.put("application-version", this.device.getAppVersion());
        deviceDataMap.put("disk-space", this.getDiskSpace());
        if (!this.sdkConfigurationDM.getBoolean("fullPrivacy")) {
            deviceDataMap.put("country-code", this.device.getSimCountryIso());
            deviceDataMap.put("carrier-name", this.device.getCarrierName());
        }
        deviceDataMap.put("network-type", this.device.getNetworkType());
        deviceDataMap.put("battery-level", this.device.getBatteryLevel());
        deviceDataMap.put("battery-status", this.device.getBatteryStatus());
        return this.jsonifier.jsonifyToObject(deviceDataMap);
    }

    private Object getExtra(String customIdentifier) {
        HashMap<String, Object> extraDataMap = new HashMap<String, Object>();
        extraDataMap.put("api-version", this.device.getApiVersion());
        extraDataMap.put("library-version", this.device.getSDKVersion());
        if (!StringUtils.isEmpty(customIdentifier)) {
            extraDataMap.put("user-id", customIdentifier);
        }
        return this.jsonifier.jsonifyToObject(extraDataMap);
    }

    public void addDebugLog(final DebugLogDTO debugLogDTO) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                MetaDataDM.this.addDebugLogInternal(debugLogDTO);
            }
        });
    }

    synchronized void addDebugLogInternal(DebugLogDTO debugLogDTO) {
        int singleLogMaxSize = 5000;
        if (debugLogDTO.msg != null && debugLogDTO.msg.length() > singleLogMaxSize) {
            String newMsg = debugLogDTO.msg.substring(0, singleLogMaxSize);
            debugLogDTO = new DebugLogDTO(debugLogDTO.level, debugLogDTO.tag, newMsg, debugLogDTO.throwable);
        }
        if (this.debugLogDTOs.size() > 100) {
            try {
                this.debugLogDTOs.removeLast();
            }
            catch (NoSuchElementException e) {
                throw RootAPIException.wrap(e);
            }
        }
        if (this.sdkConfigurationDM.getInt("debugLogLimit") != 0) {
            this.debugLogDTOs.addFirst(debugLogDTO);
        }
    }

    private synchronized Object getDebugLogs() {
        ArrayList<DebugLogDTO> debugLogDTOList = new ArrayList<DebugLogDTO>();
        int size = this.debugLogDTOs.size();
        int limit = this.sdkConfigurationDM.getInt("debugLogLimit");
        for (int i = 0; i < size && i < limit; ++i) {
            try {
                debugLogDTOList.add(this.debugLogDTOs.removeFirst());
                continue;
            }
            catch (NoSuchElementException e) {
                throw RootAPIException.wrap(e);
            }
        }
        this.debugLogDTOs.clear();
        return this.jsonifier.jsonifyDebugLogDTOList(debugLogDTOList);
    }

    public void setCustomMetaDataCallable(RootMetaDataCallable callable) {
        this.customMetaDataCallable = callable;
    }

    private void saveCustomMetaData(Map<String, Serializable> metaData) {
        HashMap<String, Serializable> data = null;
        if (metaData != null) {
            data = new HashMap<String, Serializable>();
            data.putAll(metaData);
        }
        this.metaDataDAO.saveCustomMetaData(data);
    }

    public Object getCustomMetaData() {
        Map<String, Serializable> customMetaMap;
        if (this.customMetaDataCallable != null) {
            customMetaMap = this.getCustomMetaDataFromCallable();
            this.saveCustomMetaData(customMetaMap);
        } else {
            customMetaMap = this.metaDataDAO.getCustomMetaData();
        }
        Object customMetaObject = null;
        if (customMetaMap != null) {
            if (this.sdkConfigurationDM.getBoolean("fullPrivacy")) {
                customMetaMap.remove("private-data");
            }
            customMetaObject = this.jsonifier.jsonifyCustomMetaMap(customMetaMap);
        }
        return customMetaObject;
    }

    public void clearCustomMetaData() {
        this.metaDataDAO.saveCustomMetaData(null);
    }

    public Object getMetaInfo() {
        HashMap<String, Object> metaInfo = new HashMap<String, Object>();
        metaInfo.put("breadcrumbs", this.getBreadCrumbs());
        metaInfo.put("device_info", this.getDeviceInfo());
        metaInfo.put("logs", this.getDebugLogs());
        Object customMetaData = this.getCustomMetaData();
        if (customMetaData != null) {
            metaInfo.put("custom_meta", customMetaData);
        }
        String customIdentifier = this.domain.getUserManagerDM().getUserMetaIdentifier();
        metaInfo.put("extra", this.getExtra(customIdentifier));
        HashMap<String, Object> userDataMap = new HashMap<String, Object>();
        userDataMap.put("fp_status", this.sdkConfigurationDM.getBoolean("fullPrivacy"));
        metaInfo.put("user_info", this.jsonifier.jsonifyToObject(userDataMap));
        return this.jsonifier.jsonifyToObject(metaInfo);
    }

    private Map<String, Serializable> getCustomMetaDataFromCallable() {
        Map<String, Serializable> customMetaMap = null;
        if (this.customMetaDataCallable != null && (customMetaMap = this.customMetaDataCallable.call()) != null) {
            customMetaMap = this.removeEmptyKeyOrValue(customMetaMap);
            customMetaMap = this.cleanMetaTags(customMetaMap, "hs-tags");
        }
        return customMetaMap;
    }

    private Map<String, Serializable> removeEmptyKeyOrValue(Map<String, Serializable> metadata) {
        HashMap<String, Serializable> newMetaData = new HashMap<String, Serializable>(metadata);
        for (Map.Entry<String, Serializable> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Serializable value = entry.getValue();
            if (!StringUtils.isEmpty(key) && (!(value instanceof String) || !StringUtils.isEmpty((String)((Object)value)))) continue;
            newMetaData.remove(key);
        }
        return newMetaData;
    }

    private Map<String, Serializable> cleanMetaTags(Map<String, Serializable> meta, String tagsKey) {
        String[] data = new String[]{};
        Serializable tags = meta.remove(tagsKey);
        if (tags instanceof String[]) {
            data = MetaDataDM.cleanTags((String[])tags);
        }
        if (data.length > 0) {
            meta.put(tagsKey, (Serializable)data);
        }
        return meta;
    }
}

