/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.migration;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.domain.network.UserNotFoundNetwork;
import com.helpshift.common.domain.network.UserPreConditionsFailedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.migration.LegacyProfileMigrationDAO;
import com.helpshift.migration.MigrationState;
import com.helpshift.migration.legacyUser.LegacyProfile;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class RemoteDataMigrator {
    private Platform platform;
    private Domain domain;
    private UserDM userDM;
    private WeakReference<RemoteDataMigratorListener> remoteDataMigratorListener;
    private LegacyProfileMigrationDAO legacyProfileMigrationDAO;

    public RemoteDataMigrator(Platform platform, Domain domain, UserDM userDM, RemoteDataMigratorListener listener) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
        this.remoteDataMigratorListener = new WeakReference<RemoteDataMigratorListener>(listener);
        this.legacyProfileMigrationDAO = platform.getLegacyUserMigrationDataSource();
    }

    public void setAppropriateInitialState() {
        MigrationState migrationState = this.getProfileMigrationState();
        if (migrationState == MigrationState.IN_PROGRESS) {
            this.updateProfileMigrationStateUpdate(MigrationState.IN_PROGRESS, MigrationState.NOT_STARTED);
        }
    }

    public MigrationState getProfileMigrationState() {
        if (StringUtils.isEmpty(this.userDM.getIdentifier())) {
            return MigrationState.COMPLETED;
        }
        LegacyProfile legacyProfile = this.legacyProfileMigrationDAO.fetchLegacyProfile(this.userDM.getIdentifier());
        if (legacyProfile == null) {
            return MigrationState.COMPLETED;
        }
        return legacyProfile.migrationState;
    }

    public void startProfileMigration() {
        MigrationState migrationState = this.getProfileMigrationState();
        if (migrationState == MigrationState.COMPLETED || migrationState == MigrationState.IN_PROGRESS) {
            return;
        }
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    RemoteDataMigrator.this.runRemoteMigrationInternal();
                }
                catch (RootAPIException e) {
                    RemoteDataMigrator.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.MIGRATION, e.getServerStatusCode());
                    throw e;
                }
            }
        });
    }

    private void runRemoteMigrationInternal() {
        MigrationState migrationState = this.getProfileMigrationState();
        if (migrationState == MigrationState.COMPLETED || migrationState == MigrationState.IN_PROGRESS) {
            return;
        }
        LegacyProfile legacyProfile = this.legacyProfileMigrationDAO.fetchLegacyProfile(this.userDM.getIdentifier());
        if (legacyProfile == null) {
            return;
        }
        MigrationState currentMigrationState = legacyProfile.migrationState;
        if (currentMigrationState == MigrationState.NOT_STARTED || currentMigrationState == MigrationState.FAILED) {
            Network network = new POSTNetwork("/migrate-profile/", this.domain, this.platform);
            network = new TSCorrectedNetwork(network, this.platform);
            network = new UserPreConditionsFailedNetwork(network);
            network = new UserNotFoundNetwork(network);
            network = new FailedAPICallNetworkDecorator(network);
            network = new GuardOKNetwork(network);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("profile-id", legacyProfile.serverId);
            data.put("did", this.userDM.getDeviceId());
            if (!StringUtils.isEmpty(this.userDM.getIdentifier())) {
                data.put("uid", this.userDM.getIdentifier());
            }
            if (!StringUtils.isEmpty(this.userDM.getEmail())) {
                data.put("email", this.userDM.getEmail());
            }
            this.updateProfileMigrationStateUpdate(currentMigrationState, MigrationState.IN_PROGRESS);
            try {
                network.makeRequest(new RequestData(data));
                this.updateProfileMigrationStateUpdate(currentMigrationState, MigrationState.COMPLETED);
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.USER_PRE_CONDITION_FAILED || e.exceptionType == NetworkException.USER_NOT_FOUND) {
                    this.updateProfileMigrationStateUpdate(currentMigrationState, MigrationState.COMPLETED);
                }
                if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                    this.updateProfileMigrationStateUpdate(currentMigrationState, MigrationState.COMPLETED);
                }
                this.updateProfileMigrationStateUpdate(currentMigrationState, MigrationState.FAILED);
                throw e;
            }
        }
    }

    private void updateProfileMigrationStateUpdate(final MigrationState oldState, final MigrationState newState) {
        if (newState == MigrationState.COMPLETED) {
            this.legacyProfileMigrationDAO.deleteLegacyProfile(this.userDM.getIdentifier());
        } else {
            this.legacyProfileMigrationDAO.updateMigrationState(this.userDM.getIdentifier(), newState);
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                if (RemoteDataMigrator.this.remoteDataMigratorListener.get() != null) {
                    ((RemoteDataMigratorListener)RemoteDataMigrator.this.remoteDataMigratorListener.get()).onMigrationStateChanged(RemoteDataMigrator.this.userDM, oldState, newState);
                }
            }
        });
    }

    public void retry() {
        this.runRemoteMigrationInternal();
    }

    public static interface RemoteDataMigratorListener {
        public void onMigrationStateChanged(UserDM var1, MigrationState var2, MigrationState var3);
    }
}

