/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.model;

import android.text.TextUtils;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.platform.Platform;
import com.helpshift.storage.KeyValueStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class SdkInfoModel {
    public static final String SDK_LANGUAGE = "sdk-language";
    private static final String CHANGE_SET_ID_PREFIX = "hs__change_set_id:";
    private static final String KEY_SYNCED_USER_ID = "hs-synced-user-id";
    private static final String KEY_DEVICE_ID = "hs-device-id";
    private HashMap<String, String> etags;
    private KeyValueStorage storage;
    private BackupDAO backupStorage;

    protected SdkInfoModel(KeyValueStorage kvStore, Platform platform) {
        this.storage = kvStore;
        this.backupStorage = platform.getBackupDAO();
        this.etags = (HashMap)this.storage.get("etags");
        if (this.etags == null) {
            this.etags = new HashMap();
        }
        this.updateBackupStorageWithInternalStorage();
    }

    public void addEtag(String etag, String route) {
        this.etags.put(route, etag);
        this.storage.set("etags", this.etags);
    }

    public String getEtag(String route) {
        return this.etags.get(route);
    }

    public void clearEtag(String route) {
        if (this.etags.containsKey(route)) {
            this.etags.remove(route);
            this.storage.set("etags", this.etags);
        }
    }

    public Float getServerTimeDelta() {
        return (Float)this.storage.get("server-time-delta");
    }

    public void setServerTimeDelta(Float serverTimeDelta) {
        this.storage.set("server-time-delta", serverTimeDelta);
    }

    public String getCurrentLoggedInId() {
        return (String)this.storage.get("current-logged-in-id");
    }

    public void setCurrentLoggedInId(String identifier) throws IllegalArgumentException {
        if (identifier != null) {
            identifier = identifier.trim();
        }
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            throw new IllegalArgumentException();
        }
        this.storage.set("current-logged-in-id", (Serializable)((Object)identifier));
    }

    public void addDeviceId(String deviceId) throws IllegalArgumentException {
        if (deviceId != null) {
            deviceId = deviceId.trim();
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            throw new IllegalArgumentException();
        }
        this.storage.set(KEY_DEVICE_ID, (Serializable)((Object)deviceId));
        this.backupStorage.storeValue(KEY_DEVICE_ID, (Serializable)((Object)deviceId));
    }

    public String getDeviceId() {
        String returnValue = (String)this.storage.get(KEY_DEVICE_ID);
        if (returnValue == null) {
            returnValue = (String)((Object)this.backupStorage.getValue(KEY_DEVICE_ID));
        }
        return returnValue;
    }

    public Boolean getFirstLaunch() {
        return (Boolean)this.storage.get("hs-first-launch");
    }

    public void setFirstLaunch(Boolean firstLaunch) {
        this.storage.set("hs-first-launch", firstLaunch);
    }

    public Boolean getOneCampaignFetchSuccessful() {
        return (Boolean)this.storage.get("hs-one-campaign-fetch-successful");
    }

    public void setOneCampaignFetchSuccessful(Boolean campaignFetchSuccessful) {
        this.storage.set("hs-one-campaign-fetch-successful", campaignFetchSuccessful);
    }

    public Boolean getDevicePropertiesSyncImmediately() {
        Boolean value = (Boolean)this.storage.get("hs-device-properties-sync-immediately");
        if (value == null) {
            value = false;
        }
        return value;
    }

    public void setDevicePropertiesSyncImmediately(Boolean devicePropertiesSyncImmediately) {
        this.storage.set("hs-device-properties-sync-immediately", devicePropertiesSyncImmediately);
    }

    public String getSdkLanguage() {
        return (String)this.storage.get(SDK_LANGUAGE);
    }

    public void setSdkLanguage(String language) {
        this.storage.set(SDK_LANGUAGE, (Serializable)((Object)language));
    }

    public void setChangeSetId(String changeSetId, String campaignId) {
        String key = CHANGE_SET_ID_PREFIX + campaignId;
        this.storage.set(key, (Serializable)((Object)changeSetId));
    }

    public String getChangeSetId(String campaignId) {
        String key = CHANGE_SET_ID_PREFIX + campaignId;
        return (String)this.storage.get(key);
    }

    public String getUserIdSyncedWithBackend() {
        String returnValue = (String)this.storage.get(KEY_SYNCED_USER_ID);
        if (returnValue == null) {
            returnValue = (String)((Object)this.backupStorage.getValue(KEY_SYNCED_USER_ID));
        }
        return returnValue;
    }

    public void setUserIdSyncedWithBackend(String uid) {
        this.storage.set(KEY_SYNCED_USER_ID, (Serializable)((Object)uid));
        this.backupStorage.storeValue(KEY_SYNCED_USER_ID, (Serializable)((Object)uid));
    }

    private void updateBackupStorageWithInternalStorage() {
        String syncUserID;
        String deviceId = (String)this.storage.get(KEY_DEVICE_ID);
        if (deviceId != null) {
            this.backupStorage.storeValue(KEY_DEVICE_ID, (Serializable)((Object)deviceId));
        }
        if ((syncUserID = (String)this.storage.get(KEY_SYNCED_USER_ID)) != null) {
            this.backupStorage.storeValue(KEY_SYNCED_USER_ID, (Serializable)((Object)syncUserID));
        }
    }

    public boolean isDuplicateNotification(String changeSetId, String userIdentifier) {
        HashSet<String> receivedNotifications;
        String receivedPushCampaignsKey = "hs__received_push_campaigns";
        HashMap notificationMappingForAllUsers = (HashMap)this.storage.get(receivedPushCampaignsKey);
        if (notificationMappingForAllUsers == null) {
            notificationMappingForAllUsers = new HashMap();
        }
        if ((receivedNotifications = (HashSet<String>)notificationMappingForAllUsers.get(userIdentifier)) == null) {
            receivedNotifications = new HashSet<String>();
        }
        if (receivedNotifications.contains(changeSetId)) {
            return true;
        }
        receivedNotifications.add(changeSetId);
        notificationMappingForAllUsers.put(userIdentifier, receivedNotifications);
        this.storage.set(receivedPushCampaignsKey, notificationMappingForAllUsers);
        return false;
    }
}

