/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network;

import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.exceptions.InstallException;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.network.Header;
import com.helpshift.network.HttpEntity;
import com.helpshift.network.HttpResponse;
import com.helpshift.network.HttpStack;
import com.helpshift.network.Network;
import com.helpshift.network.StatusLine;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.util.ByteArrayPool;
import com.helpshift.network.util.PoolingByteArrayOutputStream;
import com.helpshift.util.HSLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.TreeMap;

public class BasicNetwork
implements Network {
    private static final String TAG = "Helpshift_BasicNetwork";
    protected final HttpStack httpStack;
    protected final ByteArrayPool pool;

    public BasicNetwork(HttpStack httpStack) {
        this.httpStack = httpStack;
        this.pool = new ByteArrayPool(NetworkConstants.DEFAULT_POOL_SIZE);
    }

    protected static Map<String, String> convertHeaders(Header[] headers) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            result.put(header.name, header.value);
        }
        return result;
    }

    @Override
    public NetworkResponse performRequest(Request request) throws NetworkError {
        while (true) {
            HttpResponse httpResponse = null;
            try {
                byte[] responseContents;
                httpResponse = this.httpStack.performRequest(request);
                StatusLine statusLine = httpResponse.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                Map<String, String> responseHeaders = BasicNetwork.convertHeaders(httpResponse.getAllHeaders());
                if (responseHeaders != null && responseHeaders.containsKey("ETag")) {
                    InfoModelFactory.getInstance().sdkInfoModel.addEtag(responseHeaders.get("ETag"), request.url);
                }
                if (statusCode == 304) {
                    NetworkResponse networkResponse = new NetworkResponse(304, null, responseHeaders, true, request.getSequence());
                    return networkResponse;
                }
                if (httpResponse.getEntity() != null) {
                    responseContents = this.entityToBytes(httpResponse.getEntity());
                } else if (request.method == 0) {
                    responseContents = new byte[]{};
                } else {
                    throw new NetworkError(NetworkErrorCodes.CONTENT_NOT_FOUND);
                }
                if (statusCode >= 200 && statusCode <= 300) {
                    NetworkResponse networkResponse = new NetworkResponse(statusCode, responseContents, responseHeaders, false, request.getSequence());
                    return networkResponse;
                }
                if (statusCode == 422) {
                    for (Map.Entry<String, String> pair : responseHeaders.entrySet()) {
                        if (!pair.getKey().equals("HS-UEpoch")) continue;
                        InfoModelFactory.getInstance().sdkInfoModel.setServerTimeDelta(Float.valueOf(HSDateFormatSpec.calculateTimeDelta(pair.getValue())));
                        break;
                    }
                    throw new NetworkError(NetworkErrorCodes.TIMESTAMP_MISMATCH);
                }
                if (statusCode == 413) {
                    throw new NetworkError(NetworkErrorCodes.ENTITY_TOO_LARGE);
                }
                if (statusCode == 403 || statusCode == 401) {
                    throw new NetworkError(NetworkErrorCodes.UNAUTHORIZED_ACCESS);
                }
                if (statusCode >= 400 && statusCode < 500) {
                    throw new NetworkError(statusCode);
                }
                if (statusCode < 500) continue;
                throw new NetworkError(NetworkErrorCodes.SERVER_ERROR);
            }
            catch (SocketTimeoutException e) {
                throw new NetworkError(NetworkErrorCodes.REQUEST_TIMEOUT);
            }
            catch (MalformedURLException e) {
                throw new NetworkError("Bad URL " + request.url, (Throwable)e);
            }
            catch (InstallException e) {
                throw new NetworkError(e);
            }
            catch (SecurityException e) {
                throw new NetworkError(NetworkErrorCodes.NO_CONNECTION);
            }
            catch (IOException e) {
                if (httpResponse == null) {
                    throw new NetworkError(NetworkErrorCodes.NO_CONNECTION, e.getMessage());
                }
                throw new NetworkError(e);
            }
            finally {
                if (httpResponse == null || httpResponse.getHelpshiftSSLSocketFactory() == null) continue;
                httpResponse.getHelpshiftSSLSocketFactory().closeSockets();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] entityToBytes(HttpEntity entity) throws IOException, NetworkError {
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(this.pool, (int)entity.contentLength);
        byte[] buffer = null;
        try {
            int count;
            InputStream in = entity.content;
            if (in == null) {
                throw new NetworkError(NetworkErrorCodes.SERVER_ERROR);
            }
            buffer = this.pool.getBuf(1024);
            while ((count = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            try {
                entity.consumeContent();
            }
            catch (IOException e) {
                HSLogger.w(TAG, "Error occurred when calling consumingContent", e);
            }
            this.pool.returnBuf(buffer);
            bytes.close();
        }
    }
}

