/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.helpshift.util.HSLogger;
import java.util.HashSet;
import java.util.Set;

public class HSNetworkConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = "Helpshift_NetStateRcv";
    protected Set<HSNetworkConnectivityListener> listeners = new HashSet<HSNetworkConnectivityListener>();
    private Context context;

    public HSNetworkConnectivityReceiver(Context context) {
        this.context = context;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null || intent.getExtras() == null) {
            return;
        }
        Boolean isConnected = this.isConnected();
        if (isConnected != null) {
            this.notifyStateToAll(isConnected);
        }
    }

    private void notifyStateToAll(boolean isConnected) {
        for (HSNetworkConnectivityListener listener : this.listeners) {
            this.notifyState(listener, isConnected);
        }
    }

    private void notifyState(HSNetworkConnectivityListener listener, boolean isConnected) {
        if (isConnected) {
            listener.networkAvailable();
        } else {
            listener.networkUnavailable();
        }
    }

    public void addListener(HSNetworkConnectivityListener l) {
        this.listeners.add(l);
        Boolean isConnected = this.isConnected();
        if (isConnected != null) {
            this.notifyState(l, isConnected);
        }
    }

    public void removeListener(HSNetworkConnectivityListener l) {
        this.listeners.remove(l);
    }

    private Boolean isConnected() {
        Boolean isConnected = null;
        try {
            ConnectivityManager manager = (ConnectivityManager)this.context.getSystemService("connectivity");
            if (manager != null) {
                NetworkInfo ni = manager.getActiveNetworkInfo();
                isConnected = ni != null && ni.isConnectedOrConnecting() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error in network state receiver.", e);
        }
        return isConnected;
    }

    public static interface HSNetworkConnectivityListener {
        public void networkAvailable();

        public void networkUnavailable();
    }
}

