/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.request;

import android.net.Uri;
import android.text.TextUtils;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.exceptions.InstallException;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.network.NameValuePair;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseParser;
import com.helpshift.network.util.HeaderUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.StringUtil;
import com.helpshift.util.TimeUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Request {
    private static final String TAG = "HS_Request";
    private static AtomicInteger sequenceGenerator = new AtomicInteger();
    public final int method;
    public final String url;
    private final Response.ErrorListener errorListener;
    private Integer sequence;
    private boolean responseDelivered = false;
    private Map<String, String> requestData;
    private Response.Listener listener;
    private ResponseParser responseParser;

    public <T> Request(int method, String url, Map<String, String> requestData, Response.Listener<T> listener, Response.ErrorListener errorListener, ResponseParser<T> responseParser) {
        this.method = method;
        this.url = this.sanitiseUrl(url);
        this.listener = listener;
        this.errorListener = errorListener;
        this.requestData = requestData;
        this.sequence = sequenceGenerator.incrementAndGet();
        this.responseParser = responseParser;
    }

    public Map<String, String> getRequestData() {
        return this.requestData;
    }

    private String sanitiseUrl(String url) {
        String sanitisedUrl = url;
        if (!url.startsWith("/")) {
            sanitisedUrl = "/" + url;
        }
        return sanitisedUrl;
    }

    public String getMethodString() {
        switch (this.method) {
            case 0: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
        }
        return "";
    }

    public int getSequence() {
        if (this.sequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.sequence;
    }

    public Map<String, String> getHeaders() {
        Map<String, String> headers = HeaderUtil.getCommonHeaders();
        if (this.method == 0) {
            String etag = InfoModelFactory.getInstance().sdkInfoModel.getEtag(this.url);
            if (!TextUtils.isEmpty((CharSequence)etag)) {
                headers.put("If-None-Match", etag);
            }
        } else if (this.method == 1) {
            headers.put("Content-type", "application/x-www-form-urlencoded");
        }
        return headers;
    }

    private String getApiUri() {
        return "/api/lib/3" + this.url;
    }

    public String getFullUri() throws InstallException {
        if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            throw new InstallException("Install information missing");
        }
        return NetworkConstants.scheme + InfoModelFactory.getInstance().appInfoModel.domainName + this.getApiUri();
    }

    public URL getParsedURL() throws InstallException, MalformedURLException {
        String url = this.getFullUri();
        if (this.method == 0) {
            url = url + "?" + this.encodeGetParameters(this.addAuth());
        }
        return new URL(url);
    }

    private Map<String, String> addAuth() throws InstallException {
        String uriStr = this.getApiUri();
        HashMap<Object, Object> data = this.requestData != null ? new HashMap<String, String>(this.requestData) : new HashMap();
        if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            throw new InstallException("appId Missing");
        }
        data.put("platform-id", InfoModelFactory.getInstance().appInfoModel.platformId);
        data.put("method", this.getMethodString());
        data.put("uri", uriStr);
        String ts = TimeUtil.getCurrentTimestamp();
        if (SchemaUtil.validateTimestamp(ts)) {
            data.put("timestamp", ts);
        }
        ArrayList mapKeys = new ArrayList(data.keySet());
        ArrayList<String> dataList = new ArrayList<String>();
        Collections.sort(mapKeys);
        for (String key : mapKeys) {
            String dataString;
            if (key.equals("screenshot") || key.equals("meta") || (dataString = StringUtil.toString(data.get(key))) == null) continue;
            dataList.add(key + "=" + dataString);
        }
        try {
            String key = InfoModelFactory.getInstance().appInfoModel.apiKey;
            if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
                throw new InstallException("Install information missing");
            }
            String signature = HelpshiftContext.getCoreApi().getCryptoDM().getSignature(TextUtils.join((CharSequence)"&", dataList), key);
            data.put("signature", signature);
            data.remove("method");
            data.remove("uri");
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return data;
    }

    private String encodeGetParameters(Map<String, String> inputParams) {
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<String> mapKeys = new ArrayList<String>(inputParams.keySet());
        for (String key : mapKeys) {
            dataList.add(key + "=" + Uri.encode((String)inputParams.get(key)));
        }
        return TextUtils.join((CharSequence)"&", dataList);
    }

    private List<NameValuePair> encodePostParameters(Map<String, String> inputParams) {
        ArrayList<String> mapKeys = new ArrayList<String>(inputParams.keySet());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(mapKeys.size());
        for (String key : mapKeys) {
            String dataString = StringUtil.toString(inputParams.get(key));
            if (dataString == null) continue;
            params.add(new NameValuePair(key, dataString));
        }
        return params;
    }

    public String getPOSTParametersQuery() throws InstallException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        List<NameValuePair> params = this.encodePostParameters(this.addAuth());
        for (NameValuePair pair : params) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            try {
                result.append(URLEncoder.encode(pair.name, "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                HSLogger.w(TAG, "Exception Unsupported Encoding", e);
            }
        }
        return result.toString();
    }

    public void markDelivered() {
        this.responseDelivered = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.responseDelivered;
    }

    protected <T> Response<T> parseNetworkResponse(NetworkResponse response) {
        ResponseParser typedParser = this.responseParser;
        return typedParser.parseResponse(response);
    }

    protected NetworkError parseNetworkError(NetworkError networkError) {
        return networkError;
    }

    public <T> void deliverResponse(T response) {
        Response.Listener typedListener = this.listener;
        typedListener.onResponse(response, this.getSequence());
    }

    public void deliverError(NetworkError error) {
        if (this.errorListener != null) {
            this.errorListener.onErrorResponse(error, this.getSequence());
        }
    }

    public boolean isDoOutput() {
        return this.method == 1;
    }

    public String toString() {
        return this.url + " " + TAG + "  " + this.sequence;
    }

    public static interface Method {
        public static final int GET = 0;
        public static final int POST = 1;
    }
}

