/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.response;

import com.helpshift.network.errors.NetworkError;

public class Response<T> {
    public final T result;
    public final NetworkError error;

    private Response(T result, Integer requestIdentifier) {
        this.result = result;
        this.error = null;
    }

    private Response(NetworkError error, Integer requestIdentifier) {
        this.result = null;
        this.error = error;
    }

    public static <T> Response<T> success(T result, Integer requestIdentifier) {
        return new Response<T>(result, requestIdentifier);
    }

    public static <T> Response<T> error(NetworkError error, Integer requestIdentifier) {
        return new Response<T>(error, requestIdentifier);
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public static interface ErrorListener {
        public void onErrorResponse(NetworkError var1, Integer var2);
    }

    public static interface Listener<T> {
        public void onResponse(T var1, Integer var2);
    }
}

