/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.platform.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.common.conversation.ConversationDBInfo;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.util.HSLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConversationDBHelper
extends SQLiteOpenHelper {
    private static final String TAG = "Helpshift_ConversationDB";
    private final ConversationDBInfo dbInfo;

    public ConversationDBHelper(Context context, ConversationDBInfo dbInfo) {
        super(context, "__hs__db_issues", null, ConversationDBInfo.DATABASE_VERSION.intValue());
        this.dbInfo = dbInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(SQLiteDatabase db) {
        if (db.isOpen()) {
            try {
                List<String> queries = this.dbInfo.getQueriesForOnCreate();
                db.beginTransaction();
                for (String query : queries) {
                    db.execSQL(query);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.f(TAG, "Exception while creating tables: version: " + ConversationDBInfo.DATABASE_VERSION, ex, new ILogExtrasModel[0]);
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.f(TAG, "Error in onCreate inside finally block, ", e, new ILogExtrasModel[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.isOpen()) {
            try {
                List<String> queries = this.dbInfo.getQueriesForOnUpgrade(oldVersion);
                db.beginTransaction();
                for (String query : queries) {
                    db.execSQL(query);
                }
                this.migrateDataOnConversationDBUpgrade(db, oldVersion);
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.f(TAG, "Exception while migrating conversationDB, old: " + oldVersion + ", new: " + newVersion, ex, new ILogExtrasModel[0]);
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.f(TAG, "Exception while migrating conversationDB inside finally block, ", e, new ILogExtrasModel[0]);
                }
            }
        }
    }

    private void migrateDataOnConversationDBUpgrade(SQLiteDatabase db, int oldVersion) {
        if (oldVersion == 6) {
            String[] selectionArgs;
            String selection;
            ContentValues contentValue;
            HashMap<Long, String> conversationLocalIDToCreateAtMap = new HashMap<Long, String>();
            String[] columnName = new String[]{String.valueOf(this.dbInfo.ID), this.dbInfo.CREATED_AT};
            Cursor cursor = db.query(this.dbInfo.TABLE_CONVERSATIONS, columnName, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
                    String createAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
                    conversationLocalIDToCreateAtMap.put(localId, createAt);
                } while (cursor.moveToNext());
            }
            cursor.close();
            HashMap<Long, String> messagesLocalIDToCreateAtMap = new HashMap<Long, String>();
            cursor = db.query(this.dbInfo.TABLE_MESSAGES, columnName, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
                    String string2 = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
                    messagesLocalIDToCreateAtMap.put(localId, string2);
                } while (cursor.moveToNext());
            }
            cursor.close();
            HashMap conversationLocalIDToEpochCreateAtMap = new HashMap();
            for (Map.Entry entry : conversationLocalIDToCreateAtMap.entrySet()) {
                String createdAt = (String)entry.getValue();
                long epochCreatedAt = HSDateFormatSpec.convertToEpochTime(createdAt);
                conversationLocalIDToEpochCreateAtMap.put(entry.getKey(), epochCreatedAt);
            }
            HashMap messagesLocalIDToEpochCreateAtMap = new HashMap();
            for (Map.Entry entry : messagesLocalIDToCreateAtMap.entrySet()) {
                String createdAt = (String)entry.getValue();
                long epochCreatedAt = HSDateFormatSpec.convertToEpochTime(createdAt);
                messagesLocalIDToEpochCreateAtMap.put(entry.getKey(), epochCreatedAt);
            }
            for (Map.Entry entry : conversationLocalIDToEpochCreateAtMap.entrySet()) {
                Long localID = (Long)entry.getKey();
                Long epochCreatedAt = (Long)entry.getValue();
                contentValue = new ContentValues();
                contentValue.put(this.dbInfo.EPOCH_TIME_CREATE_AT, epochCreatedAt);
                selection = this.dbInfo.ID + " = ?";
                selectionArgs = new String[]{String.valueOf(localID)};
                db.update(this.dbInfo.TABLE_CONVERSATIONS, contentValue, selection, selectionArgs);
            }
            for (Map.Entry entry : messagesLocalIDToEpochCreateAtMap.entrySet()) {
                Long localID = (Long)entry.getKey();
                Long epochCreatedAt = (Long)entry.getValue();
                contentValue = new ContentValues();
                contentValue.put(this.dbInfo.EPOCH_TIME_CREATE_AT, epochCreatedAt);
                selection = this.dbInfo.ID + " = ?";
                selectionArgs = new String[]{String.valueOf(localID)};
                db.update(this.dbInfo.TABLE_MESSAGES, contentValue, selection, selectionArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndCreateDatabase(SQLiteDatabase db) {
        if (db.isOpen()) {
            try {
                List<String> queries = this.dbInfo.getQueriesForDropAndCreate();
                db.beginTransaction();
                for (String query : queries) {
                    db.execSQL(query);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception ex) {
                HSLogger.f(TAG, "Exception while upgrading tables, version: " + ConversationDBInfo.DATABASE_VERSION, ex, new ILogExtrasModel[0]);
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.f(TAG, "Error in dropAndCreateDatabase inside finally block, ", e, new ILogExtrasModel[0]);
                }
            }
        }
    }
}

