/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.poller;

import android.support.annotation.Nullable;
import com.helpshift.common.poller.Delay;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.util.HSLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class Poller<V>
implements Runnable {
    private static final String TAG = "Helpshift_Poller";
    private final Callable<V> callable;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private boolean started;

    public Poller(Callable<V> callable, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService) {
        this.callable = callable;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void shutdown() {
        this.started = false;
        this.scheduledExecutorService.shutdownNow();
        this.executorService.shutdownNow();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            try {
                this.executorService.execute(this);
            }
            catch (RejectedExecutionException e) {
                HSLogger.e(TAG, "Rejected execution : ", e);
            }
        }
    }

    @Override
    public void run() {
        this.runDelayed(0L, TimeUnit.SECONDS);
    }

    @Nullable
    public abstract Delay getSuccessDelay(V var1);

    @Nullable
    public abstract Delay getFailDelay(Exception var1);

    void runDelayed(long delay, TimeUnit timeUnit) {
        block6: {
            try {
                Delay nextDelay;
                if (!this.started || this.scheduledExecutorService.isShutdown()) break block6;
                ScheduledFuture<V> future = this.scheduledExecutorService.schedule(this.callable, delay, timeUnit);
                try {
                    nextDelay = this.getSuccessDelay(future.get());
                }
                catch (Exception e) {
                    nextDelay = e.getCause() instanceof NetworkError ? this.getFailDelay((NetworkError)e.getCause()) : this.getFailDelay(e);
                }
                if (nextDelay == null || this.executorService.isShutdown()) {
                    this.started = false;
                } else {
                    final Delay derivedInterval = nextDelay;
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            Poller.this.runDelayed(derivedInterval.delay, derivedInterval.timeUnit);
                        }
                    });
                }
            }
            catch (RejectedExecutionException e) {
                HSLogger.e(TAG, "Rejected execution of run delayed : ", e);
            }
        }
    }
}

