/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.redaction;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.redaction.RedactionDAO;
import com.helpshift.redaction.RedactionDetail;
import com.helpshift.redaction.RedactionState;
import com.helpshift.redaction.RedactionType;

public class RedactionAgent {
    private Platform platform;
    private Domain domain;

    public RedactionAgent(Platform platform, Domain domain) {
        this.platform = platform;
        this.domain = domain;
    }

    public void checkAndUpdateRedactionState(UserDM userDM, Long profileCreatedAt, Long lastRedactionAt) {
        ConversationInboxManagerDM conversationInboxManagerDM = this.domain.getConversationInboxManagerDM();
        ConversationInboxDM conversationInboxDM = conversationInboxManagerDM.getConversationInboxDM(userDM);
        Long oldestConversationCreatedAtTime = conversationInboxDM.getOldestConversationCreatedAtTime();
        boolean isUserRedacted = this.isUserRedacted(profileCreatedAt, oldestConversationCreatedAtTime);
        if (isUserRedacted) {
            this.updateRedaction(userDM, RedactionType.USER);
        } else {
            Long localLastRedactionAtTime = conversationInboxDM.getLastConversationsRedactionTime();
            boolean isConversationRedacted = this.isConversationRedacted(lastRedactionAt, localLastRedactionAtTime);
            if (isConversationRedacted) {
                this.updateRedaction(userDM, RedactionType.CONVERSATION);
            }
        }
        if (lastRedactionAt != null) {
            conversationInboxDM.saveLastConversationsRedactionTime(lastRedactionAt);
        }
    }

    private void updateRedaction(UserDM userDM, RedactionType redactionType) {
        RedactionDetail redactionDetail = new RedactionDetail(userDM.getLocalId(), RedactionState.PENDING, redactionType);
        RedactionDAO redactionDAO = this.platform.getRedactionDAO();
        RedactionDetail localRedactionDetail = redactionDAO.getRedactionDetail(userDM.getLocalId());
        if (localRedactionDetail == null) {
            redactionDAO.insertRedactionDetail(redactionDetail);
        } else {
            redactionDAO.updateRedactionRedail(redactionDetail);
        }
    }

    private boolean isUserRedacted(Long profileCreatedAt, Long oldestConversationCreatedAt) {
        boolean isUserRedacted = false;
        if (oldestConversationCreatedAt == null) {
            isUserRedacted = false;
        } else if (profileCreatedAt == null) {
            isUserRedacted = true;
        } else if (profileCreatedAt > oldestConversationCreatedAt) {
            isUserRedacted = true;
        }
        return isUserRedacted;
    }

    private boolean isConversationRedacted(Long serverLastRedactionAt, Long localLastRedactionAt) {
        boolean isConversationRedacted = false;
        if (serverLastRedactionAt == null) {
            isConversationRedacted = false;
        } else if (localLastRedactionAt == null) {
            isConversationRedacted = true;
        } else if (localLastRedactionAt < serverLastRedactionAt) {
            isConversationRedacted = true;
        }
        return isConversationRedacted;
    }
}

