/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.redaction;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.redaction.RedactionDAO;
import com.helpshift.redaction.RedactionDetail;
import com.helpshift.redaction.RedactionState;
import java.lang.ref.WeakReference;

public class RedactionManager {
    private Domain domain;
    private UserDM userDM;
    private RedactionDAO redactionDAO;
    private WeakReference<RedactionManagerListener> redactionManagerListener;

    public RedactionManager(Platform platform, Domain domain, UserDM userDM, RedactionManagerListener listener) {
        this.domain = domain;
        this.userDM = userDM;
        this.redactionManagerListener = new WeakReference<RedactionManagerListener>(listener);
        this.redactionDAO = platform.getRedactionDAO();
    }

    public synchronized void executeRedaction() {
        RedactionState redactionState = this.getRedactionState();
        if (redactionState != RedactionState.PENDING) {
            return;
        }
        this.updateUserRedactionState(redactionState, RedactionState.IN_PROGRESS);
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationInboxManagerDM conversationInboxManagerDM = RedactionManager.this.domain.getConversationInboxManagerDM();
                ConversationInboxDM conversationInboxDM = conversationInboxManagerDM.getConversationInboxDM(RedactionManager.this.userDM);
                conversationInboxDM.getConversationInboxPoller().stop();
                conversationInboxDM.redactConversations();
                RedactionManager.this.domain.getUserManagerDM().resetSyncState(RedactionManager.this.userDM);
                RedactionManager.this.updateUserRedactionState(RedactionState.IN_PROGRESS, RedactionState.COMPLETED);
            }
        });
    }

    public RedactionState getRedactionState() {
        RedactionDetail redactionDetail = this.redactionDAO.getRedactionDetail(this.userDM.getLocalId());
        if (redactionDetail == null) {
            return RedactionState.COMPLETED;
        }
        return redactionDetail.redactionState;
    }

    public void setAppropriateInitialState() {
        RedactionState redactionState = this.getRedactionState();
        if (redactionState == RedactionState.IN_PROGRESS) {
            this.updateUserRedactionState(redactionState, RedactionState.PENDING);
        }
    }

    private void updateUserRedactionState(final RedactionState oldState, final RedactionState newState) {
        if (newState == RedactionState.COMPLETED) {
            this.redactionDAO.deleteRedactionDetail(this.userDM.getLocalId());
        } else {
            this.redactionDAO.updateRedactionState(this.userDM.getLocalId(), newState);
        }
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                RedactionManagerListener listener = (RedactionManagerListener)RedactionManager.this.redactionManagerListener.get();
                if (listener != null) {
                    listener.redactionStateChanged(RedactionManager.this.userDM, oldState, newState);
                }
            }
        });
    }

    public static interface RedactionManagerListener {
        public void redactionStateChanged(UserDM var1, RedactionState var2, RedactionState var3);
    }
}

