/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.specifications;

import android.annotation.TargetApi;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.specifications.SyncSpecification;
import java.util.concurrent.TimeUnit;

public class DailyFrequencyBasedSyncSpecification
implements SyncSpecification {
    private final long elapsedTimeThreshold;
    private final String dataType;

    @TargetApi(value=9)
    public DailyFrequencyBasedSyncSpecification(int dailyFrequency, String dataType) {
        this.elapsedTimeThreshold = TimeUnit.MILLISECONDS.convert(24 / dailyFrequency, TimeUnit.HOURS);
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isSatisfied(int dataChangeCount, long elapsedTimeSinceSync) {
        boolean result = false;
        elapsedTimeSinceSync = Math.abs(elapsedTimeSinceSync);
        Boolean syncImmediately = InfoModelFactory.getInstance().sdkInfoModel.getDevicePropertiesSyncImmediately();
        if (syncImmediately.booleanValue() || dataChangeCount > 0 && elapsedTimeSinceSync > this.elapsedTimeThreshold) {
            result = true;
        }
        return result;
    }
}

