/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.specifications;

import com.helpshift.specifications.SyncSpecification;
import java.util.concurrent.TimeUnit;

public class GenericSyncSpecification
implements SyncSpecification {
    private final int dataChangeThreshold;
    private final long elapsedTimeThreshold;
    private final String dataType;

    public GenericSyncSpecification(int dataChangeThreshold, long elapsedTimeThreshold, TimeUnit timeUnit, String dataType) {
        this.dataChangeThreshold = dataChangeThreshold;
        this.elapsedTimeThreshold = TimeUnit.MILLISECONDS.convert(elapsedTimeThreshold, timeUnit);
        this.dataType = dataType;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isSatisfied(int dataChangeCount, long elapsedTimeSinceSync) {
        boolean result = false;
        elapsedTimeSinceSync = Math.abs(elapsedTimeSinceSync);
        if (dataChangeCount >= this.dataChangeThreshold || elapsedTimeSinceSync > this.elapsedTimeThreshold) {
            result = true;
        }
        return result;
    }
}

