/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSLogger;
import java.io.Serializable;
import java.util.Map;

public abstract class BaseRetryKeyValueStorage
implements KeyValueStorage {
    protected static final String TAG = "Helpshift_RetryKeyValue";
    private static final int MAX_RETRY_COUNT = 1;
    protected KeyValueStorage keyValueStorage;

    @Override
    public synchronized boolean set(String key, Serializable value) {
        int retryCount = 0;
        while (true) {
            try {
                return this.keyValueStorage.set(key, value);
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    HSLogger.e(TAG, "Exception in setting value for key : " + key + ", retry count : " + retryCount, e);
                } else {
                    HSLogger.f(TAG, "Exception in setting value for key : " + key + ", retry count : " + retryCount, e, new ILogExtrasModel[0]);
                }
                this.reInitiateDbInstance();
                if (++retryCount <= 1) continue;
                return false;
            }
            break;
        }
    }

    @Override
    public synchronized boolean setKeyValues(Map<String, Serializable> keyValues) {
        int retryCount = 0;
        while (true) {
            try {
                return this.keyValueStorage.setKeyValues(keyValues);
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    HSLogger.e(TAG, "Exception in bulk insert, retry count : " + retryCount, e);
                } else {
                    HSLogger.f(TAG, "Exception in bulk insert, retry count : " + retryCount, e, new ILogExtrasModel[0]);
                }
                this.reInitiateDbInstance();
                if (++retryCount <= 1) continue;
                return false;
            }
            break;
        }
    }

    @Override
    public synchronized Object get(String key) {
        int retryCount = 0;
        while (true) {
            try {
                return this.keyValueStorage.get(key);
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    HSLogger.e(TAG, "Exception getting value for : " + key + ", retry count : " + retryCount, e);
                } else {
                    HSLogger.f(TAG, "Exception getting value for : " + key + ", retry count : " + retryCount, e, new ILogExtrasModel[0]);
                }
                this.reInitiateDbInstance();
                if (++retryCount <= 1) continue;
                return null;
            }
            break;
        }
    }

    @Override
    public synchronized void removeKey(String key) {
        int retryCount = 0;
        while (true) {
            try {
                this.keyValueStorage.removeKey(key);
                return;
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    HSLogger.e(TAG, "Exception removing key : " + key + ", retry count : " + retryCount, e);
                } else {
                    HSLogger.f(TAG, "Exception removing key : " + key + ", retry count : " + retryCount, e, new ILogExtrasModel[0]);
                }
                this.reInitiateDbInstance();
                if (++retryCount <= 1) continue;
                return;
            }
            break;
        }
    }

    @Override
    public synchronized void removeAllKeys() {
        int retryCount = 0;
        while (true) {
            try {
                this.keyValueStorage.removeAllKeys();
                return;
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    HSLogger.e(TAG, "Exception removing all keys, retry count : " + retryCount, e);
                } else {
                    HSLogger.f(TAG, "Exception removing all keys, retry count : " + retryCount, e, new ILogExtrasModel[0]);
                }
                this.reInitiateDbInstance();
                if (++retryCount <= 1) continue;
                return;
            }
            break;
        }
    }

    protected abstract void reInitiateDbInstance();
}

