/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import com.helpshift.storage.KeyValueStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CachedKeyValueStorage
implements KeyValueStorage {
    private HashMap<String, Object> cacheMap;
    private Set<String> cacheWhitelistKeys;
    private KeyValueStorage storage;

    public CachedKeyValueStorage(KeyValueStorage storage, Set<String> cacheWhitelistKeys) {
        this.storage = storage;
        this.cacheWhitelistKeys = new HashSet<String>(cacheWhitelistKeys);
        this.cacheMap = new HashMap();
    }

    @Override
    public synchronized boolean set(String key, Serializable value) {
        this.cacheMap.remove(key);
        boolean isSetSuccessful = this.storage.set(key, value);
        if (isSetSuccessful) {
            this.setInCache(key, value);
        }
        return isSetSuccessful;
    }

    @Override
    public boolean setKeyValues(Map<String, Serializable> keyValues) {
        this.removeFromCache(keyValues.keySet());
        boolean isSetSuccessful = this.storage.setKeyValues(keyValues);
        if (isSetSuccessful) {
            this.setInCache(keyValues);
        }
        return isSetSuccessful;
    }

    @Override
    public synchronized Object get(String key) {
        if (this.cacheMap.containsKey(key)) {
            return this.cacheMap.get(key);
        }
        Object value = this.storage.get(key);
        this.setInCache(key, value);
        return value;
    }

    @Override
    public synchronized void removeKey(String key) {
        this.storage.removeKey(key);
        this.cacheMap.remove(key);
    }

    @Override
    public synchronized void removeAllKeys() {
        this.storage.removeAllKeys();
        this.cacheMap.clear();
    }

    private void setInCache(String key, Object value) {
        if (this.cacheWhitelistKeys.contains(key)) {
            this.cacheMap.put(key, value);
        }
    }

    private void setInCache(Map<String, Serializable> keyValues) {
        if (keyValues != null) {
            for (Map.Entry<String, Serializable> entry : keyValues.entrySet()) {
                if (!this.cacheWhitelistKeys.contains(entry.getKey())) continue;
                this.cacheMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void removeFromCache(Set<String> keys) {
        if (keys != null) {
            for (String key : keys) {
                this.cacheMap.remove(key);
            }
        }
    }
}

