/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KeyValueDbStorage
implements KeyValueStorage {
    private static final String TAG = "HS_KeyValueDB";
    private SQLiteOpenHelper helper;
    private HashMap<String, Serializable> backupData;
    private String backupFileName;

    public KeyValueDbStorage(SQLiteOpenHelper helper, String backupFileName) {
        this.helper = helper;
        this.backupFileName = backupFileName;
    }

    @Override
    public boolean set(String key, Serializable value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return false;
        }
        SQLiteDatabase db = this.helper.getWritableDatabase();
        String whereClause = "key=?";
        String[] whereArgs = new String[]{key};
        ContentValues values = new ContentValues();
        values.put("key", key);
        try {
            values.put("value", ByteArrayUtil.toByteArray(value));
        }
        catch (IOException e) {
            HSLogger.e(TAG, "Error in serializing value", e);
            return false;
        }
        if (DatabaseUtils.exists(db, "key_value_store", whereClause, whereArgs)) {
            db.update("key_value_store", values, whereClause, whereArgs);
        } else {
            long result = db.insert("key_value_store", null, values);
            if (result == -1L) {
                throw new SQLiteException("DB insert failed and return -1");
            }
        }
        return true;
    }

    @Override
    public boolean setKeyValues(Map<String, Serializable> keyValues) {
        if (keyValues == null || keyValues.size() == 0) {
            return false;
        }
        SQLiteDatabase db = this.helper.getWritableDatabase();
        String whereClause = "key=?";
        SQLiteStatement insertStatement = db.compileStatement("INSERT INTO key_value_store VALUES (?,?)");
        SQLiteStatement updateStatement = db.compileStatement("UPDATE key_value_store SET value = ? WHERE key = ?");
        db.beginTransaction();
        for (Map.Entry<String, Serializable> entry : keyValues.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            try {
                String[] whereArgs = new String[]{entry.getKey()};
                byte[] valueByteArray = ByteArrayUtil.toByteArray(entry.getValue());
                if (DatabaseUtils.exists(db, "key_value_store", whereClause, whereArgs)) {
                    updateStatement.bindString(2, entry.getKey());
                    updateStatement.bindBlob(1, valueByteArray);
                    updateStatement.execute();
                    updateStatement.clearBindings();
                    continue;
                }
                insertStatement.bindString(1, entry.getKey());
                insertStatement.bindBlob(2, valueByteArray);
                insertStatement.execute();
                insertStatement.clearBindings();
            }
            catch (IOException e) {
                HSLogger.e(TAG, "Error in serializing value", e);
            }
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        Object value = null;
        try (Cursor cursor = null;){
            SQLiteDatabase db = this.helper.getReadableDatabase();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            cursor = db.query("key_value_store", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                try {
                    value = ByteArrayUtil.toObject(cursor.getBlob(1));
                }
                catch (Exception exception) {
                    value = null;
                }
            }
        }
        return value;
    }

    @Override
    public void removeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        SQLiteDatabase db = this.helper.getWritableDatabase();
        String whereClause = "key=?";
        String[] whereArgs = new String[]{key};
        db.delete("key_value_store", whereClause, whereArgs);
    }

    @Override
    public void removeAllKeys() {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.delete("key_value_store", null, null);
    }
}

