/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import android.support.annotation.NonNull;
import com.helpshift.storage.CachedKeyValueStorage;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.storage.RetryKeyValueDbStorage;
import com.helpshift.util.HelpshiftContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StorageFactory {
    private static StorageFactory storageFactoryInstance;
    public final KeyValueStorage keyValueStorage;

    StorageFactory() {
        RetryKeyValueDbStorage storage = new RetryKeyValueDbStorage(HelpshiftContext.getApplicationContext());
        this.keyValueStorage = new CachedKeyValueStorage(storage, this.getCacheWhitelistKeys());
    }

    public static synchronized StorageFactory getInstance() {
        if (storageFactoryInstance == null) {
            storageFactoryInstance = new StorageFactory();
        }
        return storageFactoryInstance;
    }

    @NonNull
    private Set<String> getCacheWhitelistKeys() {
        return new HashSet<String>(Arrays.asList("firstDeviceSyncComplete", "hs__campaigns_icon_image_retry_counts", "sdk-language", "disableHelpshiftBranding", "screenOrientation", "data_type_device", "data_type_user", "data_type_session", "data_type_switch_user", "data_type_analytics_event", "__hs_switch_current_user", "__hs_switch_prev_user"));
    }
}

