/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.Metadata;
import com.helpshift.support.Support;
import com.helpshift.support.flows.Flow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiConfig {
    private final Integer enableContactUs;
    private final boolean gotoConversationAfterContactUs;
    private final boolean requireEmail;
    private final boolean hideNameAndEmail;
    private final String conversationPrefillText;
    private final boolean enableFullPrivacy;
    private final boolean showSearchOnNewConversation;
    private final boolean showConversationResolutionQuestion;
    private final List<Flow> customContactUsFlows;
    private final FaqTagFilter withTagsMatching;
    private final Metadata customMetadata;
    private final int toolbarId;
    private final boolean showConversationInfoScreen;
    private final boolean enableTypingIndicator;
    private final Map<String, String[]> customIssueFields;
    private final Map<String, Object> extras;

    ApiConfig(Integer enableContactUs, boolean gotoConversationAfterContactUs, boolean requireEmail, boolean hideNameAndEmail, String conversationPrefillText, boolean enableFullPrivacy, boolean showSearchOnNewConversation, boolean showConversationResolutionQuestion, List<Flow> customContactUsFlows, FaqTagFilter withTagsMatching, Metadata customMetadata, int toolbarId, boolean showConversationInfoScreen, boolean enableTypingIndicator, Map<String, String[]> customIssueFields, Map<String, Object> extras) {
        this.enableContactUs = enableContactUs;
        this.gotoConversationAfterContactUs = gotoConversationAfterContactUs;
        this.requireEmail = requireEmail;
        this.hideNameAndEmail = hideNameAndEmail;
        this.conversationPrefillText = conversationPrefillText;
        this.enableFullPrivacy = enableFullPrivacy;
        this.showSearchOnNewConversation = showSearchOnNewConversation;
        this.showConversationResolutionQuestion = showConversationResolutionQuestion;
        this.customContactUsFlows = customContactUsFlows;
        this.withTagsMatching = withTagsMatching;
        this.customMetadata = customMetadata;
        this.toolbarId = toolbarId;
        this.showConversationInfoScreen = showConversationInfoScreen;
        this.enableTypingIndicator = enableTypingIndicator;
        this.customIssueFields = customIssueFields;
        this.extras = extras;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> customMetadata;
        Map<String, Object> faqTagFilter;
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enableContactUs", this.enableContactUs);
        configMap.put("gotoConversationAfterContactUs", this.gotoConversationAfterContactUs);
        configMap.put("requireEmail", this.requireEmail);
        configMap.put("hideNameAndEmail", this.hideNameAndEmail);
        configMap.put("enableFullPrivacy", this.enableFullPrivacy);
        configMap.put("showSearchOnNewConversation", this.showSearchOnNewConversation);
        configMap.put("showConversationResolutionQuestion", this.showConversationResolutionQuestion);
        configMap.put("showConversationInfoScreen", this.showConversationInfoScreen);
        configMap.put("enableTypingIndicator", this.enableTypingIndicator);
        if (this.conversationPrefillText != null && this.conversationPrefillText.length() > 0) {
            configMap.put("conversationPrefillText", this.conversationPrefillText);
        }
        if (this.customContactUsFlows != null) {
            configMap.put("customContactUsFlows", this.customContactUsFlows);
        }
        if (this.withTagsMatching != null && (faqTagFilter = this.withTagsMatching.toMap()) != null) {
            configMap.put("withTagsMatching", faqTagFilter);
        }
        if (this.customMetadata != null && (customMetadata = this.customMetadata.toMap()).size() > 0) {
            configMap.put("hs-custom-metadata", customMetadata);
        }
        if (this.customIssueFields != null) {
            configMap.put("hs-custom-issue-field", this.customIssueFields);
        }
        if (this.toolbarId != 0) {
            configMap.put("toolbarId", this.toolbarId);
        }
        if (this.extras != null) {
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) == null) continue;
                configMap.put(key, this.extras.get(key));
            }
        }
        return configMap;
    }

    public static class Builder {
        private Integer enableContactUs = Support.EnableContactUs.ALWAYS;
        private boolean gotoConversationAfterContactUs = false;
        private boolean requireEmail = false;
        private boolean hideNameAndEmail = false;
        private String conversationPrefillText;
        private boolean enableFullPrivacy = false;
        private boolean showSearchOnNewConversation = false;
        private boolean showConversationResolutionQuestion = false;
        private List<Flow> customContactUsFlows;
        private FaqTagFilter withTagsMatching;
        private Metadata customMetadata;
        private int toolbarId;
        private boolean showConversationInfoScreen = false;
        private Map<String, Object> extras;
        private boolean isGotoConversationAfterContactUsSet = false;
        private boolean enableTypingIndicator = false;
        private Map<String, String[]> customIssueFields;

        public Builder setEnableContactUs(Integer enableContactUs) {
            if (enableContactUs != null && Support.EnableContactUs.valueSet.contains(enableContactUs)) {
                this.enableContactUs = enableContactUs;
            }
            return this;
        }

        @Deprecated
        public Builder setGotoConversationAfterContactUs(boolean gotoConversationAfterContactUs) {
            this.gotoConversationAfterContactUs = gotoConversationAfterContactUs;
            this.isGotoConversationAfterContactUsSet = true;
            return this;
        }

        @Deprecated
        public Builder setRequireEmail(boolean requireEmail) {
            this.requireEmail = requireEmail;
            return this;
        }

        @Deprecated
        public Builder setHideNameAndEmail(boolean hideNameAndEmail) {
            this.hideNameAndEmail = hideNameAndEmail;
            return this;
        }

        public Builder setConversationPrefillText(String conversationPrefillText) {
            this.conversationPrefillText = conversationPrefillText;
            return this;
        }

        public Builder setEnableFullPrivacy(boolean enableFullPrivacy) {
            this.enableFullPrivacy = enableFullPrivacy;
            return this;
        }

        @Deprecated
        public Builder setShowSearchOnNewConversation(boolean showSearchOnNewConversation) {
            this.showSearchOnNewConversation = showSearchOnNewConversation;
            return this;
        }

        @Deprecated
        public Builder setShowConversationResolutionQuestion(boolean showConversationResolutionQuestion) {
            this.showConversationResolutionQuestion = showConversationResolutionQuestion;
            return this;
        }

        public Builder setCustomContactUsFlows(List<Flow> customContactUsFlows) {
            this.customContactUsFlows = customContactUsFlows;
            return this;
        }

        public Builder setWithTagsMatching(FaqTagFilter tagsMatching) {
            this.withTagsMatching = tagsMatching;
            return this;
        }

        public Builder setCustomMetadata(Metadata customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder setToolbarId(int toolbarId) {
            this.toolbarId = toolbarId;
            return this;
        }

        public Builder setShowConversationInfoScreen(boolean showConversationInfoScreen) {
            this.showConversationInfoScreen = showConversationInfoScreen;
            return this;
        }

        @Deprecated
        public Builder setEnableTypingIndicator(boolean enableTypingIndicator) {
            this.enableTypingIndicator = enableTypingIndicator;
            return this;
        }

        public Builder setCustomIssueFields(Map<String, String[]> customIssueFields) {
            this.customIssueFields = customIssueFields;
            return this;
        }

        public Builder setExtras(Map<String, Object> extras) {
            this.extras = extras;
            return this;
        }

        public ApiConfig build() {
            return new ApiConfig(this.enableContactUs, this.gotoConversationAfterContactUs, this.requireEmail, this.hideNameAndEmail, this.conversationPrefillText, this.enableFullPrivacy, this.showSearchOnNewConversation, this.showConversationResolutionQuestion, this.customContactUsFlows, this.withTagsMatching, this.customMetadata, this.toolbarId, this.showConversationInfoScreen, this.enableTypingIndicator, this.customIssueFields, this.extras);
        }
    }
}

