/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import com.helpshift.support.HSApiData;
import com.helpshift.support.SupportInternal;
import com.helpshift.util.HelpshiftContext;
import java.util.HashMap;

public final class ContactUsFilter {
    private static HSApiData data;
    private static Integer enableContactUs;

    public static void init(Context context) {
        if (data == null) {
            data = new HSApiData(context);
            enableContactUs = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getEnableContactUs().getValue();
        }
    }

    protected static void setConfig(HashMap configMap) {
        Object enableContactUsObj;
        if (configMap == null) {
            configMap = new HashMap();
        }
        if ((enableContactUsObj = configMap.get("enableContactUs")) instanceof Integer) {
            enableContactUs = (Integer)configMap.get("enableContactUs");
        } else if (enableContactUsObj instanceof Boolean) {
            enableContactUs = (Boolean)enableContactUsObj != false ? SupportInternal.EnableContactUs.ALWAYS : SupportInternal.EnableContactUs.NEVER;
        }
    }

    public static boolean showContactUs(LOCATION location) {
        switch (location) {
            case SEARCH_RESULT_ACTIVITY_HEADER: {
                return false;
            }
        }
        if (SupportInternal.EnableContactUs.ALWAYS.equals(enableContactUs)) {
            return true;
        }
        if (SupportInternal.EnableContactUs.NEVER.equals(enableContactUs)) {
            return false;
        }
        if (SupportInternal.EnableContactUs.AFTER_VIEWING_FAQS.equals(enableContactUs)) {
            switch (location) {
                case SEARCH_FOOTER: {
                    return true;
                }
                case QUESTION_FOOTER: {
                    return true;
                }
                case QUESTION_ACTION_BAR: {
                    return true;
                }
                case ACTION_BAR: {
                    return HelpshiftContext.getCoreApi().getActiveConversation() != null;
                }
            }
            return true;
        }
        if (SupportInternal.EnableContactUs.AFTER_MARKING_ANSWER_UNHELPFUL.equals(enableContactUs)) {
            switch (location) {
                case SEARCH_FOOTER: {
                    return false;
                }
                case QUESTION_FOOTER: {
                    return true;
                }
                case QUESTION_ACTION_BAR: 
                case ACTION_BAR: {
                    return HelpshiftContext.getCoreApi().getActiveConversation() != null;
                }
            }
            return true;
        }
        return true;
    }

    public static enum LOCATION {
        ACTION_BAR,
        SEARCH_FOOTER,
        QUESTION_FOOTER,
        QUESTION_ACTION_BAR,
        SEARCH_RESULT_ACTIVITY_HEADER;

    }
}

