/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.database.SQLException;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.faq.FaqCore;
import com.helpshift.faq.FaqsResponse;
import com.helpshift.logger.model.LogModel;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.providers.ICampaignsModuleAPIs;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSFaqSyncStatusEvents;
import com.helpshift.support.HSSearch;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Section;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.model.FaqSearchIndex;
import com.helpshift.support.model.FuzzySearchToken;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.SectionDAO;
import com.helpshift.support.storage.SectionsDataSource;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public final class HSApiData {
    public static final String TAG = "Helpshift_ApiData";
    private static final Object flatFaqListSyncLock = new Object();
    public static ArrayList<HSFaqSyncStatusEvents> observers = null;
    public HSStorage storage;
    SectionDAO sectionDAO;
    FaqDAO faqDAO;
    private Iterator failedApiKeys = null;
    private ArrayList<Faq> flatFaqList = null;

    public HSApiData(Context c) {
        this.storage = new HSStorage(c);
        this.sectionDAO = SectionsDataSource.getInstance();
        this.faqDAO = FaqsDataSource.getInstance();
    }

    protected static void addFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers == null) {
            observers = new ArrayList();
        }
        observers.add(observer);
    }

    protected static void removeFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers != null) {
            observers.remove(observer);
        }
    }

    protected static void signalFaqsUpdated() {
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.faqsUpdated();
            }
        }
    }

    protected static void signalSearchIndexesUpdated() {
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.searchIndexesUpdated();
            }
        }
    }

    protected void install(String apiKey, String domain, String appId) {
        this.storage.setApiKey(apiKey);
        this.storage.setDomain(domain);
        this.storage.setAppId(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlatList() {
        ArrayList<Section> sections = this.getSections();
        ArrayList<Faq> tempFlatFaqList = new ArrayList<Faq>();
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            ArrayList<Faq> faqs = this.getFaqsDataForSection(sectionItem.getPublishId());
            tempFlatFaqList.addAll(faqs);
        }
        Object object = flatFaqListSyncLock;
        synchronized (object) {
            this.flatFaqList = new ArrayList(tempFlatFaqList);
        }
    }

    private void getAndStoreSections(final Handler callback, final Handler failure, final FaqTagFilter faqTagFilter) {
        HelpshiftContext.getCoreApi().getFaqDM().fetchFaqs(new FetchDataFromThread<FaqsResponse, ExceptionType>(){

            @Override
            public void onDataFetched(FaqsResponse faqsResponse) {
                if (callback != null) {
                    Message msgToPost = callback.obtainMessage();
                    if (1 == faqsResponse.statusCode) {
                        msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NEW_DATA;
                    } else if (2 == faqsResponse.statusCode) {
                        msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA;
                    }
                    Object response = faqsResponse.response;
                    if (response != null) {
                        JSONArray jsonArray = (JSONArray)response;
                        HSApiData.this.storeSections(jsonArray);
                        msgToPost.obj = HSApiData.this.sectionDAO.getAllSections(faqTagFilter);
                        HSApiData.this.startSearchIndexing();
                    }
                    callback.sendMessage(msgToPost);
                    HSApiData.signalFaqsUpdated();
                }
            }

            @Override
            public void onFailure(ExceptionType exceptionType) {
                if (failure != null) {
                    Message msgToPost = failure.obtainMessage();
                    msgToPost.obj = exceptionType;
                    int what = exceptionType == NetworkException.CONTENT_UNCHANGED ? GetSectionsCallBackStatus.API_FAILURE_CONTENT_UNCHANGED : GetSectionsCallBackStatus.API_FAILURE;
                    msgToPost.what = what;
                    failure.sendMessage(msgToPost);
                }
            }
        });
    }

    void storeSections(JSONArray faqs) {
        HSLogger.d(TAG, "Updating " + (faqs == null ? 0 : faqs.length()) + " FAQ sections in DB");
        this.sectionDAO.clearSectionsData();
        this.sectionDAO.storeSections(faqs);
    }

    void startSearchIndexing() {
        Thread indexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HSApiData.this.updateIndex();
            }
        }, "HS-search-index");
        indexThread.setDaemon(true);
        indexThread.start();
    }

    public void getSections(Handler callback, Handler failure, FaqTagFilter faqTagFilter) {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        if (sections != null) {
            Message result = callback.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_SUCCESS;
            result.obj = sections;
            callback.sendMessage(result);
        } else {
            Message result = failure.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_FAILURE;
            failure.sendMessage(result);
        }
        this.getAndStoreSections(callback, failure, faqTagFilter);
    }

    protected ArrayList<Section> getSections() {
        ArrayList sections = new ArrayList();
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections();
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        return sections;
    }

    public ArrayList<Section> getPopulatedSections(ArrayList<Section> sections, FaqTagFilter faqTagFilter) {
        ArrayList<Section> sectionsList = new ArrayList<Section>();
        for (int i = 0; i < sections.size(); ++i) {
            if (this.isSectionEmpty(sections.get(i), faqTagFilter)) continue;
            sectionsList.add(sections.get(i));
        }
        return sectionsList;
    }

    protected ArrayList<Section> getPopulatedSections(FaqTagFilter faqTagFilter) {
        ArrayList sections = new ArrayList();
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting sections data ", s);
        }
        ArrayList<Section> sectionsList = this.getPopulatedSections(sections, faqTagFilter);
        return sectionsList;
    }

    protected boolean isSectionEmpty(Section section, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> faqs = this.getFaqsForSection(section.getPublishId(), faqTagFilter);
        return faqs.isEmpty();
    }

    public ArrayList<Faq> getFaqsForSection(String publishId, FaqTagFilter faqTagFilter) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsForSection(publishId, faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting faqs for section", s);
        }
        return faqs;
    }

    protected ArrayList<Faq> getFaqsDataForSection(String publishId) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsDataForSection(publishId);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting faqs for section", s);
        }
        return faqs;
    }

    public void markFaqInDB(String faqId, boolean isHelpful) {
        this.faqDAO.setIsHelpful(faqId, isHelpful);
    }

    public ArrayList<Faq> localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options) {
        return this.localFaqSearch(query, options, null);
    }

    public ArrayList<Faq> localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options, FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        LinkedHashSet<Faq> result = new LinkedHashSet<Faq>();
        String lcQuery = query.toLowerCase();
        if (!this.storage.isCacheSearchIndexNull() && this.storage.getDBFlag().booleanValue()) {
            Faq faq;
            int docIdValue;
            String docId;
            FaqSearchIndex fullIndex = this.storage.readIndex();
            Map<String, List<FuzzySearchToken>> fuzzyIndex = null;
            if (fullIndex != null) {
                fuzzyIndex = fullIndex.fuzzyIndex;
            }
            ArrayList<HashMap> tfidfResults = HSSearch.queryDocs(query, options);
            ArrayList<HashMap> fuzzyMatches = HSSearch.getFuzzyMatches(query, fuzzyIndex);
            for (HashMap docIdTermsMap : tfidfResults) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
            for (HashMap docIdTermsMap : fuzzyMatches) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
        } else {
            for (int i = 0; i < this.flatFaqList.size(); ++i) {
                Faq faq = this.flatFaqList.get(i);
                String title = faq.title.toLowerCase();
                if (title.contains(lcQuery)) continue;
                result.add(faq);
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(result), faqTagFilter));
        }
        return new ArrayList<Faq>(result);
    }

    public List<Faq> getAllFaqs(FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(this.flatFaqList), faqTagFilter));
        }
        return this.flatFaqList;
    }

    protected Boolean shouldShowReviewPopup() {
        SDKConfigurationDM sdkConfigurationDM = HelpshiftContext.getCoreApi().getSDKConfigurationDM();
        if (!sdkConfigurationDM.getBoolean("app_reviewed")) {
            PeriodicReview periodicReview = sdkConfigurationDM.getPeriodicReview();
            String rurl = sdkConfigurationDM.getString("reviewUrl");
            if (periodicReview.isEnabled && !TextUtils.isEmpty((CharSequence)rurl)) {
                int reviewCount = this.storage.getReviewCounter();
                String type = periodicReview.type;
                int counterInterval = periodicReview.interval;
                if (counterInterval > 0) {
                    if ("l".equals(type) && reviewCount >= counterInterval) {
                        return true;
                    }
                    if ("s".equals(type) && reviewCount != 0 && new Date().getTime() / 1000L - (long)reviewCount >= (long)counterInterval) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void updateReviewCounter() {
        int reviewCounter = this.storage.getReviewCounter();
        int launchReviewCounter = this.storage.getLaunchReviewCounter();
        if (reviewCounter == 0) {
            launchReviewCounter = reviewCounter;
            reviewCounter = (int)(new Date().getTime() / 1000L);
        }
        this.storage.setLaunchReviewCounter(++launchReviewCounter);
        PeriodicReview periodicReview = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getPeriodicReview();
        String type = periodicReview.type;
        if ("l".equals(type)) {
            reviewCounter = this.storage.getLaunchReviewCounter();
        }
        this.storage.setReviewCounter(reviewCounter);
    }

    protected void resetReviewCounter() {
        int reviewCounter = this.storage.getReviewCounter();
        PeriodicReview periodicReview = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getPeriodicReview();
        String counterType = periodicReview.type;
        if (counterType.equals("s")) {
            reviewCounter = (int)(new Date().getTime() / 1000L);
        } else if (counterType.equals("l")) {
            reviewCounter = 0;
        }
        this.storage.setReviewCounter(reviewCounter);
        this.storage.setLaunchReviewCounter(0);
    }

    public void storeFile(String fileName) {
        try {
            JSONArray fileJsonList = this.storage.getStoredFiles();
            fileJsonList.put((Object)fileName);
            this.storage.setStoredFiles(fileJsonList);
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "storeFile", e);
        }
    }

    void updateIndex() {
        HSLogger.d(TAG, "Updating search indexes.");
        this.storage.deleteIndex();
        this.updateFlatList();
        FaqSearchIndex index = HSSearch.indexDocuments(new ArrayList<Faq>(this.flatFaqList));
        if (index != null) {
            this.storage.storeIndex(index);
        }
        HSApiData.signalSearchIndexesUpdated();
        HSLogger.d(TAG, "Search index update finished.");
    }

    public void loadIndex() {
        Thread loadIndexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HSApiData.this.storage.loadIndex();
                }
                catch (IOException | ClassCastException | ClassNotFoundException e) {
                    HSLogger.e(HSApiData.TAG, "Exception while loading index: trying to re-create the index", e);
                    HSApiData.this.updateIndex();
                    try {
                        HSApiData.this.storage.loadIndex();
                    }
                    catch (Exception clingy) {
                        HSLogger.e(HSApiData.TAG, "Exception caught again, while loading index: ", clingy);
                    }
                }
            }
        }, "HS-load-index");
        loadIndexThread.setDaemon(true);
        loadIndexThread.start();
    }

    public void getSection(final String publishId, final Handler success, Handler failure, FaqTagFilter faqTagFilter) {
        try {
            if (TextUtils.isEmpty((CharSequence)publishId)) {
                failure.sendMessage(failure.obtainMessage());
                return;
            }
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            }
            Handler localSuccess = new Handler(){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    Section toReturn = HSApiData.this.sectionDAO.getSection(publishId);
                    Message msgToPost = success.obtainMessage();
                    msgToPost.obj = toReturn;
                    success.sendMessage(msgToPost);
                }
            };
            this.getAndStoreSections(localSuccess, failure, faqTagFilter);
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting section data ", s);
        }
    }

    public Section getSection(String publishId) {
        return this.sectionDAO.getSection(publishId);
    }

    public void getSectionSync(String publishId, Handler success, Handler failure) {
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            failure.sendMessage(failure.obtainMessage());
            return;
        }
        try {
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            } else {
                Message msgToPost = failure.obtainMessage();
                failure.sendMessage(msgToPost);
            }
        }
        catch (SQLException s) {
            HSLogger.e(TAG, "Database exception in getting section data ", s);
        }
    }

    String getPublishIdFromSectionId(String sectionId) {
        ArrayList<Section> sections = this.getSections();
        String sectionPublishId = "";
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            if (!sectionItem.getSectionId().equals(sectionId)) continue;
            sectionPublishId = sectionItem.getPublishId();
        }
        return sectionPublishId;
    }

    private void getQuestionAsync(final String publishId, String faqLanguage, final boolean isAdminSuggested, final Handler success, final Handler failure) {
        HelpshiftContext.getCoreApi().getFaqDM().fetchQuestion(new FetchDataFromThread<FaqCore, Integer>(){

            @Override
            public void onDataFetched(FaqCore faqCore) {
                Message msgToPost = success.obtainMessage();
                Faq newFaq = new Faq(faqCore, HSApiData.this.getPublishIdFromSectionId(faqCore.section_id));
                msgToPost.obj = newFaq;
                success.sendMessage(msgToPost);
                if (isAdminSuggested) {
                    HelpshiftContext.getPlatform().getFAQSuggestionsDAO().insertOrUpdateFAQ(newFaq);
                } else {
                    HSApiData.this.faqDAO.addFaq(newFaq);
                }
            }

            @Override
            public void onFailure(Integer serverStatusCode) {
                Message msgToPost = failure.obtainMessage();
                if (NetworkErrorCodes.FORBIDDEN_ACCESS.equals(serverStatusCode) || NetworkErrorCodes.CONTENT_NOT_FOUND.equals(serverStatusCode)) {
                    if (!isAdminSuggested) {
                        HSApiData.this.faqDAO.removeFaq(publishId);
                    }
                    InfoModelFactory.getInstance().sdkInfoModel.clearEtag("/faqs/" + publishId + "/");
                }
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("status", serverStatusCode);
                msgToPost.obj = map;
                failure.sendMessage(msgToPost);
            }
        }, publishId, faqLanguage, isAdminSuggested);
    }

    public void getQuestion(Handler success, Handler failure, boolean shouldFetchFromNetwork, boolean isAdminSuggested, String publishId, String faqLanguage) {
        Faq question;
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            failure.sendMessage(failure.obtainMessage());
            return;
        }
        if (isAdminSuggested) {
            question = (Faq)HelpshiftContext.getPlatform().getFAQSuggestionsDAO().getFAQ(publishId, faqLanguage);
            if (question == null) {
                question = this.faqDAO.getFaq(publishId, faqLanguage);
            }
        } else {
            question = this.faqDAO.getFaq(publishId);
        }
        Message msgToPost = success.obtainMessage();
        msgToPost.obj = question;
        success.sendMessage(msgToPost);
        if (question == null || shouldFetchFromNetwork) {
            this.getQuestionAsync(publishId, faqLanguage, isAdminSuggested, success, failure);
        }
    }

    void sendErrorReports(List<LogModel> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        ICampaignsModuleAPIs campaignsDataProvider = CrossModuleDataProvider.getCampaignModuleAPIs();
        HelpshiftContext.getCoreApi().getErrorReportsDM().sendErrorReport(new FetchDataFromThread<Response, Float>(){

            @Override
            public void onDataFetched(Response data) {
                HSLogger.deleteAll();
            }

            @Override
            public void onFailure(Float serverTimeDelta) {
                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(serverTimeDelta);
                HSApiData.this.storage.setLastErrorReportedTime(currentElapsedTime - 86400000L - 1L);
            }
        }, logs, HelpshiftContext.getCoreApi().getUserManagerDM().getActiveUser(), this.storage.getDomain(), "3", "7.5.0", Build.MODEL, campaignsDataProvider.getDeviceIdentifier(), Build.VERSION.RELEASE);
    }

    void clearETagsForFaqs() {
        List<String> allFaqPublishIds = this.faqDAO.getAllFaqPublishIds();
        for (String publishId : allFaqPublishIds) {
            String eTagUrl = this.getQuestionRoute(publishId);
            HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag(eTagUrl, "");
            InfoModelFactory.getInstance().sdkInfoModel.clearEtag(eTagUrl);
        }
        HelpshiftContext.getPlatform().getNetworkRequestDAO().storeETag("/faqs/", null);
    }

    String getQuestionRoute(String publishId) {
        return "/faqs/" + publishId + "/";
    }
}

