/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.AlertToRateAppListener;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.storage.IMAppSessionStorage;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.util.ActivityUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.views.FontApplier;
import java.io.Serializable;
import java.util.HashMap;

public final class HSReviewFragment
extends DialogFragment {
    private static AlertToRateAppListener alertToRateAppListener;
    private final String TAG = "Helpshift_ReviewFrag";
    String rurl = "";
    private boolean disableReview = true;

    protected static void setAlertToRateAppListener(AlertToRateAppListener listener) {
        alertToRateAppListener = listener;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity activity = this.getActivity();
        Bundle extras = activity.getIntent().getExtras();
        if (extras != null) {
            this.disableReview = extras.getBoolean("disableReview", true);
            this.rurl = extras.getString("rurl");
        }
        return this.initAlertDialog(activity);
    }

    public void onCancel(DialogInterface dialog) {
        this.sendReviewActionEvent("later");
        this.sendAlertToRateAppAction(2);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.disableReview) {
            HelpshiftContext.getCoreApi().getSDKConfigurationDM().setAppReviewed(true);
        }
        this.getActivity().finish();
    }

    void gotoApp(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url.trim()));
            if (intent.resolveActivity(this.getContext().getPackageManager()) != null) {
                this.getContext().startActivity(intent);
            }
        }
    }

    void sendAlertToRateAppAction(int action) {
        if (alertToRateAppListener != null) {
            alertToRateAppListener.onAction(action);
        }
        alertToRateAppListener = null;
    }

    private Dialog initAlertDialog(FragmentActivity activity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setMessage(R.string.hs__review_message);
        AlertDialog dialog = builder.create();
        dialog.setTitle(R.string.hs__review_title);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setButton(-1, (CharSequence)this.getResources().getString(R.string.hs__rate_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (TextUtils.isEmpty((CharSequence)HSReviewFragment.this.rurl)) {
                    HSReviewFragment.this.rurl = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getString("reviewUrl");
                }
                HSReviewFragment.this.rurl = HSReviewFragment.this.rurl.trim();
                if (!TextUtils.isEmpty((CharSequence)HSReviewFragment.this.rurl)) {
                    HSReviewFragment.this.gotoApp(HSReviewFragment.this.rurl);
                }
                HSReviewFragment.this.sendReviewActionEvent("reviewed");
                HSReviewFragment.this.sendAlertToRateAppAction(0);
            }
        });
        dialog.setButton(-3, (CharSequence)this.getResources().getString(R.string.hs__feedback_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HSReviewFragment.this.sendReviewActionEvent("feedback");
                HSReviewFragment.this.sendAlertToRateAppAction(1);
                AppSessionConstants.Screen screen = (AppSessionConstants.Screen)IMAppSessionStorage.getInstance().get("current_open_screen");
                if (screen != AppSessionConstants.Screen.NEW_CONVERSATION && screen != AppSessionConstants.Screen.CONVERSATION && screen != AppSessionConstants.Screen.CONVERSATION_INFO && screen != AppSessionConstants.Screen.SCREENSHOT_PREVIEW) {
                    Intent i = new Intent(HSReviewFragment.this.getContext(), ParentActivity.class);
                    i.putExtra("support_mode", 1);
                    i.putExtra("decomp", true);
                    i.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen((Activity)HSReviewFragment.this.getActivity()));
                    i.putExtra("isRoot", true);
                    i.putExtra("search_performed", true);
                    HSReviewFragment.this.getActivity().startActivity(i);
                }
            }
        });
        dialog.setButton(-2, (CharSequence)this.getResources().getString(R.string.hs__review_close_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HSReviewFragment.this.sendReviewActionEvent("later");
                HSReviewFragment.this.sendAlertToRateAppAction(2);
            }
        });
        FontApplier.apply((Dialog)dialog);
        return dialog;
    }

    void sendReviewActionEvent(String action) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", "periodic");
        data.put("response", action);
        HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.REVIEWED_APP, data);
    }
}

