/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.content.SharedPreferences;
import com.helpshift.support.model.FaqSearchIndex;
import com.helpshift.support.search.SearchTokenDao;
import com.helpshift.support.search.storage.SearchTokenDaoImpl;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.util.HSLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSStorage {
    static final String TAG = "HelpShiftDebug";
    private static FaqSearchIndex cachedSearchIndex;
    private final String dbFile = "fullIndex.db";
    private Context context;
    private SharedPreferences storage;

    public HSStorage(Context c) {
        this.context = c;
        this.storage = c.getSharedPreferences("HSJsonData", 0);
    }

    private JSONObject storageGetObj(String key) throws JSONException {
        return new JSONObject(this.storage.getString(key, "{}"));
    }

    private JSONArray storageGetArr(String key) throws JSONException {
        return new JSONArray(this.storage.getString(key, "[]"));
    }

    private String storageGet(String key) {
        return this.storage.getString(key, "");
    }

    private Integer storageGetInt(String key) {
        return this.storageGetInt(key, 0);
    }

    private Integer storageGetInt(String key, int defaultValue) {
        return this.storage.getInt(key, defaultValue);
    }

    public Float storageGetFloat(String key) {
        return Float.valueOf(this.storage.getFloat(key, 0.0f));
    }

    public boolean contains(String key) {
        return this.storage.contains(key);
    }

    public Boolean storageGetBoolean(String key) {
        return this.storage.getBoolean(key, false);
    }

    private Long storageGetLong(String key) {
        return this.storage.getLong(key, 0L);
    }

    private void storageSet(String key, JSONArray data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data.toString());
        editor.apply();
    }

    private void storageSet(String key, JSONObject data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data.toString());
        editor.apply();
    }

    private void storageSet(String key, String data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data);
        editor.apply();
    }

    private void storageSet(String key, Integer data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putInt(key, data.intValue());
        editor.apply();
    }

    private void storageSet(String key, Boolean data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putBoolean(key, data.booleanValue());
        editor.apply();
    }

    private void storageSet(String key, Long data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putLong(key, data.longValue());
        editor.apply();
    }

    protected void clearDatabase() {
        FaqsDataSource faqsDataSource = FaqsDataSource.getInstance();
        faqsDataSource.clearDB();
        SharedPreferences.Editor editor = this.storage.edit();
        editor.clear();
        editor.apply();
    }

    protected void clearLegacySearchIndexFile() {
        this.context.deleteFile("tfidf.db");
    }

    protected String getApiKey() {
        return this.storageGet("apiKey");
    }

    protected void setApiKey(String apiKey) {
        this.storageSet("apiKey", apiKey);
    }

    protected String getDomain() {
        return this.storageGet("domain");
    }

    protected void setDomain(String domain) {
        this.storageSet("domain", domain);
    }

    protected String getAppId() {
        return this.storageGet("appId");
    }

    protected void setAppId(String appId) {
        this.storageSet("appId", appId);
    }

    protected String getLibraryVersion() {
        return this.storageGet("libraryVersion");
    }

    protected void setLibraryVersion(String libraryVersion) {
        this.storageSet("libraryVersion", libraryVersion);
    }

    protected String getApplicationVersion() {
        return this.storageGet("applicationVersion");
    }

    protected void setApplicationVersion(String applicationVersion) {
        this.storageSet("applicationVersion", applicationVersion);
    }

    protected int getReviewCounter() {
        return this.storageGetInt("reviewCounter");
    }

    protected void setReviewCounter(int count) {
        this.storageSet("reviewCounter", count);
    }

    protected int getLaunchReviewCounter() {
        return this.storageGetInt("launchReviewCounter");
    }

    protected void setLaunchReviewCounter(int count) {
        this.storageSet("launchReviewCounter", count);
    }

    protected JSONArray getStoredFiles() throws JSONException {
        return this.storageGetArr("cachedImages");
    }

    protected void setStoredFiles(JSONArray filenames) {
        this.storageSet("cachedImages", filenames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeIndex(FaqSearchIndex fullIndex) {
        cachedSearchIndex = fullIndex;
        FileOutputStream fStream = null;
        ObjectOutputStream oStream = null;
        try {
            fStream = this.context.openFileOutput("fullIndex.db", 0);
            oStream = new ObjectOutputStream(fStream);
            oStream.writeObject(fullIndex);
            oStream.flush();
            this.setDBFlag();
        }
        catch (Exception e) {
            HSLogger.d(TAG, "store index", e);
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIndex() throws IOException, ClassCastException, ClassNotFoundException {
        if (cachedSearchIndex != null) {
            return;
        }
        FileInputStream fStream = null;
        ObjectInputStream oStream = null;
        try {
            fStream = this.context.openFileInput("fullIndex.db");
            oStream = new ObjectInputStream(fStream);
            cachedSearchIndex = (FaqSearchIndex)oStream.readObject();
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected FaqSearchIndex readIndex() {
        return cachedSearchIndex;
    }

    protected Boolean getDBFlag() {
        return this.storageGetBoolean("dbFlag");
    }

    protected void setDBFlag() {
        this.storageSet("dbFlag", true);
    }

    protected void unsetDBFlag() {
        this.storageSet("dbFlag", false);
    }

    protected void deleteIndex() {
        cachedSearchIndex = null;
        SearchTokenDao searchTokenDao = SearchTokenDaoImpl.getInstance();
        searchTokenDao.clear();
        this.context.deleteFile("fullIndex.db");
        this.unsetDBFlag();
    }

    protected JSONObject getFailedApiCalls() throws JSONException {
        return this.storageGetObj("failedApiCalls");
    }

    protected void storeFailedApiCall(String key, JSONObject failedApiCall) throws JSONException {
        JSONObject failedApiCalls = this.getFailedApiCalls();
        failedApiCalls.put(key, (Object)failedApiCall);
        this.storageSet("failedApiCalls", failedApiCalls);
    }

    long getLastErrorReportedTime() {
        return this.storageGetLong("lastErrorReportedTime");
    }

    void setLastErrorReportedTime(long time) {
        this.storageSet("lastErrorReportedTime", time);
    }

    boolean isCacheSearchIndexNull() {
        return null == cachedSearchIndex;
    }

    public String getString(String key) {
        return this.storage.getString(key, "");
    }
}

