/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.content.Intent;
import com.helpshift.app.AppLifeCycleStateHolder;
import com.helpshift.applifecycle.HSAppLifeCycleListener;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.logger.model.LogModel;
import com.helpshift.static_classes.ErrorReporting;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSReview;
import com.helpshift.support.HSStorage;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.util.List;

public class SupportAppLifeCycleListener
implements HSAppLifeCycleListener {
    HSApiData data = null;
    HSStorage storage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAppForeground(Context context) {
        AppLifeCycleStateHolder.setAppInForeground(true);
        if (this.data == null) {
            this.data = new HSApiData(context);
            this.storage = this.data.storage;
        }
        this.data.updateReviewCounter();
        if (this.data.shouldShowReviewPopup().booleanValue()) {
            Intent i = new Intent(context, HSReview.class);
            i.setFlags(0x10000000);
            context.startActivity(i);
        }
        this.tryFetchingServerConfig(context);
        HelpshiftContext.getCoreApi().sendFailedApiCalls();
        HelpshiftContext.getCoreApi().sendAppStartEvent();
        HelpshiftContext.getCoreApi().resetPreIssueConversations();
        boolean isNetworkAvailable = HelpshiftConnectionUtil.isOnline(context);
        SupportAppLifeCycleListener supportAppLifeCycleListener = this;
        synchronized (supportAppLifeCycleListener) {
            if (isNetworkAvailable && ErrorReporting.isEnabled()) {
                List<LogModel> logs;
                boolean hasExceededBatchTime;
                long lastReportedTime = this.storage.getLastErrorReportedTime();
                float serverTimeDelta = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(Float.valueOf(serverTimeDelta));
                boolean bl = hasExceededBatchTime = currentElapsedTime - lastReportedTime > 86400000L;
                if (hasExceededBatchTime && HSLogger.getFatalLogsCount() > 0 && (logs = HSLogger.getAll()) != null && !logs.isEmpty()) {
                    this.storage.setLastErrorReportedTime(currentElapsedTime);
                    this.data.sendErrorReports(logs);
                }
            }
        }
    }

    @Override
    public void onAppBackground(Context context) {
        AppLifeCycleStateHolder.setAppInForeground(false);
        HelpshiftContext.getCoreApi().getConversationInboxPoller().stop();
        HelpshiftContext.getCoreApi().sendRequestIdsForSuccessfulApiCalls();
    }

    private void tryFetchingServerConfig(Context context) {
        boolean isDebuggable = ApplicationUtil.isApplicationDebuggable(context);
        SDKConfigurationDM sdkConfigurationDM = HelpshiftContext.getCoreApi().getDomain().getSDKConfigurationDM();
        long currentTimeInSeconds = System.currentTimeMillis() / 1000L;
        if (isDebuggable || Math.abs(currentTimeInSeconds - sdkConfigurationDM.getLastSuccessfulConfigFetchTime()) >= sdkConfigurationDM.getPeriodicFetchInterval()) {
            HelpshiftContext.getCoreApi().fetchServerConfig();
        }
        HelpshiftContext.getCoreApi().refreshPoller();
    }
}

