/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.helpshift.HelpshiftUser;
import com.helpshift.applifecycle.HSAppLifeCycleController;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.delegate.RootDelegate;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.notifications.NotificationChannelsManager;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.support.AlertToRateAppListener;
import com.helpshift.support.Callable;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSReview;
import com.helpshift.support.HSReviewFragment;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Metadata;
import com.helpshift.support.MetadataCallable;
import com.helpshift.support.SupportAppLifeCycleListener;
import com.helpshift.support.SupportMigrator;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.flows.CustomContactUsFlowListHolder;
import com.helpshift.support.flows.DynamicFormFlowListHolder;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.providers.SupportDataProvider;
import com.helpshift.support.util.ConfigUtil;
import com.helpshift.util.ActivityUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HSPattern;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ValuePair;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SupportInternal {
    public static final String TAG = "Helpshift_SupportInter";
    public static final String CONVERSATION_FLOW = "conversationFlow";
    public static final String FAQS_FLOW = "faqsFlow";
    public static final String FAQ_SECTION_FLOW = "faqSectionFlow";
    public static final String SINGLE_FAQ_FLOW = "singleFaqFlow";
    public static final String DYNAMIC_FORM_FLOW = "dynamicFormFlow";
    public static final String CustomMetadataKey = "hs-custom-metadata";
    private static HSApiData data = null;
    private static HSStorage storage = null;
    private static Context context = null;

    private SupportInternal() {
    }

    private static void init(Application application) {
        SupportInternal.initialize(application.getApplicationContext());
    }

    private static void init(Context context) {
        SupportInternal.initialize(context.getApplicationContext());
    }

    private static void initialize(Context context) {
        if (SupportInternal.context == null) {
            data = new HSApiData(context);
            storage = SupportInternal.data.storage;
            ContactUsFilter.init(context);
            SupportInternal.context = context;
        }
    }

    public static void preInstall(Application application, String apiKey, String domain, String appId, Map config) {
        HelpshiftContext.setApplicationContext(application.getApplicationContext());
        HelpshiftContext.initializeCore(apiKey, domain, appId);
        boolean isManualLifecycleTracking = false;
        if (config != null && config.containsKey("manualLifecycleTracking")) {
            isManualLifecycleTracking = (Boolean)config.get("manualLifecycleTracking");
        }
        SupportAppLifeCycleListener supportLifeCycleListener = new SupportAppLifeCycleListener();
        HSAppLifeCycleController appLifeCycleController = HSAppLifeCycleController.getInstance();
        appLifeCycleController.init(application, isManualLifecycleTracking);
        appLifeCycleController.registerAppLifeCycleListener(supportLifeCycleListener);
    }

    public static void install(Application application, String apiKey, String domain, String appId) {
        SupportInternal.install(application, apiKey, domain, appId, new HashMap<String, Object>());
    }

    @TargetApi(value=14)
    public static void install(Application application, String apiKey, String domain, String appId, Map<String, Object> configIn) {
        Object disableAnimations;
        Object notifSound;
        Object notifIcon;
        SupportInternal.init(application);
        CrossModuleDataProvider.setSupportDataProvider(new SupportDataProvider());
        HashMap config = (HashMap)ConfigUtil.getDefaultInstallConfig();
        if (configIn != null) {
            config.putAll(configIn);
        }
        SupportMigrator.migrate(context, HelpshiftContext.getPlatform(), HelpshiftContext.getCoreApi().getDomain(), data, storage);
        Object fontPathObj = config.get("font");
        if (fontPathObj instanceof String) {
            String fontPath = (String)fontPathObj;
            InfoModelFactory.getInstance().appInfoModel.setFontPath(fontPath);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setFontPath(null);
        }
        Object screenOrientation = config.get("screenOrientation");
        if (screenOrientation instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setScreenOrientation((Integer)screenOrientation);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setScreenOrientation(-1);
        }
        Object supportNotificationChannelId = config.get("supportNotificationChannelId");
        if (supportNotificationChannelId instanceof String) {
            config.put("supportNotificationChannelId", supportNotificationChannelId);
        }
        if ((notifIcon = config.get("notificationIcon")) != null && notifIcon instanceof String) {
            String mDrawableName = (String)notifIcon;
            int resId = application.getResources().getIdentifier(mDrawableName, "drawable", application.getPackageName());
            config.put("notificationIcon", resId);
        }
        if ((notifSound = config.get("notificationSound")) != null && notifSound instanceof String) {
            String mDrawableName = (String)notifSound;
            int resId = application.getResources().getIdentifier(mDrawableName, "raw", application.getPackageName());
            config.put("notificationSound", resId);
        }
        if ((disableAnimations = config.get("disableAnimations")) instanceof Boolean) {
            InfoModelFactory.getInstance().appInfoModel.setDisableAnimations((Boolean)disableAnimations);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setDisableAnimations(false);
        }
        String applicationVersion = ApplicationUtil.getApplicationVersion(context);
        if (!storage.getApplicationVersion().equals(applicationVersion)) {
            data.resetReviewCounter();
            HelpshiftContext.getCoreApi().getSDKConfigurationDM().setAppReviewed(false);
            storage.setApplicationVersion(applicationVersion);
        }
        HelpshiftContext.getCoreApi().updateInstallConfig(config);
        application.deleteDatabase("__hs__db_error_reports");
        NotificationChannelsManager notificationChannel = new NotificationChannelsManager((Context)application);
        notificationChannel.checkAndUpdateDefaultChannelInfo();
    }

    public static boolean isConversationActive() {
        return HelpshiftContext.getCoreApi().isActiveConversationActionable();
    }

    public static Integer getNotificationCount() {
        return HelpshiftContext.getCoreApi().getNotificationCountSync();
    }

    public static void getNotificationCount(final Handler success, final Handler failure) {
        if (success == null) {
            return;
        }
        if (data == null || storage == null) {
            if (HelpshiftContext.getApplicationContext() == null) {
                return;
            }
            SupportInternal.init(HelpshiftContext.getApplicationContext());
        }
        HelpshiftContext.getCoreApi().getNotificationCountAsync(new FetchDataFromThread<ValuePair<Integer, Boolean>, Object>(){

            @Override
            public void onDataFetched(ValuePair<Integer, Boolean> data) {
                if (data == null) {
                    return;
                }
                Message msgToPost = success.obtainMessage();
                Bundle countData = new Bundle();
                countData.putInt("value", ((Integer)data.first).intValue());
                countData.putBoolean("cache", ((Boolean)data.second).booleanValue());
                msgToPost.obj = countData;
                success.sendMessage(msgToPost);
            }

            @Override
            public void onFailure(Object value) {
                if (failure != null) {
                    Message failureMsg = failure.obtainMessage();
                    Bundle failureCount = new Bundle();
                    failureCount.putInt("value", -1);
                    failureMsg.obj = failureCount;
                    failure.sendMessage(failureMsg);
                }
            }
        });
    }

    public static void setNameAndEmail(String name, String email) {
        name = name == null || HSPattern.hasOnlySpecialCharacters(name) ? "" : name.trim();
        email = email == null || !HSPattern.isValidEmail(email) ? "" : email.trim();
        HelpshiftContext.getCoreApi().setNameAndEmail(name, email);
    }

    public static void setUserIdentifier(String userIdentifier) {
        if (userIdentifier != null) {
            HelpshiftContext.getCoreApi().getUserManagerDM().setUserMetaIdentifier(userIdentifier.trim());
        }
    }

    public static void registerDeviceToken(Context context, String deviceToken) {
        SupportInternal.init(context);
        if (deviceToken != null) {
            HelpshiftContext.getCoreApi().setPushToken(deviceToken);
        } else {
            HSLogger.e(TAG, "Device Token is null");
        }
    }

    public static void leaveBreadCrumb(String breadCrumb) {
        if (breadCrumb != null && !TextUtils.isEmpty((CharSequence)breadCrumb.trim())) {
            HelpshiftContext.getCoreApi().getMetaDataDM().pushBreadCrumb(breadCrumb);
        }
    }

    public static void clearBreadCrumbs() {
        HelpshiftContext.getCoreApi().getMetaDataDM().clearBreadCrumbs();
    }

    public static void showConversation(Activity a) {
        SupportInternal.showConversation(a, new HashMap<String, Object>());
    }

    public static void showConversation(Activity a, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Show conversation : ", LogExtrasModelProvider.fromMap("Config", configHashMap));
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 1);
        i.putExtra("decomp", true);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeShowConversationUnsupportedConfigs(configHashMap)));
        i.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(a));
        i.putExtra("isRoot", true);
        i.putExtra("search_performed", false);
        a.startActivity(i);
    }

    public static void showFAQSection(Activity a, String sectionPublishId) {
        SupportInternal.showFAQSection(a, sectionPublishId, new HashMap<String, Object>());
    }

    public static void showFAQSection(Activity a, String sectionPublishId, Map<String, Object> config) {
        if (!SupportInternal.isValidPublishId(sectionPublishId)) {
            sectionPublishId = null;
        }
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Show FAQ section : Publish Id : " + sectionPublishId, LogExtrasModelProvider.fromMap("Config", configHashMap));
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 2);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("sectionPublishId", sectionPublishId);
        i.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(a));
        i.putExtra("decomp", true);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void showSingleFAQ(Activity a, String questionPublishId) {
        SupportInternal.showSingleFAQ(a, questionPublishId, new HashMap<String, Object>());
    }

    public static void showSingleFAQ(Activity a, String questionPublishId, Map<String, Object> config) {
        if (!SupportInternal.isValidPublishId(questionPublishId)) {
            questionPublishId = null;
        }
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Show single FAQ : Publish Id : " + questionPublishId, LogExtrasModelProvider.fromMap("Config", configHashMap));
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 3);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("questionPublishId", questionPublishId);
        i.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(a));
        i.putExtra("decomp", true);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void setMetadataCallback(Callable f) {
        HelpshiftContext.getCoreApi().getMetaDataDM().setCustomMetaDataCallable(f);
    }

    public static void setMetadataCallback(final MetadataCallable metadataCallable) {
        Callable callable = new Callable(){

            public HashMap call() {
                Metadata metadata = metadataCallable.call();
                if (metadata != null) {
                    return new HashMap<String, Object>(metadata.toMap());
                }
                return null;
            }
        };
        SupportInternal.setMetadataCallback(callable);
    }

    private static void createMetadataCallback(final HashMap config) {
        if (config.containsKey(CustomMetadataKey)) {
            Callable f = new Callable(){

                public HashMap call() {
                    if (config.get(SupportInternal.CustomMetadataKey) instanceof HashMap) {
                        return (HashMap)config.get(SupportInternal.CustomMetadataKey);
                    }
                    return null;
                }
            };
            SupportInternal.setMetadataCallback(f);
        }
    }

    public static void showFAQs(Activity a) {
        SupportInternal.showFAQs(a, new HashMap<String, Object>());
    }

    public static void showFAQs(Activity a, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Show FAQs : ", LogExtrasModelProvider.fromMap("Config", configHashMap));
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(a));
        i.putExtra("decomp", false);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void showDynamicForm(Activity activity, String title, List<Flow> flowList) {
        HSLogger.d(TAG, "Show dynamic form");
        Intent intent = new Intent((Context)activity, ParentActivity.class);
        DynamicFormFlowListHolder.setFlowList(flowList);
        intent.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(activity));
        intent.putExtra("support_mode", 4);
        intent.putExtra("decomp", true);
        intent.putExtra("flow_title", title.trim());
        activity.startActivity(intent);
    }

    public static HashMap<String, Object> removeFAQFlowUnsupportedConfigs(HashMap<String, Object> config) {
        HashMap<String, Object> returnConfig = new HashMap<String, Object>(config);
        returnConfig.remove("conversationPrefillText");
        return returnConfig;
    }

    public static HashMap<String, Object> removeShowConversationUnsupportedConfigs(HashMap<String, Object> config) {
        HashMap<String, Object> returnConfig = new HashMap<String, Object>(config);
        returnConfig.remove("enableContactUs");
        returnConfig.remove("customContactUsFlows");
        return returnConfig;
    }

    private static boolean isValidPublishId(String publishId) {
        return publishId != null && publishId.trim().length() > 0 && publishId.matches("\\d+");
    }

    public static Bundle cleanConfig(HashMap<String, Object> configMapIn) {
        HashMap<String, Object> configMap = new HashMap<String, Object>(ConfigUtil.getDefaultApiConfig());
        configMap.putAll(configMapIn);
        ContactUsFilter.setConfig(configMap);
        Bundle cleanConfig = new Bundle();
        SupportInternal.createMetadataCallback(configMap);
        JSONObject config = new JSONObject(configMap);
        HelpshiftContext.getCoreApi().updateApiConfig(configMap);
        SupportInternal.updateCustomIssueFieldData(configMap);
        try {
            if (config.has("conversationPrefillText") && !config.getString("conversationPrefillText").equals("null") && config.has(CustomMetadataKey)) {
                cleanConfig.putBoolean("dropMeta", true);
            }
            if (config.has("toolbarId")) {
                cleanConfig.putInt("toolbarId", config.getInt("toolbarId"));
            }
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "JSON exception while parsing config : ", e);
        }
        cleanConfig.putBoolean("showSearchOnNewConversation", config.optBoolean("showSearchOnNewConversation", false));
        cleanConfig.putSerializable("withTagsMatching", (Serializable)SupportInternal.cleanFaqTagFilter(configMap.get("withTagsMatching")));
        List customContactUsFlows = (List)configMap.get("customContactUsFlows");
        CustomContactUsFlowListHolder.setFlowList(customContactUsFlows);
        return cleanConfig;
    }

    private static void updateCustomIssueFieldData(Map<String, Object> configMap) {
        Object data;
        Map customIssueFieldData = null;
        if (configMap.containsKey("hs-custom-issue-field") && (data = configMap.get("hs-custom-issue-field")) instanceof Map) {
            try {
                customIssueFieldData = (Map)data;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception while parsing CIF data : ", e);
            }
        }
        HelpshiftContext.getCoreApi().getCustomIssueFieldDM().setCustomIssueFieldData(customIssueFieldData);
    }

    private static FaqTagFilter cleanFaqTagFilter(Object filterTagsConfigObject) {
        if (filterTagsConfigObject == null) {
            return null;
        }
        try {
            Map filterTagsConfig = (Map)filterTagsConfigObject;
            String operator = (String)filterTagsConfig.get("operator");
            if (!TextUtils.isEmpty((CharSequence)operator)) {
                operator = operator.trim().toLowerCase(Locale.US);
                String[] tags = (String[])filterTagsConfig.get("tags");
                if (tags != null && tags.length > 0) {
                    if (operator.equals("and")) {
                        return new FaqTagFilter("and", tags);
                    }
                    if (operator.equals("or")) {
                        return new FaqTagFilter("or", tags);
                    }
                    if (operator.equals("not")) {
                        return new FaqTagFilter("not", tags);
                    }
                }
            }
        }
        catch (ClassCastException e) {
            HSLogger.e(TAG, "Invalid FaqTagFilter object in config", e);
        }
        return null;
    }

    public static void handlePush(Context context, Intent i) {
        SupportInternal.init(context);
        String issueType = SupportInternal.getIssueType(i);
        String issueId = SupportInternal.getIssueId(i, issueType);
        if (issueId == null) {
            HSLogger.e(TAG, "Unknown issuetype/issueId in push payload");
            return;
        }
        String appName = null;
        Bundle extras = i.getExtras();
        if (extras != null && extras.containsKey("app_name")) {
            appName = extras.getString("app_name");
        }
        HelpshiftContext.getCoreApi().handlePushNotification(issueType, issueId, appName);
    }

    private static String getIssueId(Intent intent, String issueType) {
        if (intent == null || intent.getExtras() == null) {
            return null;
        }
        String issueId = null;
        Bundle extras = intent.getExtras();
        if ("issue".equals(issueType)) {
            issueId = extras.getString("issue_id");
        } else if ("preissue".equals(issueType)) {
            issueId = extras.getString("preissue_id");
        }
        return issueId;
    }

    private static String getIssueType(Intent intent) {
        if (intent == null || intent.getExtras() == null) {
            return null;
        }
        return intent.getExtras().getString("issue_type");
    }

    public static void showAlertToRateApp(String url, AlertToRateAppListener alertToRateAppListener) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)url)) {
            intent.setData(Uri.parse((String)url.trim()));
        }
        if (TextUtils.isEmpty((CharSequence)url) || intent.resolveActivity(context.getPackageManager()) == null) {
            if (alertToRateAppListener != null) {
                alertToRateAppListener.onAction(3);
            }
            return;
        }
        HSReviewFragment.setAlertToRateAppListener(alertToRateAppListener);
        Intent i = new Intent(context, HSReview.class);
        i.putExtra("disableReview", false);
        i.putExtra("rurl", url.trim());
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    public static void setDelegate(RootDelegate delegate) {
        HelpshiftContext.getCoreApi().setDelegateListener(delegate);
    }

    public static boolean login(HelpshiftUser helpshiftUser) {
        return HelpshiftContext.getCoreApi().login(helpshiftUser);
    }

    public static boolean logout() {
        return HelpshiftContext.getCoreApi().logout();
    }

    public static boolean clearAnonymousUser() {
        return HelpshiftContext.getCoreApi().clearAnonymousUser();
    }

    public static void setSDKLanguage(String locale) {
        HelpshiftContext.getCoreApi().getSDKConfigurationDM().setSdkLanguage(locale);
    }

    public static SupportFragment getFAQsFragment(Activity activity) {
        return SupportInternal.getFAQsFragment(activity, new HashMap<String, Object>());
    }

    public static SupportFragment getFAQsFragment(Activity activity, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Get FAQ fragment : ", LogExtrasModelProvider.fromMap("Config", configHashMap));
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getConversationFragment(Activity activity) {
        return SupportInternal.getConversationFragment(activity, new HashMap<String, Object>());
    }

    public static SupportFragment getConversationFragment(Activity activity, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Get Conversation fragment : ", LogExtrasModelProvider.fromMap("Config", configHashMap));
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeShowConversationUnsupportedConfigs(configHashMap));
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putInt("support_mode", 1);
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putBoolean("isRoot", true);
        bundle.putBoolean("search_performed", false);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getFAQSectionFragment(Activity activity, String sectionPublishId) {
        return SupportInternal.getFAQSectionFragment(activity, sectionPublishId, new HashMap<String, Object>());
    }

    public static SupportFragment getFAQSectionFragment(Activity activity, String sectionPublishId, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Get FAQ section fragment : Publish Id : " + sectionPublishId, LogExtrasModelProvider.fromMap("Config", configHashMap));
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putInt("support_mode", 2);
        bundle.putString("sectionPublishId", sectionPublishId);
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("isRoot", true);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getSingleFAQFragment(Activity activity, String questionPublishId) {
        return SupportInternal.getSingleFAQFragment(activity, questionPublishId, new HashMap<String, Object>());
    }

    public static SupportFragment getSingleFAQFragment(Activity activity, String questionPublishId, Map<String, Object> config) {
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Get single FAQ fragment : Publish Id : " + questionPublishId, LogExtrasModelProvider.fromMap("Config", configHashMap));
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putInt("support_mode", 3);
        bundle.putString("questionPublishId", questionPublishId);
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("isRoot", true);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getDynamicFormFragment(Activity activity, String title, List<Flow> flowList, Map<String, Object> config) {
        DynamicFormFlowListHolder.setFlowList(flowList);
        HashMap<String, Object> configHashMap = new HashMap<String, Object>(config);
        HSLogger.d(TAG, "Get dynamic flow fragment : ", LogExtrasModelProvider.fromMap("Config", configHashMap));
        Bundle bundle = SupportInternal.cleanConfig(configHashMap);
        bundle.putInt("support_mode", 4);
        bundle.putBoolean("showInFullScreen", ActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putString("flow_title", title.trim());
        bundle.putBoolean("decomp", true);
        return SupportFragment.newInstance(bundle);
    }

    public static class EnableContactUs {
        public static final Integer ALWAYS = 0;
        public static final Integer NEVER = 1;
        public static final Integer AFTER_VIEWING_FAQS = 2;
        public static final Integer AFTER_MARKING_ANSWER_UNHELPFUL = 3;
        public static final HashSet valueSet = EnableContactUs.getSupportedValueSet();

        private static HashSet<Integer> getSupportedValueSet() {
            HashSet<Integer> valueSet = new HashSet<Integer>();
            valueSet.add(ALWAYS);
            valueSet.add(NEVER);
            valueSet.add(AFTER_VIEWING_FAQS);
            valueSet.add(AFTER_MARKING_ANSWER_UNHELPFUL);
            return valueSet;
        }
    }

    public static class RateAlert {
        public static final int SUCCESS = 0;
        public static final int FEEDBACK = 1;
        public static final int CLOSE = 2;
        public static final int FAIL = 3;
    }
}

