/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.os.Environment;
import com.helpshift.account.dao.legacy.AndroidLegacyProfileDAO;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.storage.LegacyUserDataMigrator;
import com.helpshift.support.storage.SupportKVStoreMigrator;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.VersionName;
import java.io.File;
import java.util.HashSet;
import java.util.List;

public class SupportMigrator {
    public static final String TAG = "Helpshift_SupportMigr";

    public static void migrate(Context context, Platform platform, Domain domain, HSApiData data, HSStorage storage) {
        String oldVersionString = storage.getLibraryVersion();
        boolean dropDatabases = true;
        if (oldVersionString.length() > 0 && !oldVersionString.equals("7.5.0")) {
            VersionName oldSDKVersion = new VersionName("0");
            try {
                oldSDKVersion = new VersionName(oldVersionString);
            }
            catch (NumberFormatException e) {
                HSLogger.e(TAG, "Error in creating SemVer: " + e);
            }
            if (oldSDKVersion.isGreaterThanOrEqualTo(new VersionName("7.0.0"))) {
                dropDatabases = false;
            }
            if (dropDatabases) {
                LegacyUserDataMigrator userDataMigrator = new LegacyUserDataMigrator(HelpshiftContext.getCoreApi(), storage, platform.getKVStore(), AndroidLegacyProfileDAO.getInstance(context), platform.getBackupDAO(), platform.getLegacyUserMigrationDataSource(), platform.getLegacyAnalyticsEventIDDAO(), oldSDKVersion);
                SupportKVStoreMigrator kvStoreMigrator = new SupportKVStoreMigrator(storage);
                userDataMigrator.backup(oldSDKVersion);
                kvStoreMigrator.backup(oldSDKVersion);
                data.clearETagsForFaqs();
                storage.clearDatabase();
                userDataMigrator.dropProfileDB();
                platform.getConversationDAO().dropAndCreateDatabase();
                domain.getUserManagerDM().resetSyncStateForAllUsers();
                platform.getKVStore().removeAllKeys();
                userDataMigrator.restore();
                kvStoreMigrator.restore();
                domain.getUserManagerDM().getActiveUserSetupDM().startSetup();
            } else {
                SupportMigrator.fixDuplicatePreIssues(platform, domain, oldSDKVersion);
                SupportMigrator.updateRejectConversations(platform, domain, oldSDKVersion);
            }
        }
        storage.clearLegacySearchIndexFile();
        SupportMigrator.deleteDBLockFilesOnSDKMigration(context);
        if (!"7.5.0".equals(oldVersionString)) {
            storage.setLibraryVersion("7.5.0");
        }
    }

    private static void updateRejectConversations(Platform platform, Domain domain, VersionName oldSDKVersion) {
        if (oldSDKVersion.isGreaterThanOrEqualTo(new VersionName("7.0.0")) && oldSDKVersion.isLessThanOrEqualTo(new VersionName("7.1.0"))) {
            ConversationDAO conversationDAO = platform.getConversationDAO();
            List<UserDM> users = domain.getUserManagerDM().getAllUsers();
            if (ListUtils.isEmpty(users)) {
                return;
            }
            for (UserDM userDM : users) {
                List<ConversationDM> conversationDMS = conversationDAO.readConversationsWithoutMessages(userDM.getLocalId());
                if (ListUtils.isEmpty(conversationDMS)) continue;
                for (ConversationDM conversationDM : conversationDMS) {
                    if (conversationDM.state != IssueState.REJECTED || conversationDM.isStartNewConversationClicked) continue;
                    conversationDM.setDependencies(platform, domain, userDM);
                    conversationDM.setStartNewConversationButtonClicked(true, true);
                }
            }
        }
    }

    private static void fixDuplicatePreIssues(Platform platform, Domain domain, VersionName oldSDKVersion) {
        if (oldSDKVersion.isGreaterThanOrEqualTo(new VersionName("7.0.0")) && oldSDKVersion.isLessThanOrEqualTo(new VersionName("7.1.0"))) {
            List<UserDM> users = domain.getUserManagerDM().getAllUsers();
            ConversationDAO conversationDAO = platform.getConversationDAO();
            HashSet<String> preIssueConversations = new HashSet<String>();
            for (UserDM user : users) {
                List<ConversationDM> conversationDMs;
                ConversationDM activeConversationDM = domain.getConversationInboxManagerDM().getConversationInboxDM(user).getActiveConversationFromStorage();
                if (activeConversationDM == null || ListUtils.isEmpty(conversationDMs = conversationDAO.readConversationsWithoutMessages(user.getLocalId()))) continue;
                for (ConversationDM conversationDM : conversationDMs) {
                    if (StringUtils.isEmpty(conversationDM.preConversationServerId)) continue;
                    if (preIssueConversations.contains(conversationDM.preConversationServerId)) {
                        conversationDAO.dropAndCreateDatabase();
                        domain.getUserManagerDM().resetSyncStateForAllUsers();
                        domain.getUserManagerDM().getActiveUserSetupDM().startSetup();
                        return;
                    }
                    preIssueConversations.add(conversationDM.preConversationServerId);
                }
            }
        }
    }

    private static void deleteDBLockFilesOnSDKMigration(Context context) {
        try {
            String sdPath;
            File sd;
            String kvDBLockFilePath;
            File kvFile;
            String supportDBLockFilePath = context.getFilesDir() + File.separator + "__hs_supportkvdb_lock";
            File supportFile = new File(supportDBLockFilePath);
            if (supportFile.exists()) {
                supportFile.delete();
            }
            if ((kvFile = new File(kvDBLockFilePath = context.getFilesDir() + File.separator + "__hs_kvdb_lock")).exists()) {
                kvFile.delete();
            }
            if ((sd = Environment.getExternalStoragePublicDirectory((String)(sdPath = ".backups/" + context.getPackageName() + "/helpshift/databases/"))) != null && sd.canWrite()) {
                File keyValueBackupFile;
                File profileBackupFile = new File(sd, "__hs__db_profiles");
                if (profileBackupFile.canWrite()) {
                    profileBackupFile.delete();
                }
                if ((keyValueBackupFile = new File(sd, "__hs__kv_backup")).canWrite()) {
                    keyValueBackupFile.delete();
                }
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error on deleting lock file: " + e);
        }
    }
}

