/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.app.DownloadManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageButton;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.Device;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.ConversationVM;
import com.helpshift.support.conversations.BaseConversationFragment;
import com.helpshift.support.conversations.ConversationFragmentRenderer;
import com.helpshift.support.conversations.ConversationFragmentRouter;
import com.helpshift.support.conversations.HSRecyclerViewScrollListener;
import com.helpshift.support.conversations.messages.MessagesAdapterClickListener;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IMenuItemEventListener;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import java.util.HashMap;

public class ConversationFragment
extends BaseConversationFragment
implements MessagesAdapterClickListener,
ConversationFragmentRouter,
IMenuItemEventListener,
HSRecyclerViewScrollListener.RecyclerViewScrollCallback {
    public static final String BUNDLE_ARG_CONVERSATION_LOCAL_ID = "issueId";
    public static final String BUNDLE_ARG_SHOW_CONVERSATION_HISTORY = "show_conv_history";
    public static final String FRAGMENT_TAG = "HSConversationFragment";
    private static final String TAG = "Helpshift_ConvFragment";
    private final String SHOULD_SHOW_UNREAD_MESSAGE_INDICATOR = "should_show_unread_message_indicator";
    protected ConversationFragmentRenderer renderer;
    protected boolean retainMessageBoxOnUI;
    protected Long conversationId;
    ConversationVM conversationVM;
    private String imageRefersId;
    private AttachmentMessageDM readableAttachmentMessage;
    private int lastSoftInputMode;
    private int lastWindowFlags;
    private boolean isConversationVMInitialized = false;
    private ImagePickerFile selectedImageFile;
    private String selectedImageRefersId;
    private boolean shouldUpdateAttachment;
    private RecyclerView messagesRecyclerView;
    private HSRecyclerViewScrollListener hsRecyclerViewScrollListener;

    public static ConversationFragment newInstance(Bundle bundle) {
        ConversationFragment conversationFragment = new ConversationFragment();
        conversationFragment.setArguments(bundle);
        return conversationFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.isChangingConfigurations() && this.renderer != null) {
            this.retainMessageBoxOnUI = this.renderer.isReplyBoxVisible();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.lastWindowFlags = this.getActivity().getWindow().getAttributes().flags;
        this.getActivity().getWindow().addFlags(2048);
        this.getActivity().getWindow().clearFlags(1024);
        View baseView = inflater.inflate(R.layout.hs__conversation_fragment, container, false);
        return baseView;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.conversationId = this.getArguments().getLong(BUNDLE_ARG_CONVERSATION_LOCAL_ID);
        this.inflateReplyBoxView(view);
        this.initialize(view);
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            boolean shouldShowUnreadMessageIndicator = savedInstanceState.getBoolean("should_show_unread_message_indicator");
            this.conversationVM.updateUnreadMessageCountIndicator(shouldShowUnreadMessageIndicator);
        }
        HSLogger.d(TAG, "Now showing conversation screen");
    }

    protected void inflateReplyBoxView(View view) {
        ViewStub replyBoxViewStub = (ViewStub)view.findViewById(R.id.replyBoxViewStub);
        replyBoxViewStub.setLayoutResource(R.layout.hs__conversation_replyboxview);
        replyBoxViewStub.inflate();
    }

    protected void initConversationVM() {
        this.conversationVM = HelpshiftContext.getCoreApi().getConversationViewModel(this.conversationId, this.renderer, this.retainMessageBoxOnUI);
    }

    protected void initRenderer(RecyclerView messagesRecyclerView, View confirmationBoxView, View scrollIndicator, View unreadMessagesIndicatorDot) {
        this.renderer = new ConversationFragmentRenderer(this.getContext(), messagesRecyclerView, this.getView(), confirmationBoxView, this, scrollIndicator, unreadMessagesIndicatorDot, this.getSupportFragment());
    }

    protected void initialize(View view) {
        this.messagesRecyclerView = (RecyclerView)view.findViewById(R.id.hs__messagesList);
        View confirmationBoxView = view.findViewById(R.id.hs__confirmation);
        View scrollJumperView = view.findViewById(R.id.scroll_indicator);
        View unreadIndicatorRedDot = view.findViewById(R.id.unread_indicator_red_dot);
        View unreadIndicatorRedDotImageView = view.findViewById(R.id.unread_indicator_red_dot_image_view);
        if (Build.VERSION.SDK_INT < 21) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.hs__ring);
            scrollJumperView.setBackgroundDrawable(drawable2);
            unreadIndicatorRedDot.setBackgroundDrawable(drawable2);
        }
        Styles.setDrawable(this.getContext(), unreadIndicatorRedDotImageView, R.drawable.hs__circle, R.attr.colorAccent);
        this.initRenderer(this.messagesRecyclerView, confirmationBoxView, scrollJumperView, unreadIndicatorRedDot);
        this.initConversationVM();
        this.renderer.setReplyboxListeners();
        this.retainMessageBoxOnUI = false;
        this.conversationVM.startLiveUpdates();
        this.isConversationVMInitialized = true;
        if (this.shouldUpdateAttachment) {
            this.conversationVM.sendScreenShot(this.selectedImageFile, this.selectedImageRefersId);
            this.shouldUpdateAttachment = false;
        }
        view.findViewById(R.id.resolution_accepted_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.conversationVM.markConversationResolutionStatus(true);
            }
        });
        view.findViewById(R.id.resolution_rejected_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.renderer.requestReplyFieldFocus();
                ConversationFragment.this.renderer.showKeyboard();
                ConversationFragment.this.conversationVM.markConversationResolutionStatus(false);
            }
        });
        ImageButton scrollJumpButton = (ImageButton)view.findViewById(R.id.scroll_jump_button);
        Styles.setDrawable(this.getContext(), (View)scrollJumpButton, R.drawable.hs__circle_shape_scroll_jump, R.attr.hs__composeBackgroundColor);
        Styles.setColorFilter(this.getContext(), scrollJumpButton.getDrawable(), R.attr.hs__selectableOptionColor);
        scrollJumpButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.conversationVM.onScrollJumperViewClicked();
            }
        });
        this.hsRecyclerViewScrollListener = new HSRecyclerViewScrollListener(new Handler(), this);
        this.messagesRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.hsRecyclerViewScrollListener);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.conversationVM.onResume();
        this.lastSoftInputMode = this.getActivity().getWindow().getAttributes().softInputMode;
        this.getActivity().getWindow().setSoftInputMode(16);
        if (!this.isChangingConfigurations()) {
            ConversationDM activeConversation = this.conversationVM.viewableConversation.getActiveConversation();
            String serverId = activeConversation.serverId;
            if (!StringUtils.isEmpty(serverId)) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("id", serverId);
                this.conversationVM.pushAnalyticsEvent(AnalyticsEventType.OPEN_ISSUE, data);
            }
        }
    }

    @Override
    public void onPause() {
        this.getActivity().getWindow().setSoftInputMode(this.lastSoftInputMode);
        this.renderer.hideKeyboard();
        this.conversationVM.onPause();
        super.onPause();
    }

    @Override
    protected AppSessionConstants.Screen getViewName() {
        return AppSessionConstants.Screen.CONVERSATION;
    }

    @Override
    protected int getScreenshotMode() {
        return 3;
    }

    public boolean handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction action, ImagePickerFile imagePickerFile, @Nullable String messageRefersId) {
        switch (action) {
            case SEND: {
                if (this.isConversationVMInitialized && this.conversationVM != null) {
                    this.conversationVM.sendScreenShot(imagePickerFile, messageRefersId);
                } else {
                    this.selectedImageFile = imagePickerFile;
                    this.selectedImageRefersId = messageRefersId;
                    this.shouldUpdateAttachment = true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getToolbarTitle() {
        return this.getString(R.string.hs__conversation_header);
    }

    @Override
    public void onAdminMessageLinkClicked(String url, MessageDM messageDM) {
        this.conversationVM.onAdminMessageLinkClicked(url, messageDM);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, final String textToCopy) {
        if (!StringUtils.isEmpty(textToCopy)) {
            MenuItem copyMenuItem = menu2.add(0, 0, 0, R.string.hs__copy);
            copyMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    ConversationFragment.this.copyToClipboard(textToCopy);
                    return true;
                }
            });
        }
    }

    @Override
    public void retryMessage(MessageDM messageDM) {
        this.conversationVM.retryMessage(messageDM);
    }

    @Override
    public void launchImagePicker(RequestScreenshotMessageDM message) {
        this.imageRefersId = message.serverId;
        this.conversationVM.onImageAttachmentButtonClick();
        Bundle bundle = new Bundle();
        bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
        bundle.putString("key_refers_id", this.imageRefersId);
        this.getSupportFragment().launchImagePicker(true, bundle);
    }

    @Override
    public void handleReplyReviewButtonClick(RequestAppReviewMessageDM message) {
        this.conversationVM.handleAppReviewRequestClick(message);
    }

    @Override
    public void onScreenshotMessageClicked(ScreenshotMessageDM messageDM) {
        this.conversationVM.handleScreenshotMessageClick(messageDM);
    }

    @Override
    public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM message) {
        this.checkWriteStoragePermissionAndDelegateToVM(message.isWriteStoragePermissionRequired(), message);
    }

    @Override
    public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM message) {
        this.checkWriteStoragePermissionAndDelegateToVM(true, message);
    }

    @Override
    public void onStartNewConversationButtonClick() {
        this.conversationVM.onNewConversationButtonClicked();
        this.renderer.openFreshConversationScreen();
    }

    @Override
    public void onCSATSurveySubmitted(int rating, String feedback) {
        this.conversationVM.onCSATSurveySubmitted(rating, feedback);
    }

    @Override
    public void handleOptionSelected(OptionInputMessageDM message, OptionInput.Option selectedOption, boolean isSkipped) {
    }

    @Override
    public void onAdminSuggestedQuestionSelected(MessageDM messageDM, String questionPublishId, String language) {
        this.getSupportController().onAdminSuggestedQuestionSelected(questionPublishId, language, null);
    }

    @Override
    public void onHistoryLoadingRetryClicked() {
        this.conversationVM.retryHistoryLoadingMessages();
    }

    private void checkWriteStoragePermissionAndDelegateToVM(boolean isWriteStoragePermissionRequired, AttachmentMessageDM message) {
        this.readableAttachmentMessage = null;
        if (isWriteStoragePermissionRequired) {
            Device device = HelpshiftContext.getPlatform().getDevice();
            switch (device.checkPermission(Device.PermissionType.WRITE_STORAGE)) {
                case AVAILABLE: {
                    this.conversationVM.handleAdminAttachmentMessageClick(message);
                    break;
                }
                case UNAVAILABLE: {
                    this.startDownloadWithSystemService(message.attachmentUrl);
                    break;
                }
                case REQUESTABLE: {
                    this.readableAttachmentMessage = message;
                    this.requestWriteExternalStoragePermission(true);
                }
            }
        } else {
            this.conversationVM.handleAdminAttachmentMessageClick(message);
        }
    }

    @Override
    protected void onPermissionGranted(int requestCode) {
        switch (requestCode) {
            case 2: {
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                bundle.putString("key_refers_id", this.imageRefersId);
                this.getSupportFragment().launchImagePicker(false, bundle);
                break;
            }
            case 3: {
                if (this.readableAttachmentMessage == null) break;
                this.conversationVM.handleAdminAttachmentMessageClick(this.readableAttachmentMessage);
                this.readableAttachmentMessage = null;
            }
        }
    }

    private void startDownloadWithSystemService(String url) {
        DownloadManager downloadManager = (DownloadManager)this.getContext().getSystemService("download");
        if (downloadManager == null) {
            return;
        }
        Uri attachmentUri = Uri.parse((String)url);
        DownloadManager.Request request = new DownloadManager.Request(attachmentUri);
        request.setNotificationVisibility(1);
        downloadManager.enqueue(request);
        if (!this.isDetached()) {
            SnackbarUtil.showSnackbar(this.getView(), R.string.hs__starting_download, -1);
        }
    }

    @Override
    public void openFreshConversationScreen() {
        this.getSupportFragment().getSupportController().startConversationFlow();
    }

    public void onDetach() {
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getConversationInboxPoller().startAppPoller(true);
        }
        super.onDetach();
    }

    @Override
    public void onDestroyView() {
        if (this.getActivity() != null) {
            this.getActivity().getWindow().clearFlags(2048);
            this.getActivity().getWindow().setFlags(this.lastWindowFlags, this.lastWindowFlags);
        }
        this.isConversationVMInitialized = false;
        this.conversationVM.setConversationViewState(-1);
        this.renderer.unregisterFragmentRenderer();
        this.conversationVM.unregisterRenderer();
        this.renderer.destroy();
        this.messagesRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.hsRecyclerViewScrollListener);
        this.messagesRecyclerView = null;
        super.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("should_show_unread_message_indicator", this.conversationVM.shouldShowUnreadMessagesIndicator());
    }

    public void startLiveUpdates() {
        if (this.conversationVM != null) {
            this.conversationVM.startLiveUpdates();
        }
    }

    public void stopLiveUpdates() {
        if (this.conversationVM != null) {
            this.conversationVM.stopLiveUpdates();
        }
    }

    @Override
    public void onCreateOptionMenuCalled() {
        this.conversationVM.renderMenuItems();
    }

    @Override
    public void onMenuItemClicked(HSMenuItemType type) {
        switch (type) {
            case SCREENSHOT_ATTACHMENT: {
                this.imageRefersId = null;
                this.conversationVM.onImageAttachmentButtonClick();
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                bundle.putString("key_refers_id", null);
                this.getSupportFragment().launchImagePicker(true, bundle);
            }
        }
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        if (charSequence != null && !StringUtils.isEmpty(charSequence.toString())) {
            this.renderer.enableSendReplyButton();
        } else {
            this.renderer.disableSendReplyButton();
        }
    }

    @Override
    public void onSendButtonClick() {
        this.conversationVM.sendTextMessage();
    }

    @Override
    public void onSkipClick() {
        this.conversationVM.onSkipClick();
    }

    @Override
    public void retryPreIssueCreation() {
    }

    @Override
    public void onAuthenticationFailure() {
        this.getSupportController().onAuthenticationFailure();
    }

    @Override
    public void onScrolledToTop() {
        this.conversationVM.onScrolledToTop();
    }

    @Override
    public void onScrolledToBottom() {
        this.conversationVM.onScrolledToBottom();
    }

    @Override
    public void onScrolling() {
        this.conversationVM.onScrolling();
    }
}

